/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class TableRowSelectorTask
extends AbstractTask {
    private final CyServiceRegistrar registrar;
    private final SearchResults searchResults;
    private final CyTable table;

    public TableRowSelectorTask(CyServiceRegistrar registrar, CyTable table, SearchResults searchResults) {
        this.registrar = registrar;
        this.searchResults = searchResults;
        this.table = table;
    }

    public void run(TaskMonitor tm) {
        CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
        CyTableView tableView = tableViewManager.getTableView(this.table);
        if (tableView == null) {
            return;
        }
        List<String> tableHits = this.searchResults.getResultsFor(this.table);
        if (tableHits == null || tableHits.isEmpty()) {
            return;
        }
        HashSet<String> hitsSet = new HashSet<String>(tableHits);
        for (CyColumn col : this.table.getColumns()) {
            View colView = tableView.getColumnView(col);
            if (colView == null) continue;
            colView.setLockedValue(BasicTableVisualLexicon.COLUMN_SELECTED, (Object)true);
        }
        CyColumn keyCol = this.table.getPrimaryKey();
        for (Object key : keyCol.getValues(keyCol.getType())) {
            CyRow row = this.table.getRow(key);
            View rowView = tableView.getRowView(row);
            if (rowView == null) continue;
            String keyStr = String.valueOf(key);
            boolean selected = hitsSet.contains(keyStr);
            rowView.setLockedValue(BasicTableVisualLexicon.ROW_SELECTED, (Object)selected);
        }
    }
}

