/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTask
extends AbstractTask
implements ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected static final int MAX_QUERY_LEN = 65536;
    private final String queryString;
    private final SearchManager searchManager;
    private final CyTable[] tables;
    private SearchResults results;

    public SearchTask(SearchManager searchManager, String queryString, CyTable ... tables) {
        this.queryString = Objects.requireNonNull(queryString);
        this.searchManager = Objects.requireNonNull(searchManager);
        this.tables = tables;
    }

    public void run(TaskMonitor tm) {
        this.runQuery(tm);
    }

    public SearchResults runQuery(TaskMonitor tm) {
        tm.setTitle("Searching the network for: " + this.queryString);
        if (this.queryString.length() > 65536) {
            logger.error(this.results.getErrorMessage());
            return SearchResults.syntaxError("At " + this.queryString.length() + " characters query string is too large");
        }
        if (this.queryString.isBlank()) {
            return SearchResults.empty();
        }
        tm.setProgress(1.0);
        SearchResults results = SearchResults.empty();
        for (CyTable table : this.tables) {
            if (this.cancelled) {
                return SearchResults.cancelled();
            }
            SearchResults tableResults = this.searchTable(tm, table);
            if (tableResults.isError()) {
                return tableResults;
            }
            results = results.compose(tableResults);
        }
        if (this.cancelled) {
            return SearchResults.cancelled();
        }
        tm.setProgress(1.0);
        this.results = results;
        return this.results;
    }

    private SearchResults searchTable(TaskMonitor tm, CyTable table) {
        List<String> ids;
        Query query;
        boolean first = true;
        if (!this.searchManager.isIndexable(table)) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Table cannot be searched");
            return SearchResults.fatalError();
        }
        while (!this.searchManager.isReady(table)) {
            if (first) {
                tm.setStatusMessage("Waiting for index to be ready.");
                first = false;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.cancelled) continue;
            return SearchResults.cancelled();
        }
        tm.setStatusMessage("Running search query on table " + table.getTitle());
        try {
            query = this.searchManager.getQueryParser(table).parse(this.queryString);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return SearchResults.syntaxError();
        }
        IndexReader reader = null;
        try {
            reader = this.searchManager.getIndexReader(table);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return SearchResults.fatalError();
        }
        try {
            ids = SearchTask.runSearch(reader, query);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return SearchResults.fatalError();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return SearchResults.results(table, ids);
    }

    private static List<String> runSearch(IndexReader reader, Query query) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        TopDocs docs = searcher.search(query, 10000000);
        ArrayList<String> ids = new ArrayList<String>(docs.scoreDocs.length);
        for (ScoreDoc sd : docs.scoreDocs) {
            Document doc = reader.document(sd.doc);
            String eleID = doc.get("CY_SEARCH2_INDEX");
            ids.add(eleID);
        }
        return ids;
    }

    public <R> R getResults(Class<? extends R> type) {
        if (SearchResults.class.equals(type)) {
            return type.cast(this.results);
        }
        return null;
    }
}

