/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;

public class SearchResults {
    private final Status status;
    private final String errorMessage;
    private final Map<Long, List<String>> resultsMap = new HashMap<Long, List<String>>();

    private SearchResults(Status status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void addResults(Long tableSUID, List<String> results) {
        this.resultsMap.put(tableSUID, results);
    }

    public void addResults(CyTable table, List<String> results) {
        this.resultsMap.put(table.getSUID(), results);
    }

    public List<String> getResultsFor(Long tableSUID) {
        return this.resultsMap.get(tableSUID);
    }

    public List<String> getResultsFor(CyTable table) {
        return this.resultsMap.get(table.getSUID());
    }

    public int getHitCount(Long tableSUID) {
        List<String> list = this.resultsMap.get(tableSUID);
        return list == null ? 0 : list.size();
    }

    public int getHitCount(CyTable table) {
        return this.getHitCount(table.getSUID());
    }

    public static SearchResults syntaxError() {
        return new SearchResults(Status.ERROR_SYNTAX, "Cannot execute search query");
    }

    public static SearchResults syntaxError(String message) {
        return new SearchResults(Status.ERROR_SYNTAX, message);
    }

    public static SearchResults fatalError() {
        return new SearchResults(Status.ERROR_FATAL, "Query execution error");
    }

    public static SearchResults fatalError(String message) {
        return new SearchResults(Status.ERROR_FATAL, message);
    }

    public static SearchResults empty() {
        return new SearchResults(Status.SUCCESS, null);
    }

    public static SearchResults cancelled() {
        return new SearchResults(Status.CANCELLED, null);
    }

    public static SearchResults networkResults(CyNetwork network, List<String> nodeHits, List<String> edgeHits) {
        SearchResults results = new SearchResults(Status.SUCCESS, null);
        results.addResults(network.getDefaultNodeTable(), nodeHits);
        results.addResults(network.getDefaultEdgeTable(), edgeHits);
        return results;
    }

    public static SearchResults results(CyTable table, List<String> keys) {
        SearchResults results = new SearchResults(Status.SUCCESS, null);
        results.addResults(table.getSUID(), keys);
        return results;
    }

    public SearchResults compose(SearchResults that) {
        if (this.isError()) {
            return this;
        }
        if (that.isError()) {
            return that;
        }
        SearchResults results = SearchResults.empty();
        for (Map.Entry<Long, List<String>> entry : this.resultsMap.entrySet()) {
            results.addResults(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Long, List<String>> entry : that.resultsMap.entrySet()) {
            results.addResults(entry.getKey(), entry.getValue());
        }
        return results;
    }

    public boolean isError() {
        return this.status == Status.ERROR_FATAL || this.status == Status.ERROR_SYNTAX;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "SearchResults [status=" + this.status + ", resultsMap=" + this.resultsMap + "]";
    }

    public static enum Status {
        SUCCESS,
        ERROR_SYNTAX,
        ERROR_FATAL,
        CANCELLED;

    }
}

