/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAndEdgeSelectorTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(NodeAndEdgeSelectorTask.class);
    public static final long UNSET_NETWORK_CHECK_CANCEL_FREQ = 50000L;
    public static final int PROGRESS_UPDATE_FREQ = 10000;
    private final CyNetwork network;
    private final SearchResults searchResults;

    public NodeAndEdgeSelectorTask(CyNetwork network, SearchResults searchResults) {
        this.network = network;
        this.searchResults = searchResults;
    }

    public void run(TaskMonitor tm) {
        this.selectNodesAndEdges(tm);
    }

    public void selectNodesAndEdges(TaskMonitor tm) {
        int edgeHitCount;
        if (this.network == null || this.network.getNodeList().size() == 0) {
            return;
        }
        List<String> nodeHits = this.searchResults.getResultsFor(this.network.getDefaultNodeTable());
        List<String> edgeHits = this.searchResults.getResultsFor(this.network.getDefaultEdgeTable());
        int nodeHitCount = nodeHits == null ? 0 : nodeHits.size();
        int n = edgeHitCount = edgeHits == null ? 0 : edgeHits.size();
        if (nodeHitCount == 0 && edgeHitCount == 0) {
            tm.setStatusMessage("Could not find any match.");
            this.unselectNodesAndEdges(tm);
            tm.setTitle("Search Finished");
            tm.setProgress(1.0);
            return;
        }
        if (!this.unselectNodesAndEdges(tm)) {
            return;
        }
        String nodeplural = "s";
        if (nodeHitCount == 1) {
            nodeplural = "";
        }
        String edgeplural = "s";
        if (edgeHitCount == 1) {
            edgeplural = "";
        }
        tm.setStatusMessage("Selecting " + nodeHitCount + " node" + nodeplural + " and " + edgeHitCount + " edge" + edgeplural);
        int totalHitCount = nodeHitCount + edgeHitCount;
        long startTime = System.currentTimeMillis();
        this.selectNodes(nodeHits, nodeHitCount, totalHitCount, tm);
        this.selectEdges(edgeHits, edgeHitCount, totalHitCount, tm);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Selecting " + nodeHitCount + " nodes and " + edgeHitCount + " edges completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
    }

    private boolean unselectNodes(TaskMonitor taskMonitor) {
        taskMonitor.setStatusMessage("Unsetting any existing selected nodes");
        long startTime = System.currentTimeMillis();
        Collection suids = this.network.getDefaultNodeTable().getMatchingKeys("selected", (Object)true, Long.class);
        long counter = 0L;
        int numNodes = suids.size();
        taskMonitor.setProgress(0.0);
        for (Long suid : suids) {
            CyNode n = this.network.getNode(suid.longValue());
            if (n == null) continue;
            this.network.getRow((CyIdentifiable)n).set("selected", (Object)false);
            if (++counter % 50000L == 0L && this.cancelled) {
                return false;
            }
            if (counter % 10000L != 0L) continue;
            taskMonitor.setProgress((double)counter / (double)numNodes);
        }
        taskMonitor.setStatusMessage("Unsetting any existing selected nodes completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        return true;
    }

    private boolean unselectEdges(TaskMonitor taskMonitor) {
        taskMonitor.setStatusMessage("Unsetting any existing selected edges");
        long startTime = System.currentTimeMillis();
        Collection suids = this.network.getDefaultEdgeTable().getMatchingKeys("selected", (Object)true, Long.class);
        long counter = 0L;
        taskMonitor.setProgress(0.0);
        int numEdges = suids.size();
        for (Long suid : suids) {
            CyEdge e = this.network.getEdge(suid.longValue());
            if (e == null) continue;
            this.network.getRow((CyIdentifiable)e).set("selected", (Object)false);
            if (++counter % 50000L == 0L && this.cancelled) {
                return false;
            }
            if (counter % 10000L != 0L) continue;
            taskMonitor.setProgress((double)counter / (double)numEdges);
        }
        taskMonitor.setStatusMessage("Unsetting any existing selected edges completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        return true;
    }

    private boolean unselectNodesAndEdges(TaskMonitor taskMonitor) {
        if (!this.unselectNodes(taskMonitor)) {
            return false;
        }
        return this.unselectEdges(taskMonitor);
    }

    private void selectNodes(List<String> nodeHits, int nodeHitCount, int totalHitCount, TaskMonitor taskMonitor) {
        if (nodeHits == null) {
            return;
        }
        Iterator<String> nodeIt = nodeHits.iterator();
        int counter = 0;
        taskMonitor.setProgress(0.0);
        while (nodeIt.hasNext() && !this.cancelled) {
            int currESPIndex = Integer.parseInt(nodeIt.next());
            CyNode currNode = this.network.getNode((long)currESPIndex);
            if (currNode != null) {
                this.network.getRow((CyIdentifiable)currNode).set("selected", (Object)true);
            } else {
                logger.warn("Unknown node identifier " + currESPIndex);
            }
            if (++counter % 10000 != 0) continue;
            taskMonitor.setProgress((double)(counter / totalHitCount));
        }
    }

    private void selectEdges(List<String> edgeHits, int edgeHitCount, int totalHitCount, TaskMonitor taskMonitor) {
        if (edgeHits == null) {
            return;
        }
        Iterator<String> edgeIt = edgeHits.iterator();
        int counter = totalHitCount - edgeHitCount;
        while (edgeIt.hasNext() && !this.cancelled) {
            int currESPIndex = Integer.parseInt(edgeIt.next());
            CyEdge currEdge = this.network.getEdge((long)currESPIndex);
            if (currEdge != null) {
                this.network.getRow((CyIdentifiable)currEdge).set("selected", (Object)true);
            } else {
                logger.warn("Unknown edge identifier " + currESPIndex);
            }
            if (++counter % 10000 != 0) continue;
            taskMonitor.setProgress((double)(counter / totalHitCount));
        }
    }
}

