/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.search;

import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.search.NodeAndEdgeSelectorTask;
import org.cytoscape.search.internal.search.SearchResults;
import org.cytoscape.search.internal.search.SearchTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class NetworkTableSearchTask
extends SearchTask {
    private final CyNetwork network;

    public NetworkTableSearchTask(SearchManager searchManager, String queryString, CyNetwork network, CyTable table) {
        super(searchManager, queryString, table);
        this.network = network;
    }

    public NetworkTableSearchTask(SearchManager searchManager, String queryString, CyNetwork network) {
        super(searchManager, queryString, network.getDefaultNodeTable(), network.getDefaultEdgeTable());
        this.network = network;
    }

    @Override
    public void run(TaskMonitor tm) {
        SearchResults results = super.runQuery(tm);
        this.insertTasksAfterCurrentTask(new Task[]{new NodeAndEdgeSelectorTask(this.network, results)});
    }

    @Override
    public <R> R getResults(Class<? extends R> type) {
        if (String.class.equals(type)) {
            SearchResults results = super.getResults(SearchResults.class);
            return type.cast(this.getPopupMessage(results));
        }
        return super.getResults(type);
    }

    private String getPopupMessage(SearchResults results) {
        String edgeplural;
        if (results.isError() || results.getErrorMessage() != null) {
            return results.getErrorMessage();
        }
        int edges = results.getHitCount(this.network.getDefaultEdgeTable());
        int nodes = results.getHitCount(this.network.getDefaultNodeTable());
        if (nodes == 0 && edges == 0) {
            return "Selected 0 nodes and 0 edges";
        }
        String nodeplural = nodes == 1 ? "" : "s";
        String string = edgeplural = edges == 1 ? "" : "s";
        if (nodes == 0) {
            return "Selected " + edges + " edge" + edgeplural;
        }
        if (edges == 0) {
            return "Selected " + nodes + " node" + nodeplural;
        }
        return "Selected " + nodes + " node" + nodeplural + " and " + edges + " edge" + edgeplural;
    }
}

