/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.progress;

import org.cytoscape.search.internal.progress.DiscreteProgressMonitor;
import org.cytoscape.search.internal.progress.SubProgressMonitor;

public interface ProgressMonitor {
    public void addProgress(double var1);

    public void done();

    public static ProgressMonitor nullMonitor() {
        return new ProgressMonitor(){

            @Override
            public void addProgress(double progress) {
            }

            @Override
            public void done() {
            }
        };
    }

    default public DiscreteProgressMonitor toDiscrete(int totalWork) {
        return new DiscreteProgressMonitor(this, totalWork);
    }

    default public ProgressMonitor subProgressMonitor(double percent) {
        return new SubProgressMonitor(this, percent);
    }

    default public ProgressMonitor[] split(double ... parts) {
        double sum = 0.0;
        for (double part : parts) {
            sum += part;
        }
        ProgressMonitor[] monitors = new ProgressMonitor[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            double percent = parts[i] / sum;
            monitors[i] = this.subProgressMonitor(percent);
        }
        return monitors;
    }
}

