/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.progress;

import org.cytoscape.search.internal.progress.ProgressMonitor;

public class DiscreteProgressMonitor {
    private final ProgressMonitor wrapped;
    private final int totalWork;
    private int currentWork;

    DiscreteProgressMonitor(ProgressMonitor wrapped, int totalWork) {
        this.wrapped = wrapped;
        this.totalWork = totalWork;
    }

    public void addWork(int workToAdd) {
        double progress = (double)workToAdd / (double)this.totalWork;
        this.wrapped.addProgress(progress);
        this.currentWork += workToAdd;
    }

    public void increment() {
        this.addWork(1);
    }

    public void done() {
        if (this.totalWork > 0) {
            this.wrapped.addProgress((double)(this.totalWork - this.currentWork) / (double)this.totalWork);
        }
    }
}

