/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.index;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.search.internal.index.Index;
import org.cytoscape.search.internal.index.TableType;
import org.cytoscape.search.internal.progress.DiscreteProgressMonitor;
import org.cytoscape.search.internal.progress.ProgressMonitor;

public class TableIndexer {
    public static void indexTable(Index index, CyTable table, ProgressMonitor pm) throws IOException {
        DiscreteProgressMonitor dpm = pm.toDiscrete(table.getRowCount());
        CyColumn keyCol = table.getPrimaryKey();
        String keyName = keyCol.getName();
        Class keyType = keyCol.getType();
        IndexWriter writer = index.getWriter();
        for (CyRow row : table.getAllRows()) {
            Object key = row.get(keyName, keyType);
            Document doc = TableIndexer.createDocument(table, key, index.getTableType());
            if (doc != null) {
                writer.addDocument((Iterable)doc);
            }
            dpm.increment();
        }
        writer.commit();
        dpm.done();
    }

    public static void updateRows(Index index, CyTable table, Collection<? extends Object> keys, ProgressMonitor pm) throws IOException {
        DiscreteProgressMonitor dpm = pm.toDiscrete(table.getRowCount());
        IndexWriter writer = index.getWriter();
        for (Object object : keys) {
            Term term = new Term("CY_SEARCH2_INDEX", String.valueOf(object));
            Document doc = TableIndexer.createDocument(table, object, index.getTableType());
            if (doc == null) {
                writer.deleteDocuments(new Term[]{term});
            } else {
                writer.updateDocument(term, (Iterable)doc);
            }
            dpm.increment();
        }
        writer.commit();
        dpm.done();
    }

    private static Document createDocument(CyTable table, Object key, TableType type) {
        if (!table.rowExists(key)) {
            return null;
        }
        Document doc = new Document();
        String identifier = String.valueOf(key);
        doc.add((IndexableField)new StringField("CY_SEARCH2_INDEX", identifier, Field.Store.YES));
        doc.add((IndexableField)new StringField("CY_SEARCH2_TYPE", type.name(), Field.Store.YES));
        Set attributeNames = CyTableUtil.getColumnNames((CyTable)table);
        for (String attrName : attributeNames) {
            if (attrName == null || Objects.equals("selected", attrName)) continue;
            TableIndexer.indexField(doc, table, attrName, key);
        }
        return doc;
    }

    private static void indexField(Document doc, CyTable table, String attrName, Object key) {
        List attrValueList;
        CyColumn column = table.getColumn(attrName);
        Class valueType = column.getType();
        CyRow row = table.getRow(key);
        if (valueType == String.class) {
            String attrValue = (String)row.get(attrName, String.class);
            if (attrValue != null) {
                doc.add((IndexableField)new TextField(attrName, attrValue, Field.Store.NO));
            }
        } else if (valueType == Integer.class) {
            Integer attrValue = (Integer)row.get(attrName, Integer.class);
            if (attrValue != null) {
                doc.add((IndexableField)new IntPoint(attrName, new int[]{attrValue}));
            }
        } else if (valueType == Long.class) {
            Long attrValue = (Long)row.get(attrName, Long.class);
            if (attrValue != null) {
                doc.add((IndexableField)new LongPoint(attrName, new long[]{attrValue}));
            }
        } else if (valueType == Double.class) {
            Double attrValue = (Double)row.get(attrName, Double.class);
            if (attrValue != null) {
                doc.add((IndexableField)new DoublePoint(attrName, new double[]{attrValue}));
            }
        } else if (valueType == Boolean.class) {
            Boolean attrValue = (Boolean)row.get(attrName, Boolean.class);
            if (attrValue != null) {
                doc.add((IndexableField)new StringField(attrName, String.valueOf(attrValue), Field.Store.NO));
            }
        } else if (valueType == List.class && (attrValueList = (List)row.get(attrName, List.class)) != null) {
            Class listElementType = column.getListElementType();
            for (Object attrValue : attrValueList) {
                if (attrValue == null) continue;
                if (listElementType == String.class) {
                    doc.add((IndexableField)new TextField(attrName, (String)attrValue, Field.Store.NO));
                    continue;
                }
                if (listElementType == Integer.class) {
                    doc.add((IndexableField)new IntPoint(attrName, new int[]{(Integer)attrValue}));
                    continue;
                }
                if (listElementType == Long.class) {
                    doc.add((IndexableField)new LongPoint(attrName, new long[]{(Long)attrValue}));
                    continue;
                }
                if (listElementType == Double.class) {
                    doc.add((IndexableField)new DoublePoint(attrName, new double[]{(Double)attrValue}));
                    continue;
                }
                if (listElementType != Boolean.class) continue;
                doc.add((IndexableField)new StringField(attrName, String.valueOf(attrValue), Field.Store.NO));
            }
        }
    }
}

