/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.index;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.cytoscape.model.CyTable;
import org.cytoscape.search.internal.index.AttributeFields;
import org.cytoscape.search.internal.index.CaseInsensitiveWhitespaceAnalyzer;
import org.cytoscape.search.internal.index.CustomMultiFieldQueryParser;
import org.cytoscape.search.internal.index.TableType;

public class Index {
    private final Long tableSuid;
    private final Path indexPath;
    private final TableType type;
    private IndexWriter indexWriter;

    public Index(Long tableSuid, TableType type, Path indexPath) {
        this.tableSuid = tableSuid;
        this.type = type;
        this.indexPath = indexPath;
    }

    public Long getTableSUID() {
        return this.tableSuid;
    }

    public TableType getTableType() {
        return this.type;
    }

    public Path getPath() {
        return this.indexPath;
    }

    private IndexWriterConfig getIndexWriterConfig(IndexWriterConfig.OpenMode openMode) {
        CaseInsensitiveWhitespaceAnalyzer analyzer = new CaseInsensitiveWhitespaceAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        iwc.setOpenMode(openMode);
        return iwc;
    }

    public IndexWriter getWriter() throws IOException {
        if (this.indexWriter == null) {
            FSDirectory dir = FSDirectory.open((Path)this.indexPath);
            IndexWriterConfig iwc = this.getIndexWriterConfig(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.indexWriter = new IndexWriter((Directory)dir, iwc);
        }
        return this.indexWriter;
    }

    public IndexReader getIndexReader() throws IOException {
        IndexWriter writer = this.getWriter();
        return DirectoryReader.open((IndexWriter)writer, (boolean)true, (boolean)false);
    }

    public QueryParser getQueryParser(CyTable table) {
        CaseInsensitiveWhitespaceAnalyzer analyser = new CaseInsensitiveWhitespaceAnalyzer();
        AttributeFields fields = new AttributeFields(table);
        CustomMultiFieldQueryParser parser = new CustomMultiFieldQueryParser(fields, analyser);
        return parser;
    }
}

