/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;

public class AttributeFields {
    private final Map<String, Class<?>> columnTypeMap = new HashMap();
    private final Map<String, Set<String>> altNameMap = new HashMap<String, Set<String>>();

    public AttributeFields(CyNetwork network) {
        this.initFields(network.getDefaultNodeTable());
        this.initFields(network.getDefaultEdgeTable());
    }

    public AttributeFields(CyTable table) {
        this.initFields(table);
    }

    private void initFields(CyTable table) {
        for (CyColumn column : table.getColumns()) {
            String uniqueName = column.getName();
            Class<?> type = AttributeFields.getType(column);
            this.columnTypeMap.putIfAbsent(uniqueName, type);
            String lower = uniqueName.toLowerCase();
            this.altNameMap.computeIfAbsent(lower, k -> new HashSet()).add(uniqueName);
            String nameOnly = column.getNameOnly().toLowerCase();
            if (uniqueName.equals(nameOnly)) continue;
            this.altNameMap.computeIfAbsent(nameOnly, k -> new HashSet()).add(uniqueName);
        }
    }

    private static Class<?> getType(CyColumn column) {
        Class type = column.getType();
        if (type == List.class) {
            type = column.getListElementType();
        }
        return type;
    }

    public String[] getFields() {
        return (String[])this.columnTypeMap.keySet().toArray(String[]::new);
    }

    public Class<?> getType(String fullName) {
        return this.columnTypeMap.get(fullName);
    }

    public Set<String> getAltNames(String fieldName) {
        return this.altNameMap.getOrDefault(fieldName, Collections.emptySet());
    }

    public String toString() {
        return "AttributeFields [columnTypeMap=" + this.columnTypeMap + ", altNameMap=" + this.altNameMap + "]";
    }
}

