/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.awt.Font;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.Icon;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.search.internal.index.SearchManager;
import org.cytoscape.search.internal.ui.NetworkSearchBox;
import org.cytoscape.search.internal.ui.NetworkSearchToolbarComponent;
import org.cytoscape.search.internal.ui.NetworkTableSearchAction;
import org.cytoscape.search.internal.ui.debug.DebugSearchProgressPanel;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    public static final int ICON_WIDTH = 24;
    public static final int ICON_HEIGHT = 24;
    public static final float ICON_FONT_SIZE = 18.0f;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private SearchManager searchManager;

    public void start(BundleContext bc) {
        Path baseDir;
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        try {
            baseDir = Files.createTempDirectory("org.cytoscape.search.search2_impl_", new FileAttribute[0]);
            baseDir.toFile().deleteOnExit();
            logger.info("Search index folder: " + baseDir);
        }
        catch (IOException e) {
            logger.error("Could not start search2-impl bundle. Cannot create temp folder for index files.", (Throwable)e);
            return;
        }
        this.searchManager = new SearchManager(registrar, baseDir);
        this.registerAllServices(bc, this.searchManager);
        this.registerService(bc, this.searchManager, SearchManager.class);
        NetworkSearchBox searchBox = new NetworkSearchBox(registrar, this.searchManager);
        NetworkSearchToolbarComponent toolbarComponent = new NetworkSearchToolbarComponent(searchBox);
        this.registerService(bc, toolbarComponent, ToolBarComponent.class);
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        Font iconFont = iconManager.getIconFont(18.0f);
        TextIcon icon = new TextIcon("\uf002", iconFont, 24, 24);
        NetworkTableSearchAction tableSearchAction = new NetworkTableSearchAction(registrar, this.searchManager, (Icon)icon, 0.0055f);
        this.registerService(bc, (Object)tableSearchAction, CyAction.class);
        if (DebugSearchProgressPanel.showDebugPanel(registrar)) {
            DebugSearchProgressPanel debugPanel = new DebugSearchProgressPanel();
            this.searchManager.addProgressViewer(debugPanel);
            this.registerService(bc, debugPanel, CytoPanelComponent.class);
        }
    }

    public void shutDown() {
        if (this.searchManager != null) {
            try {
                this.searchManager.disposeAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

