/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.cytoscape.cycl.CyCLContext;
import org.cytoscape.cycl.CyCLDevice;
import org.cytoscape.cycl.CyCLException;
import org.cytoscape.cycl.CyCLKernel;
import org.cytoscape.cycl.CyCLProgram;
import org.cytoscape.cycl.internal.CyCLContextImpl;
import org.cytoscape.cycl.internal.CyCLKernelImpl;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLProgramCallback;
import org.lwjgl.opencl.CLProgramCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CyCLProgramImpl
implements CyCLProgram {
    private Boolean finalized = false;
    private long program;
    private Hashtable<String, CyCLKernelImpl> kernels = new Hashtable();
    private HashMap<String, String> defines;

    public CyCLProgramImpl(CyCLContext context, CyCLDevice device, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) throws IOException {
        InputStream programTextStream = resourcePath.openStream();
        Scanner programTextScanner = new Scanner(programTextStream, "UTF-8");
        String programText = programTextScanner.useDelimiter("\\Z").next();
        programTextScanner.close();
        programTextStream.close();
        this.prepareAndBuildProgram(context, device, new String[]{programText}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgramImpl(CyCLContext context, CyCLDevice device, String source, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        this.prepareAndBuildProgram(context, device, new String[]{source}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgramImpl(CyCLContext context, CyCLDevice device, String[] sources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        this.prepareAndBuildProgram(context, device, sources, kernelNames, defines, silentCompilation);
    }

    private void prepareAndBuildProgram(CyCLContext context, CyCLDevice device, String[] sources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        try {
            this.defines = defines;
            StringBuilder buildOptions = new StringBuilder();
            if (defines != null) {
                for (Map.Entry<String, String> entry : defines.entrySet()) {
                    if (entry.getValue() == null) {
                        buildOptions.append(" -D").append(entry.getKey());
                        continue;
                    }
                    buildOptions.append(" -D").append(entry.getKey()).append("=").append(entry.getValue());
                }
            }
            IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
            this.program = CL10.clCreateProgramWithSource((long)context.getContext(), (CharSequence[])sources, (IntBuffer)errorBuffer);
            CyCLUtils.checkCLError(errorBuffer.get(0));
            CountDownLatch latch = new CountDownLatch(1);
            CLProgramCallback buildCallback = CLProgramCallback.create((program, user_data) -> {
                System.out.println(String.format("The cl_program [0x%X] was built %s", program, this.getProgramBuildInfoInt(device.getDevice(), 4481) == 0 ? "successfully" : "unsuccessfully"));
                String log = this.getProgramBuildInfoStringASCII(device.getDevice(), 4483);
                if (!log.isEmpty()) {
                    System.out.println(String.format("BUILD LOG:\n----\n%s\n-----", log));
                }
                latch.countDown();
            });
            int errcode = CL11.clBuildProgram((long)this.program, (long)device.getDevice(), (CharSequence)buildOptions, (CLProgramCallbackI)buildCallback, (long)0L);
            CyCLUtils.checkCLError(errcode);
            for (String kernelName : kernelNames) {
                this.kernels.put(kernelName, new CyCLKernelImpl((CyCLContextImpl)context, this, kernelName));
            }
        }
        catch (Exception exc) {
            if (!silentCompilation && this.program != 0L) {
                System.out.println(this.getBuildInfoString(device, 4483));
            }
            System.out.println("Could not create CL program");
            throw new CyCLException("Could not create CL program", (Throwable)exc);
        }
        System.out.println("Program built");
    }

    public long getProgram() {
        return this.program;
    }

    public CyCLKernel getKernel(String name) {
        return this.kernels.get(name);
    }

    public String getBuildInfoString(CyCLDevice device, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetProgramBuildInfo((long)this.program, (long)device.getDevice(), (int)param_name, (IntBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL11.clGetProgramBuildInfo((long)this.program, (long)device.getDevice(), (int)param_name, (ByteBuffer)buffer, null));
            String string = buffer.toString();
            return string;
        }
    }

    public String getProgramBuildInfoStringASCII(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetProgramBuildInfo((long)this.program, (long)cl_device_id, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL11.clGetProgramBuildInfo((long)this.program, (long)cl_device_id, (int)param_name, (ByteBuffer)buffer, null));
            String string = MemoryUtil.memASCII((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    public int getProgramBuildInfoInt(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            CyCLUtils.checkCLError(CL11.clGetProgramBuildInfo((long)this.program, (long)cl_device_id, (int)param_name, (IntBuffer)pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            for (Map.Entry<String, CyCLKernelImpl> entry : this.kernels.entrySet()) {
                entry.getValue().finalize();
            }
            this.kernels.clear();
            CyCLUtils.checkCLError(CL10.clReleaseProgram((long)this.program));
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLProgram " + this.program + ": " + exc.getMessage());
            throw new CyCLException("Could not finalize CyCLProgram object.");
        }
    }
}

