/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.cycl.CyCLPlatform;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

class CyCLPlatformImpl
implements CyCLPlatform {
    static List<CyCLPlatform> allPlatforms = null;
    long cl_platform_id;
    CLCapabilities capabilities = null;
    String name = null;
    MemoryStack stack;
    PointerBuffer ctxProps = null;
    long[] device_ids = null;

    public CyCLPlatformImpl(long platform) {
        this.cl_platform_id = platform;
        this.stack = MemoryStack.stackPush();
        this.name = this.getPlatformInfoStringUTF8(2306);
    }

    public String getName() {
        return this.name;
    }

    public CLCapabilities getCapabilities() {
        if (this.capabilities != null) {
            return this.capabilities;
        }
        this.capabilities = CL.createPlatformCapabilities((long)this.cl_platform_id);
        return this.capabilities;
    }

    public PointerBuffer getContextProps() {
        this.ctxProps = this.stack.mallocPointer(3);
        this.ctxProps.put(0, 4228L).put(1, this.cl_platform_id).put(2, 0L);
        return this.ctxProps;
    }

    public long[] getDevices(int type) {
        if (this.device_ids != null) {
            return this.device_ids;
        }
        try {
            IntBuffer pi = this.stack.mallocInt(1);
            CyCLUtils.checkCLError(CL11.clGetDeviceIDs((long)this.cl_platform_id, (long)type, null, (IntBuffer)pi));
            PointerBuffer devices = this.stack.mallocPointer(pi.get(0));
            CyCLUtils.checkCLError(CL11.clGetDeviceIDs((long)this.cl_platform_id, (long)type, (PointerBuffer)devices, (IntBuffer)null));
            this.device_ids = new long[pi.get(0)];
            for (int d = 0; d < devices.capacity(); ++d) {
                this.device_ids[d] = devices.get(d);
            }
        }
        catch (Exception e) {
            this.device_ids = null;
        }
        return this.device_ids;
    }

    public String getPlatformInfoStringASCII(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetPlatformInfo((long)this.cl_platform_id, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL11.clGetPlatformInfo((long)this.cl_platform_id, (int)param_name, (ByteBuffer)buffer, null));
            String string = MemoryUtil.memASCII((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    public String getPlatformInfoStringUTF8(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetPlatformInfo((long)this.cl_platform_id, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL11.clGetPlatformInfo((long)this.cl_platform_id, (int)param_name, (ByteBuffer)buffer, null));
            String string = MemoryUtil.memUTF8((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    public static List<CyCLPlatform> getPlatforms() {
        if (allPlatforms != null) {
            return allPlatforms;
        }
        MemoryStack mstack = MemoryStack.stackPush();
        IntBuffer pi = mstack.mallocInt(1);
        CyCLUtils.checkCLError(CL11.clGetPlatformIDs(null, (IntBuffer)pi));
        if (pi.get(0) == 0) {
            throw new RuntimeException("No OpenCL platforms found");
        }
        System.out.println("Found " + pi.get(0) + " platforms");
        PointerBuffer platforms = mstack.mallocPointer(pi.get(0));
        CyCLUtils.checkCLError(CL11.clGetPlatformIDs((PointerBuffer)platforms, (IntBuffer)null));
        allPlatforms = new ArrayList<CyCLPlatform>();
        for (int p = 0; p < platforms.capacity(); ++p) {
            allPlatforms.add(new CyCLPlatformImpl(platforms.get(p)));
        }
        return allPlatforms;
    }
}

