/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.cytoscape.cycl.CyCLBuffer;
import org.cytoscape.cycl.CyCLContext;
import org.cytoscape.cycl.CyCLException;
import org.cytoscape.cycl.CyCLKernel;
import org.cytoscape.cycl.internal.CyCL;
import org.cytoscape.cycl.internal.CyCLBufferImpl;
import org.cytoscape.cycl.internal.CyCLContextImpl;
import org.cytoscape.cycl.internal.CyCLLocalSizeImpl;
import org.cytoscape.cycl.internal.CyCLProgramImpl;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL11;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CyCLKernelImpl
implements CyCLKernel {
    private Boolean finalized = false;
    private long kernel;
    private CyCLContext context;

    public CyCLKernelImpl(CyCLContextImpl context, CyCLProgramImpl program, String kernelName) {
        this.context = context;
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        this.kernel = CL11.clCreateKernel((long)program.getProgram(), (CharSequence)kernelName, (IntBuffer)errorBuffer);
        CyCLUtils.checkCLError(errorBuffer.get(0));
    }

    public long getKernel() {
        return this.kernel;
    }

    public void execute(long[] dimsGlobal, long[] dimsLocal, Object ... args) {
        this.executeWithOffset(dimsGlobal, dimsLocal, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithOffset(long[] dimsGlobal, long[] dimsLocal, long[] globalOffset, Object ... args) {
        Object object = CyCL.sync;
        synchronized (object) {
            int a = 0;
            for (Object arg : args) {
                if (arg.getClass().equals(CyCLLocalSizeImpl.class)) {
                    CyCLLocalSizeImpl localSize = (CyCLLocalSizeImpl)arg;
                    CyCLUtils.checkCLError(CL11.clSetKernelArg((long)this.kernel, (int)a++, (long)localSize.getSize()), "clSetKernelArg[CyCLLocalSizeImpl]");
                    continue;
                }
                if (arg.getClass().equals(CyCLBufferImpl.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1p((long)this.kernel, (int)a++, (long)((CyCLBuffer)arg).getMemObject()), "clSetKernelArg1p");
                    continue;
                }
                if (arg.getClass().equals(Byte.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1b((long)this.kernel, (int)a++, (byte)((Byte)arg)), "clSetKernelArg1b");
                    continue;
                }
                if (arg.getClass().equals(Short.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1s((long)this.kernel, (int)a++, (short)((Short)arg)), "clSetKernelArg1b");
                    continue;
                }
                if (arg.getClass().equals(Integer.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1i((long)this.kernel, (int)a++, (int)((Integer)arg)), "clSetKernelArg1i");
                    continue;
                }
                if (arg.getClass().equals(Long.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1l((long)this.kernel, (int)a++, (long)((Long)arg)), "clSetKernelArg1l");
                    continue;
                }
                if (arg.getClass().equals(Float.class)) {
                    CyCLUtils.checkCLError(CL11.clSetKernelArg1f((long)this.kernel, (int)a++, (float)((Float)arg).floatValue()), "clSetKernelArg1f");
                    continue;
                }
                if (!arg.getClass().equals(Double.class)) continue;
                CyCLUtils.checkCLError(CL11.clSetKernelArg1d((long)this.kernel, (int)a++, (double)((Double)arg)), "clSetKernelArg1d");
            }
            PointerBuffer bufferGlobal = BufferUtils.createPointerBuffer((int)dimsGlobal.length);
            for (int i = 0; i < dimsGlobal.length; ++i) {
                bufferGlobal.put(i, dimsGlobal[i]);
            }
            PointerBuffer bufferGlobalOffset = null;
            if (globalOffset != null) {
                if (globalOffset.length != dimsGlobal.length) {
                    throw new CyCLException("Global offset and global dimensions must have the same length");
                }
                bufferGlobalOffset = BufferUtils.createPointerBuffer((int)globalOffset.length);
                for (int i = 0; i < globalOffset.length; ++i) {
                    bufferGlobalOffset.put(i, globalOffset[i]);
                }
            }
            PointerBuffer bufferLocal = null;
            if (dimsLocal != null) {
                bufferLocal = PointerBuffer.allocateDirect((int)dimsLocal.length);
                for (int i = 0; i < dimsLocal.length; ++i) {
                    bufferLocal.put(i, dimsLocal[i]);
                }
            }
            try {
                CyCLUtils.checkCLError(CL11.clEnqueueNDRangeKernel((long)this.context.getQueue(), (long)this.kernel, (int)dimsGlobal.length, (PointerBuffer)bufferGlobalOffset, (PointerBuffer)bufferGlobal, (PointerBuffer)bufferLocal, null, null));
                CL11.clFinish((long)this.context.getQueue());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public int getKernelInfoInt(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            CyCLUtils.checkCLError(CL11.clGetKernelInfo((long)this.kernel, (int)param_name, (IntBuffer)pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    public long getKernelInfoPointer(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetKernelInfo((long)this.kernel, (int)param_name, (PointerBuffer)pp, null));
            long l = pp.get(0);
            return l;
        }
    }

    public String getKernelInfoStringUTF8(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL11.clGetKernelInfo((long)this.kernel, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL11.clGetKernelInfo((long)this.kernel, (int)param_name, (ByteBuffer)buffer, null));
            String string = MemoryUtil.memUTF8((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            CyCLUtils.checkCLError(CL11.clReleaseKernel((long)this.kernel));
            this.finalized = true;
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLKernel " + this.kernel + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLKernel object.");
        }
    }
}

