/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.cytoscape.cycl.CyCLBuffer;
import org.cytoscape.cycl.CyCLContext;
import org.cytoscape.cycl.CyCLDevice;
import org.cytoscape.cycl.CyCLException;
import org.cytoscape.cycl.CyCLKernel;
import org.cytoscape.cycl.CyCLLocalSize;
import org.cytoscape.cycl.CyCLPlatform;
import org.cytoscape.cycl.CyCLProgram;
import org.cytoscape.cycl.internal.CyCLBufferImpl;
import org.cytoscape.cycl.internal.CyCLContextImpl;
import org.cytoscape.cycl.internal.CyCLLocalSizeImpl;
import org.cytoscape.cycl.internal.CyCLPlatformImpl;
import org.cytoscape.cycl.internal.CyCLProgramImpl;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CyCLDeviceImpl
implements CyCLDevice {
    private Boolean finalized = false;
    public String platformName;
    public final String name;
    public final String vendor;
    public final String version;
    public final CyCLDevice.DeviceTypes type;
    public final int computeUnits;
    public final long workItemDimensions;
    public final long[] maxWorkItemSizes;
    public final long maxWorkGroupSize;
    public final long clockFrequency;
    public final int addressBits;
    public final long maxMallocSize;
    public final long globalMemSize;
    public final boolean supportsECC;
    public final String localMemType;
    public final long localMemSize;
    public final long maxConstBufferSize;
    public final boolean supportsImages;
    public final int maxReadImageArgs;
    public final int maxWriteImageArgs;
    public final long[] image2DMaxSize;
    public final long[] image3DMaxSize;
    public final int prefWidthChar;
    public final int prefWidthShort;
    public final int prefWidthInt;
    public final int prefWidthLong;
    public final int prefWidthFloat;
    public final int prefWidthDouble;
    private final CyCLContext context;
    private final HashMap<String, CyCLProgram> programs;
    private final long device;
    private final CyCLPlatformImpl devicePlatform;
    public final long bestBlockSize;
    public final long bestWarpSize;
    public final double benchmarkScore;

    private CyCLDeviceImpl(long device, CyCLPlatform platform, boolean doBenchmark) {
        this.device = device;
        this.devicePlatform = (CyCLPlatformImpl)platform;
        this.platformName = this.devicePlatform.getPlatformInfoStringUTF8(2306);
        System.out.println("Platform: " + this.platformName);
        this.context = new CyCLContextImpl(platform, this);
        this.programs = new HashMap();
        CLCapabilities caps = CL.createDeviceCapabilities((long)device, (CLCapabilities)this.devicePlatform.getCapabilities());
        this.vendor = this.getDeviceInfoStringUTF8(4140);
        this.version = this.getDeviceInfoStringUTF8(4143);
        this.name = this.version + " " + this.getDeviceInfoStringUTF8(4139);
        long longType = this.getDeviceInfoLong(4096);
        this.type = (longType & 4L) != 0L ? CyCLDevice.DeviceTypes.GPU : ((longType & 8L) != 0L ? CyCLDevice.DeviceTypes.Accelerator : CyCLDevice.DeviceTypes.CPU);
        this.computeUnits = this.getDeviceInfoInt(4098);
        this.workItemDimensions = this.getDeviceInfoLong(4099);
        this.maxWorkItemSizes = this.getDeviceInfoLongArray(4101);
        this.maxWorkGroupSize = this.getDeviceInfoLong(4100);
        this.clockFrequency = this.getDeviceInfoLong(4108);
        this.addressBits = this.getDeviceInfoInt(4109);
        this.maxMallocSize = this.getDeviceInfoLong(4112);
        this.globalMemSize = this.getDeviceInfoLong(4127);
        this.supportsECC = this.getDeviceInfoInt(4132) > 0;
        this.localMemType = this.getDeviceInfoInt(4130) == 1 ? "local" : "global";
        this.localMemSize = this.getDeviceInfoLong(4131);
        this.maxConstBufferSize = this.getDeviceInfoLong(4128);
        this.supportsImages = this.getDeviceInfoInt(4118) > 0;
        this.maxReadImageArgs = this.getDeviceInfoInt(4110);
        this.maxWriteImageArgs = this.getDeviceInfoInt(4111);
        this.image2DMaxSize = new long[]{this.getDeviceInfoLong(4113), this.getDeviceInfoLong(4114)};
        this.image3DMaxSize = new long[]{this.getDeviceInfoLong(4115), this.getDeviceInfoLong(4116), this.getDeviceInfoLong(4117)};
        this.prefWidthChar = this.getDeviceInfoInt(4102);
        this.prefWidthShort = this.getDeviceInfoInt(4103);
        this.prefWidthInt = this.getDeviceInfoInt(4104);
        this.prefWidthLong = this.getDeviceInfoInt(4105);
        this.prefWidthFloat = this.getDeviceInfoInt(4106);
        this.prefWidthDouble = this.getDeviceInfoInt(4107);
        System.out.println("Device: " + this.name);
        if (this.type == CyCLDevice.DeviceTypes.GPU) {
            if (this.platformName.toLowerCase().contains("amd")) {
                this.bestBlockSize = 128L;
                this.bestWarpSize = 64L;
            } else if (this.platformName.toLowerCase().contains("nvidia")) {
                this.bestBlockSize = 192L;
                this.bestWarpSize = 32L;
            } else if (this.platformName.toLowerCase().contains("intel")) {
                this.bestBlockSize = 128L;
                this.bestWarpSize = 32L;
            } else if (this.platformName.toLowerCase().contains("apple")) {
                String lowName = this.name.toLowerCase();
                if (lowName.contains("radeon") || lowName.contains("fire")) {
                    this.bestBlockSize = 128L;
                    this.bestWarpSize = 64L;
                } else if (lowName.contains("geforce") || lowName.contains("gtx") || lowName.contains("quadro") || lowName.contains("tesla")) {
                    this.bestBlockSize = 192L;
                    this.bestWarpSize = 32L;
                } else {
                    this.bestBlockSize = 128L;
                    this.bestWarpSize = 32L;
                }
            } else {
                this.bestBlockSize = 32L;
                this.bestWarpSize = 32L;
            }
        } else {
            this.bestBlockSize = 1L;
            this.bestWarpSize = 1L;
        }
        this.benchmarkScore = doBenchmark ? this.performBenchmark(false) : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double performBenchmark(boolean useOffsets) {
        String sumProgramSource = "__kernel void BenchmarkKernel(__global const int* a, __global const int* b, __global int* c, int const size) {\n  const int itemId = get_global_id(0);\n  if(itemId < size) {\n    c[itemId] = a[itemId] + b[itemId];\n  }\n}";
        CyCLProgramImpl program = null;
        try {
            program = new CyCLProgramImpl(this.context, (CyCLDevice)this, this.getClass().getResource("/Benchmark.cl"), new String[]{"BenchmarkKernel"}, null, false);
        }
        catch (Exception e1) {
            throw new CyCLException("Could not build benchmark program.", (Throwable)e1);
        }
        try {
            IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
            int n = 8192;
            int[] a = new int[n];
            int[] b = new int[n];
            int[] c = new int[n];
            for (int i = 0; i < n; ++i) {
                a[i] = i;
                b[i] = i;
            }
            CyCLBuffer bufferA = this.createWriteBuffer(a);
            CyCLBuffer bufferB = this.createWriteBuffer(b);
            CyCLBuffer bufferC = this.createReadBuffer(c);
            ArrayList<Double> logTimes = new ArrayList<Double>();
            try (MemoryStack stack = MemoryStack.stackPush();){
                int i;
                boolean argIndex = false;
                CyCLKernel cyKernel = program.getKernel("BenchmarkKernel");
                long kernel = cyKernel.getKernel();
                String kernelName = cyKernel.getKernelInfoStringUTF8(4496);
                int kernelArgs = cyKernel.getKernelInfoInt(4497);
                cyKernel.execute(new long[]{n}, null, new Object[]{bufferA, bufferB, bufferC, n});
                bufferC.getFromDevice(c);
                CL10.clFinish((long)this.context.getQueue());
                for (i = 0; i < 4; ++i) {
                    long timeStart = System.nanoTime();
                    int benchN = 1 << 10 + i;
                    if (!useOffsets) {
                        program.getKernel("BenchmarkKernel").execute(new long[]{benchN}, null, new Object[]{bufferA, bufferB, bufferC, benchN});
                    } else {
                        for (int offset = 0; offset < benchN; offset += 128) {
                            program.getKernel("BenchmarkKernel").executeWithOffset(new long[]{benchN}, null, new long[]{offset}, new Object[]{bufferA, bufferB, bufferC, benchN});
                        }
                    }
                    CL10.clFinish((long)this.context.getQueue());
                    long timeStop = System.nanoTime();
                    logTimes.add(Math.log((double)(timeStop - timeStart) * 1.0E-9));
                }
                bufferC.getFromDevice(c);
                for (i = 0; i < c.length; ++i) {
                    if (c[i] == Math.max(0, i - 1)) continue;
                    System.out.println("OpenCL benchmark produced wrong value for " + i + ".  Expected " + Math.max(0, i - 1) + " but got " + c[i]);
                    throw new CyCLException("OpenCL benchmark produced wrong value for " + i + ".  Expected " + Math.max(0, i - 1) + " but got " + c[i]);
                }
            }
            finally {
                bufferA.free();
                bufferB.free();
                bufferC.free();
            }
            double diffsum = 0.0;
            for (int i = 0; i < logTimes.size() - 1; ++i) {
                diffsum += (Double)logTimes.get(i + 1) - (Double)logTimes.get(i);
            }
            double d = Math.exp(diffsum /= (double)(logTimes.size() - 1));
            return d;
        }
        catch (CyCLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CyCLException("Error running benchmark", (Throwable)ex);
        }
        finally {
            program.finalize();
        }
    }

    public long getDevice() {
        return this.device;
    }

    public CyCLPlatform getPlatform() {
        return this.devicePlatform;
    }

    public long getMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public long getBestBlockSize() {
        return this.bestBlockSize;
    }

    public long getBestWarpSize() {
        return this.bestWarpSize;
    }

    public long getBestBlockSize(long n) {
        return Math.min(this.bestBlockSize, (n + this.bestWarpSize - 1L) / this.bestWarpSize * this.bestWarpSize);
    }

    public Boolean hasProgram(String name) {
        return this.programs.containsKey(name);
    }

    public CyCLProgram getProgram(String name) {
        if (!this.hasProgram(name).booleanValue()) {
            return null;
        }
        return this.programs.get(name);
    }

    public CyCLProgram addProgram(String name, String[] programSources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        if (this.hasProgram(name).booleanValue()) {
            return this.getProgram(name);
        }
        HashMap<String, String> alldefines = this.getDeviceSpecificDefines();
        if (defines != null) {
            alldefines.putAll(defines);
        }
        CyCLProgramImpl added = new CyCLProgramImpl(this.context, (CyCLDevice)this, programSources, kernelNames, alldefines, silentCompilation);
        this.programs.put(name, added);
        return added;
    }

    public CyCLProgram addProgram(String name, String programSource, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        return this.addProgram(name, new String[]{programSource}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgram addProgram(String name, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        if (this.hasProgram(name).booleanValue()) {
            return this.getProgram(name);
        }
        try {
            InputStream programTextStream = resourcePath.openStream();
            Scanner programTextScanner = new Scanner(programTextStream, "UTF-8");
            String programText = programTextScanner.useDelimiter("\\Z").next();
            programTextScanner.close();
            programTextStream.close();
            return this.addProgram(name, new String[]{programText}, kernelNames, defines, silentCompilation);
        }
        catch (IOException ex) {
            throw new CyCLException("Error reading OpenCL program.", (Throwable)ex);
        }
    }

    public CyCLProgram forceAddProgram(String name, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        CyCLProgramImpl added;
        if (this.hasProgram(name).booleanValue()) {
            try {
                CyCLProgramImpl prog = (CyCLProgramImpl)this.getProgram(name);
                prog.finalize();
            }
            catch (Throwable prog) {
                // empty catch block
            }
            this.programs.remove(name);
        }
        HashMap<String, String> alldefines = this.getDeviceSpecificDefines();
        if (defines != null) {
            for (Map.Entry<String, String> entry : defines.entrySet()) {
                alldefines.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            added = new CyCLProgramImpl(this.context, (CyCLDevice)this, resourcePath, kernelNames, alldefines, silentCompilation);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        this.programs.put(name, added);
        return added;
    }

    public HashMap<String, String> getDeviceSpecificDefines() {
        HashMap<String, String> defines = new HashMap<String, String>();
        if (this.type == CyCLDevice.DeviceTypes.GPU) {
            defines.put("CYCL_GPU", "");
        } else {
            defines.put("CYCL_CPU", "");
        }
        defines.put("CYCL_WARP", String.valueOf(this.bestWarpSize));
        return defines;
    }

    public void finishQueue() {
        CL10.clFinish((long)this.context.getQueue());
    }

    public CyCLBuffer createBuffer(Class<?> type, int elements) {
        return new CyCLBufferImpl(this.context, type, elements, 4);
    }

    public CyCLBuffer createBuffer(Class<?> type, int elements, int bits) {
        return new CyCLBufferImpl(this.context, type, elements, bits);
    }

    public CyCLBuffer createWriteBuffer(byte[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(byte[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(byte[] data) {
        return this.createBuffer(data, 9);
    }

    public CyCLBuffer createBuffer(byte[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLBuffer createWriteBuffer(short[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(short[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(short[] data) {
        return this.createBuffer(data, 9);
    }

    public CyCLBuffer createBuffer(short[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLBuffer createWriteBuffer(int[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(int[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(int[] data) {
        return this.createBuffer(data, 33);
    }

    public CyCLBuffer createBuffer(int[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLBuffer createWriteBuffer(long[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(long[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(long[] data) {
        return this.createBuffer(data, 9);
    }

    public CyCLBuffer createBuffer(long[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLBuffer createWriteBuffer(float[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(float[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(float[] data) {
        return this.createBuffer(data, 9);
    }

    public CyCLBuffer createBuffer(float[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLBuffer createWriteBuffer(double[] data) {
        return this.createBuffer(data, 34);
    }

    public CyCLBuffer createReadBuffer(double[] data) {
        return this.createBuffer(data, 4);
    }

    public CyCLBuffer createBuffer(double[] data) {
        return this.createBuffer(data, 9);
    }

    public CyCLBuffer createBuffer(double[] data, int bits) {
        return new CyCLBufferImpl(this.context, data, bits);
    }

    public CyCLLocalSize createLocalSize(long size) {
        return new CyCLLocalSizeImpl(size);
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public CyCLDevice.DeviceTypes getType() {
        return this.type;
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            if (this.programs != null) {
                for (Map.Entry<String, CyCLProgram> entry : this.programs.entrySet()) {
                    if (entry.getValue() == null) continue;
                    CyCLProgramImpl prog = (CyCLProgramImpl)entry.getValue();
                    prog.finalize();
                }
            }
            if (this.context != null) {
                ((CyCLContextImpl)this.context).finalize();
            }
            this.finalized = true;
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLDevice " + this.name + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLDevice object.", exc);
        }
    }

    public static List<CyCLDevice> getAll(String preferredDevice) {
        ArrayList<CyCLDevice> devices = new ArrayList<CyCLDevice>();
        Throwable savedException = null;
        System.out.println("Got " + CyCLPlatformImpl.getPlatforms().size() + " platforms");
        for (CyCLPlatform platform : CyCLPlatformImpl.getPlatforms()) {
            try {
                long[] ids = platform.getDevices(-1);
                if (ids == null) continue;
                System.out.println("Got " + ids.length + " devices");
                for (long id : ids) {
                    try {
                        CyCLDeviceImpl newDevice = new CyCLDeviceImpl(id, platform, preferredDevice.equals(""));
                        devices.add(newDevice);
                    }
                    catch (Exception e1) {
                        savedException = e1;
                        e1.printStackTrace();
                        throw new CyCLException((Throwable)e1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (devices.size() == 0 && savedException != null) {
            savedException.printStackTrace();
            throw new CyCLException(savedException);
        }
        final class DeviceComparator
        implements Comparator<CyCLDevice> {
            final /* synthetic */ String val$preferredDevice;

            DeviceComparator(String string) {
                this.val$preferredDevice = string;
            }

            @Override
            public int compare(CyCLDevice o1, CyCLDevice o2) {
                if (o1.getName().equals(this.val$preferredDevice)) {
                    return -1;
                }
                double score1 = ((CyCLDeviceImpl)o1).benchmarkScore;
                double score2 = ((CyCLDeviceImpl)o2).benchmarkScore;
                return Double.compare(score1, score2);
            }
        }
        devices.sort(new DeviceComparator(preferredDevice));
        return devices;
    }

    int getDeviceInfoInt(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (IntBuffer)pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    long getDeviceInfoLong(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pl = stack.mallocLong(1);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (LongBuffer)pl, null));
            long l = pl.get(0);
            return l;
        }
    }

    long getDeviceInfoPointer(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (PointerBuffer)pp, null));
            long l = pp.get(0);
            return l;
        }
    }

    long[] getDeviceInfoLongArray(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int size = (int)pp.get(0);
            LongBuffer buffer = stack.mallocLong(size);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (LongBuffer)buffer, null));
            long[] ret = new long[size];
            buffer.get(ret);
            long[] lArray = ret;
            return lArray;
        }
    }

    String getDeviceInfoStringUTF8(int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (ByteBuffer)null, (PointerBuffer)pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            CyCLUtils.checkCLError(CL10.clGetDeviceInfo((long)this.device, (int)param_name, (ByteBuffer)buffer, null));
            String string = MemoryUtil.memUTF8((ByteBuffer)buffer, (int)(bytes - 1));
            return string;
        }
    }
}

