/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.nio.IntBuffer;
import org.cytoscape.cycl.CyCLContext;
import org.cytoscape.cycl.CyCLDevice;
import org.cytoscape.cycl.CyCLPlatform;
import org.cytoscape.cycl.internal.CyCLPlatformImpl;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLContextCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CyCLContextImpl
implements CyCLContext {
    private Boolean finalized = false;
    private long context;
    private long queue = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyCLContextImpl(CyCLPlatform platform, CyCLDevice device) {
        CLContextCallback contextCB = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer errcode_ret = stack.callocInt(1);
            contextCB = CLContextCallback.create((errinfo, private_info, cb, user_data) -> {
                System.err.println("[LWJGL] cl_context_callback");
                System.err.println("\tInfo: " + MemoryUtil.memUTF8((long)errinfo));
            });
            PointerBuffer ctxProps = ((CyCLPlatformImpl)platform).getContextProps();
            this.context = CL11.clCreateContext((PointerBuffer)ctxProps, (long)device.getDevice(), (CLContextCallbackI)contextCB, (long)0L, (IntBuffer)errcode_ret);
            CyCLUtils.checkCLError(errcode_ret);
            this.queue = CL11.clCreateCommandQueue((long)this.context, (long)device.getDevice(), (long)0L, (IntBuffer)errcode_ret);
            CyCLUtils.checkCLError(errcode_ret);
        }
        finally {
            contextCB.free();
        }
    }

    public long getContext() {
        return this.context;
    }

    public long getQueue() {
        return this.queue;
    }

    protected void finalize() throws Throwable {
        if (this.finalized.booleanValue()) {
            return;
        }
        CL10.clReleaseCommandQueue((long)this.queue);
        CL10.clReleaseContext((long)this.context);
        this.finalized = true;
        super.finalize();
    }
}

