/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cycl.internal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.cytoscape.cycl.CyCLBuffer;
import org.cytoscape.cycl.CyCLContext;
import org.cytoscape.cycl.internal.CyCLUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;

public class CyCLBufferImpl
implements CyCLBuffer {
    private CyCLContext context;
    private Class<?> type;
    private int elements;
    private long memObject;
    private ByteBuffer buffer;
    private boolean finalized;

    public CyCLBufferImpl(CyCLContext context, Class<?> type, int elements) {
        this.context = context;
        this.type = type;
        this.elements = elements;
        this.buffer = BufferUtils.createByteBuffer((int)this.sizeInBytes());
    }

    public CyCLBufferImpl(CyCLContext context, Class<?> type, int elements, int bits) {
        this(context, type, elements);
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, byte[] data, int bits) {
        this(context, Byte.TYPE, data.length);
        this.buffer.put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, short[] data, int bits) {
        this(context, Short.TYPE, data.length);
        this.buffer.asShortBuffer().put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, int[] data, int bits) {
        this(context, Integer.TYPE, data.length);
        this.buffer = BufferUtils.createByteBuffer((int)this.sizeInBytes());
        this.buffer.asIntBuffer().put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, long[] data, int bits) {
        this(context, Long.TYPE, data.length);
        this.buffer.asLongBuffer().put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, float[] data, int bits) {
        this(context, Float.TYPE, data.length);
        this.buffer.asFloatBuffer().put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public CyCLBufferImpl(CyCLContext context, double[] data, int bits) {
        this(context, Double.TYPE, data.length);
        this.buffer.asDoubleBuffer().put(data);
        this.buffer.rewind();
        this.createClBuffer(bits);
    }

    public int elementSize() {
        if (this.type == Character.TYPE) {
            return 1;
        }
        if (this.type == Byte.TYPE) {
            return 1;
        }
        if (this.type == Short.TYPE) {
            return 2;
        }
        if (this.type == Float.TYPE) {
            return 4;
        }
        if (this.type == Integer.TYPE) {
            return 4;
        }
        if (this.type == Double.TYPE) {
            return 8;
        }
        if (this.type == Long.TYPE) {
            return 8;
        }
        return 1;
    }

    public int sizeInBytes() {
        return this.elementSize() * this.elements;
    }

    public void setFromHost(byte[] data, int length, int offset) {
        this.buffer.put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(short[] data, int length, int offset) {
        this.buffer.asShortBuffer().put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (short[])data, null, null);
        CL10.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(int[] data, int length, int offset) {
        this.buffer.asIntBuffer().put(data);
        this.buffer.rewind();
        CyCLUtils.checkCLError(CL11.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null));
        CL11.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(long[] data, int length, int offset) {
        this.buffer.asLongBuffer().put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null);
        CL10.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(float[] data, int length, int offset) {
        this.buffer.asFloatBuffer().put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (float[])data, null, null);
        CL10.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(double[] data, int length, int offset) {
        this.buffer.asDoubleBuffer().put(data);
        this.buffer.rewind();
        CL10.clEnqueueWriteBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (double[])data, null, null);
        CL10.clFinish((long)this.context.getQueue());
    }

    public void setFromHost(byte[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(short[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(int[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(long[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(float[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromHost(double[] data) {
        this.setFromHost(data, this.sizeInBytes(), 0);
    }

    public void setFromDevice(CyCLBuffer src, long bytes, long offsetSrc, long offsetDst) {
        CL10.clEnqueueCopyBuffer((long)this.context.getQueue(), (long)src.getMemObject(), (long)this.memObject, (long)offsetSrc, (long)offsetDst, (long)bytes, null, null);
    }

    public void setFromDevice(CyCLBuffer src) {
        this.setFromDevice(src, this.sizeInBytes(), 0L, 0L);
    }

    public void getFromDevice(long offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
    }

    public void getFromDevice(byte[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.get(data);
    }

    public void getFromDevice(short[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.asShortBuffer().get(data);
    }

    public void getFromDevice(int[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.asIntBuffer().get(data);
    }

    public void getFromDevice(long[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.asLongBuffer().get(data);
    }

    public void getFromDevice(float[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.asFloatBuffer().get(data);
    }

    public void getFromDevice(double[] data, int length, int offset) {
        CyCLUtils.checkCLError(CL10.clEnqueueReadBuffer((long)this.context.getQueue(), (long)this.memObject, (boolean)true, (long)offset, (ByteBuffer)this.buffer, null, null), "clEnqueueReadBuffer");
        this.buffer.asDoubleBuffer().get(data);
    }

    public void getFromDevice(byte[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(short[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(int[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(long[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(float[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void getFromDevice(double[] data) {
        this.getFromDevice(data, this.sizeInBytes(), 0);
    }

    public void createClBuffer(int bits) {
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        if ((bits & 4) != 0) {
            this.memObject = CL10.clCreateBuffer((long)this.context.getContext(), (long)bits, (long)this.sizeInBytes(), (IntBuffer)errorBuffer);
            CyCLUtils.checkCLError(errorBuffer.get(0), "clCreateBuffer");
        } else {
            this.memObject = CL10.clCreateBuffer((long)this.context.getContext(), (long)bits, (ByteBuffer)this.buffer, (IntBuffer)errorBuffer);
            CyCLUtils.checkCLError(errorBuffer.get(0), "clCreateBuffer");
        }
    }

    public long getMemObject() {
        return this.memObject;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void free() {
        this.finalize();
    }

    protected void finalize() {
        try {
            if (this.finalized) {
                return;
            }
            CyCLUtils.checkCLError(CL10.clReleaseMemObject((long)this.memObject));
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLBuffer size " + this.sizeInBytes() + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLBuffer object.");
        }
    }

    public String toString() {
        return "CyCLBuffer[type=" + this.type.toString() + ",size=" + this.elements + ",buffer=" + this.buffer + "]";
    }
}

