/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.internal.column.ColumnData;

class MapColumn
implements ColumnData {
    private final Map<Object, Object> attributes;

    public MapColumn(Map<Object, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public int countMatchingRows(Object value) {
        return Collections.frequency(this.attributes.values(), value);
    }

    @Override
    public Collection<CyRow> getMatchingRows(Map<Object, CyRow> rows, Object value) {
        ArrayList<CyRow> matchingRows = new ArrayList<CyRow>();
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            matchingRows.add(rows.get(entry.getKey()));
        }
        return matchingRows;
    }

    @Override
    public <T> Collection<T> getMatchingKeys(Object value, Class<T> type) {
        ArrayList<Object> matchingKeys = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            matchingKeys.add(entry.getKey());
        }
        return matchingKeys;
    }

    @Override
    public boolean put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        Object prev = this.attributes.put(key, value);
        if (prev == null) {
            return true;
        }
        return !prev.equals(value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Set<Object> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public boolean remove(Object key) {
        return this.attributes.remove(key) != null;
    }
}

