/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.CyPayloadEvent;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.TablePrivacyChangedEvent;
import org.cytoscape.model.events.TableTitleChangedEvent;
import org.cytoscape.model.internal.LocalTableFacade;
import org.cytoscape.service.util.CyServiceRegistrar;

public class TableEventHelperFacade
implements CyEventHelper {
    private final Map<CyTable, Reference<LocalTableFacade>> facadeMap;
    private final Object lock = new Object();
    private final CyServiceRegistrar serviceRegistrar;
    private CyEventHelper eventHelper;

    public TableEventHelperFacade(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.facadeMap = new WeakHashMap<CyTable, Reference<LocalTableFacade>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerFacade(LocalTableFacade facade) {
        Object object = this.lock;
        synchronized (object) {
            this.facadeMap.put(facade.getLocalTable(), new WeakReference<LocalTableFacade>(facade));
        }
    }

    private CyEventHelper getEventHelper() {
        if (this.eventHelper == null) {
            this.eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        }
        return this.eventHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends CyEvent<?>> void fireEvent(E event) {
        Reference<LocalTableFacade> reference;
        CyEventHelper eventHelper = this.getEventHelper();
        eventHelper.fireEvent(event);
        Object source = event.getSource();
        if (!(source instanceof CyTable)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            reference = this.facadeMap.get((CyTable)source);
        }
        if (reference == null) {
            return;
        }
        LocalTableFacade facade = reference.get();
        if (facade == null) {
            return;
        }
        TablePrivacyChangedEvent facadeEvent = null;
        if (event instanceof TableTitleChangedEvent) {
            TableTitleChangedEvent e = (TableTitleChangedEvent)event;
            facadeEvent = new TableTitleChangedEvent((CyTable)facade, e.getOldTitle());
        } else if (event instanceof TablePrivacyChangedEvent) {
            facadeEvent = new TablePrivacyChangedEvent((CyTable)facade);
        } else if (event instanceof ColumnNameChangedEvent) {
            ColumnNameChangedEvent e = (ColumnNameChangedEvent)event;
            facadeEvent = new ColumnNameChangedEvent((CyTable)facade, e.getOldColumnName(), e.getNewColumnName());
        } else if (event instanceof ColumnDeletedEvent) {
            ColumnDeletedEvent e = (ColumnDeletedEvent)event;
            facadeEvent = new ColumnDeletedEvent((CyTable)facade, e.getColumnName(), e.getSUID());
        } else if (event instanceof ColumnCreatedEvent) {
            ColumnCreatedEvent e = (ColumnCreatedEvent)event;
            facadeEvent = new ColumnCreatedEvent((CyTable)facade, e.getColumnName(), e.getSUID());
        }
        if (facadeEvent != null) {
            eventHelper.fireEvent((CyEvent)facadeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, P, E extends CyPayloadEvent<S, P>> void addEventPayload(S source, P payload, Class<E> eventType) {
        CyEventHelper eventHelper = this.getEventHelper();
        eventHelper.addEventPayload(source, payload, eventType);
        if (source instanceof CyTable) {
            Reference<LocalTableFacade> reference;
            Object object = this.lock;
            synchronized (object) {
                reference = this.facadeMap.get((CyTable)source);
            }
            if (reference == null) {
                return;
            }
            LocalTableFacade facade = reference.get();
            if (facade == null) {
                return;
            }
            if (payload instanceof RowSetRecord) {
                RowSetRecord newRSC = new RowSetRecord(facade.getRow(((RowSetRecord)payload).getRow().get("SUID", Long.class)), ((RowSetRecord)payload).getColumn(), ((RowSetRecord)payload).getValue(), ((RowSetRecord)payload).getRawValue());
                eventHelper.addEventPayload((Object)facade, (Object)newRSC, eventType);
            } else {
                eventHelper.addEventPayload((Object)facade, payload, eventType);
            }
        }
    }

    public void flushPayloadEvents() {
        this.getEventHelper().flushPayloadEvents();
    }

    public void flushPayloadEvents(Object eventSource) {
        this.getEventHelper().flushPayloadEvents(eventSource);
    }

    public void silenceEventSource(Object eventSource) {
        this.getEventHelper().silenceEventSource(eventSource);
    }

    public void unsilenceEventSource(Object eventSource) {
        this.getEventHelper().unsilenceEventSource(eventSource);
    }
}

