/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import org.cytoscape.model.CyNode;
import org.cytoscape.model.internal.EdgePointer;

final class NodePointer {
    final CyNode cyNode;
    final long index;
    NodePointer nextNode;
    NodePointer prevNode;
    EdgePointer firstOutEdge;
    EdgePointer firstInEdge;
    int outDegree;
    int inDegree;
    int undDegree;
    int selfEdges;

    NodePointer(CyNode cyn) {
        this.cyNode = cyn;
        this.index = cyn.getSUID();
        this.outDegree = 0;
        this.inDegree = 0;
        this.undDegree = 0;
        this.selfEdges = 0;
        this.firstOutEdge = null;
        this.firstInEdge = null;
    }

    NodePointer insert(NodePointer next) {
        this.nextNode = next;
        if (next != null) {
            next.prevNode = this;
        }
        return this;
    }

    NodePointer remove(NodePointer first) {
        NodePointer ret = first;
        if (this.prevNode != null) {
            this.prevNode.nextNode = this.nextNode;
        } else {
            ret = this.nextNode;
        }
        if (this.nextNode != null) {
            this.nextNode.prevNode = this.prevNode;
        }
        this.nextNode = null;
        this.prevNode = null;
        this.firstOutEdge = null;
        this.firstInEdge = null;
        return ret;
    }
}

