/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.internal.LocalTableFacade;
import org.cytoscape.model.internal.SharedTableFacade;
import org.cytoscape.model.internal.SimpleNetwork;
import org.cytoscape.model.internal.TableEventHelperFacade;

abstract class DefaultTablesNetwork
extends SimpleNetwork {
    private final CyNetworkTableManager networkTableManager;
    private Reference<CyNetwork> networkRef;
    private final CyTableFactory tableFactory;
    private final boolean publicTables;
    private final int tableSizeDeterminer;
    protected final CyEventHelper eventHelper;

    DefaultTablesNetwork(long suid, CyNetworkTableManager tableManager, CyTableFactory tableFactory, boolean publicTables, int tableSizeDeterminer, CyEventHelper eventHelper) {
        super(suid);
        this.networkTableManager = tableManager;
        this.publicTables = publicTables;
        this.tableFactory = tableFactory;
        this.tableSizeDeterminer = tableSizeDeterminer;
        this.eventHelper = eventHelper;
    }

    protected void initTables(CyNetwork network, SharedTableFacade sharedNetworkTable, SharedTableFacade sharedNodeTable, SharedTableFacade sharedEdgeTable) {
        this.networkRef = new WeakReference<CyNetwork>(network);
        this.createNetworkTables(super.getSUID(), this.tableFactory, this.publicTables, sharedNetworkTable);
        this.createNodeTables(super.getSUID(), this.tableFactory, this.publicTables, this.tableSizeDeterminer, sharedNodeTable);
        this.createEdgeTables(super.getSUID(), this.tableFactory, this.publicTables, this.tableSizeDeterminer, sharedEdgeTable);
    }

    public CyTable getDefaultNetworkTable() {
        return this.networkTableManager.getTable(this.networkRef.get(), CyNetwork.class, "USER");
    }

    public CyTable getDefaultNodeTable() {
        return this.networkTableManager.getTable(this.networkRef.get(), CyNode.class, "USER");
    }

    public CyTable getDefaultEdgeTable() {
        return this.networkTableManager.getTable(this.networkRef.get(), CyEdge.class, "USER");
    }

    public CyTable getTable(Class<? extends CyIdentifiable> type, String namespace) {
        return this.networkTableManager.getTable(this.networkRef.get(), type, namespace);
    }

    public CyRow getRow(CyIdentifiable entry) {
        return this.getRow(entry, "USER");
    }

    public CyRow getRow(CyIdentifiable entry, String tableName) {
        CyTable table;
        if (entry == null) {
            throw new NullPointerException("null entry");
        }
        if (tableName == null) {
            throw new NullPointerException("null table name");
        }
        if (entry instanceof CyNode && this.containsNode((CyNode)entry)) {
            table = this.networkTableManager.getTable(this.networkRef.get(), CyNode.class, tableName);
        } else if (entry instanceof CyEdge && this.containsEdge((CyEdge)entry)) {
            table = this.networkTableManager.getTable(this.networkRef.get(), CyEdge.class, tableName);
        } else if (entry instanceof CyNetwork && entry.equals(this)) {
            if (this.networkRef == null) {
                throw new IllegalArgumentException("Network reference is null.  This should not be null.");
            }
            CyNetwork n = this.networkRef.get();
            table = this.networkTableManager.getTable(n, CyNetwork.class, tableName);
        } else {
            throw new IllegalArgumentException("unrecognized (table entry): " + entry.toString() + "  (table name): " + tableName);
        }
        if (table == null) {
            throw new NullPointerException("Table does not exist: " + tableName);
        }
        return table.getRow((Object)entry.getSUID());
    }

    private void createNetworkTables(long suidx, CyTableFactory tableFactory, boolean pubTables, SharedTableFacade sharedNetworkTable) {
        CyTable defTable = tableFactory.createTable(suidx + " default network", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyNetwork.class, "LOCAL_ATTRS", defTable);
        LocalTableFacade localTable = new LocalTableFacade(defTable, sharedNetworkTable, this.eventHelper);
        localTable.setPublic(pubTables);
        this.networkTableManager.setTable(this.networkRef.get(), CyNetwork.class, "USER", (CyTable)localTable);
        if (this.eventHelper instanceof TableEventHelperFacade) {
            ((TableEventHelperFacade)this.eventHelper).registerFacade(localTable);
        }
        CyTable hiddenTable = tableFactory.createTable(suidx + " hidden network", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyNetwork.class, "HIDDEN", hiddenTable);
        defTable.createColumn("name", String.class, true);
        defTable.createColumn("selected", Boolean.class, true, (Object)Boolean.FALSE);
    }

    private void createNodeTables(long suidx, CyTableFactory tableFactory, boolean pubTables, int num, SharedTableFacade sharedNodeTable) {
        CyTable defTable = tableFactory.createTable(suidx + " default node", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyNode.class, "LOCAL_ATTRS", defTable);
        LocalTableFacade localTable = new LocalTableFacade(defTable, sharedNodeTable, this.eventHelper);
        localTable.setPublic(pubTables);
        this.networkTableManager.setTable(this.networkRef.get(), CyNode.class, "USER", (CyTable)localTable);
        if (this.eventHelper instanceof TableEventHelperFacade) {
            ((TableEventHelperFacade)this.eventHelper).registerFacade(localTable);
        }
        CyTable hiddenTable = tableFactory.createTable(suidx + " hidden node", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyNode.class, "HIDDEN", hiddenTable);
        defTable.createColumn("name", String.class, true);
        defTable.createColumn("selected", Boolean.class, true, (Object)Boolean.FALSE);
    }

    private void createEdgeTables(long suidx, CyTableFactory tableFactory, boolean pubTables, int num, SharedTableFacade sharedEdgeTable) {
        CyTable defTable = tableFactory.createTable(suidx + " default edge", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyEdge.class, "LOCAL_ATTRS", defTable);
        LocalTableFacade localTable = new LocalTableFacade(defTable, sharedEdgeTable, this.eventHelper);
        localTable.setPublic(pubTables);
        this.networkTableManager.setTable(this.networkRef.get(), CyEdge.class, "USER", (CyTable)localTable);
        if (this.eventHelper instanceof TableEventHelperFacade) {
            ((TableEventHelperFacade)this.eventHelper).registerFacade(localTable);
        }
        CyTable hiddenTable = tableFactory.createTable(suidx + " hidden edge", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        this.networkTableManager.setTable(this.networkRef.get(), CyEdge.class, "HIDDEN", hiddenTable);
        defTable.createColumn("name", String.class, true);
        defTable.createColumn("selected", Boolean.class, true, (Object)Boolean.FALSE);
        defTable.createColumn("interaction", String.class, true);
    }

    protected static final CyTableFactory.InitialTableSize getInitialTableSize(int num) {
        if (num < 5) {
            return CyTableFactory.InitialTableSize.LARGE;
        }
        if (num < 15) {
            return CyTableFactory.InitialTableSize.MEDIUM;
        }
        return CyTableFactory.InitialTableSize.SMALL;
    }

    protected <T extends CyIdentifiable> void removeRows(Collection<T> items, Class<? extends T> type) {
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        for (CyIdentifiable item : items) {
            primaryKeys.add(item.getSUID());
        }
        for (CyTable table : this.networkTableManager.getTables(this.networkRef.get(), type).values()) {
            table.deleteRows(primaryKeys);
        }
    }
}

