/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyNetworkManagerImpl
implements CyNetworkManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<Long, CyNetwork> networkMap;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public CyNetworkManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.networkMap = new HashMap<Long, CyNetwork>();
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyNetwork> getNetworkSet() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<CyNetwork>(this.networkMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetwork getNetwork(long id) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean networkExists(long network_id) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkMap.containsKey(network_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyNetwork(CyNetwork network) {
        if (network == null) {
            throw new NullPointerException("Network is null");
        }
        Long networkId = network.getSUID();
        Object object = this.lock;
        synchronized (object) {
            if (!this.networkMap.containsKey(networkId)) {
                throw new IllegalArgumentException("network is not recognized by this NetworkManager");
            }
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new NetworkAboutToBeDestroyedEvent((CyNetworkManager)this, network));
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.networkMap.containsKey(networkId)) {
                throw new IllegalArgumentException("network is not recognized by this NetworkManager");
            }
            for (CyNode n : network.getNodeList()) {
                network.getRow((CyIdentifiable)n).set("selected", (Object)false);
            }
            for (CyEdge e : network.getEdgeList()) {
                network.getRow((CyIdentifiable)e).set("selected", (Object)false);
            }
            this.networkMap.remove(networkId);
        }
        if (network instanceof CySubNetwork) {
            CySubNetwork subNetwork = (CySubNetwork)network;
            CyRootNetwork rootNetwork = subNetwork.getRootNetwork();
            CySubNetwork baseNetwork = rootNetwork.getBaseNetwork();
            if (!subNetwork.equals(baseNetwork) || rootNetwork.getSubNetworkList().size() > 1) {
                rootNetwork.removeSubNetwork(subNetwork);
                network.dispose();
            }
            if (!this.hasRegisteredNetworks(rootNetwork)) {
                rootNetwork.dispose();
            }
        } else {
            network.dispose();
        }
        eventHelper.fireEvent((CyEvent)new NetworkDestroyedEvent((CyNetworkManager)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRegisteredNetworks(CyRootNetwork rootNetwork) {
        Object object = this.lock;
        synchronized (object) {
            for (CySubNetwork network : rootNetwork.getSubNetworkList()) {
                if (!this.networkMap.containsKey(network.getSUID())) continue;
                return true;
            }
            return false;
        }
    }

    public void addNetwork(CyNetwork network) {
        this.addNetwork(network, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetwork(CyNetwork network, boolean setCurrent) {
        CyApplicationManager applicationManager;
        if (network == null) {
            throw new NullPointerException("Network is null");
        }
        Object object = this.lock;
        synchronized (object) {
            logger.debug("Adding new Network Model: Model ID = " + network.getSUID());
            CyRow row = network.getRow((CyIdentifiable)network);
            String name = (String)row.get("name", String.class);
            String sharedName = (String)row.get("shared name", String.class);
            if (name != null && !name.trim().isEmpty() && (sharedName == null || sharedName.trim().isEmpty())) {
                row.set("shared name", (Object)name);
            } else if (sharedName != null && !sharedName.trim().isEmpty() && (name == null || name.trim().isEmpty())) {
                row.set("name", (Object)sharedName);
            } else if ((sharedName == null || sharedName.trim().isEmpty()) && (name == null || name.trim().isEmpty())) {
                CyNetworkNaming namingUtil = (CyNetworkNaming)this.serviceRegistrar.getService(CyNetworkNaming.class);
                String newName = namingUtil.getSuggestedNetworkTitle("Network");
                row.set("name", (Object)newName);
                row.set("shared name", (Object)newName);
            }
            this.networkMap.put(network.getSUID(), network);
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new NetworkAddedEvent((CyNetworkManager)this, network));
        if (setCurrent && (applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)) != null) {
            applicationManager.setCurrentNetwork(network);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.networkMap.clear();
        }
    }
}

