/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.internal.CyTableImpl;

final class CyColumnImpl
implements CyColumn {
    private final CyTableImpl table;
    private String columnName;
    private final Class<?> columnType;
    private final Class<?> listElementType;
    private final VirtualColumnInfo virtualInfo;
    private final boolean isPrimaryKey;
    private final boolean isImmutable;
    private final Object defaultValue;
    private final Long suid = SUIDFactory.getNextSUID();

    CyColumnImpl(CyTableImpl table, String columnName, Class<?> columnType, Class<?> listElementType, VirtualColumnInfo virtualInfo, boolean isPrimaryKey, boolean isImmutable, Object defaultValue) {
        this.table = table;
        this.columnName = columnName;
        this.columnType = columnType;
        this.listElementType = listElementType;
        this.virtualInfo = virtualInfo;
        this.isPrimaryKey = isPrimaryKey;
        this.isImmutable = isImmutable;
        if (defaultValue != null && !columnType.isAssignableFrom(defaultValue.getClass())) {
            throw new IllegalArgumentException("The type of the defaultValue (" + defaultValue.getClass().getName() + ") cannot be assigned to type of this column (" + columnType.getName() + ")");
        }
        this.defaultValue = defaultValue;
    }

    public Long getSUID() {
        return this.suid;
    }

    public CyTable getTable() {
        return this.table;
    }

    public String getName() {
        return this.columnName;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new NullPointerException("\"newName\" must not be null.");
        }
        if (this.isImmutable) {
            throw new IllegalArgumentException("can't rename an immutable column.");
        }
        String oldName = this.columnName;
        CyColumn anotherColumn = this.table.getColumn(newName);
        if (anotherColumn != null && this != anotherColumn) {
            throw new IllegalArgumentException("Column already exists with name '" + newName + "' and type '" + anotherColumn.getType() + "'");
        }
        this.table.updateColumnName(oldName, newName);
        this.columnName = newName;
    }

    public Class<?> getType() {
        return this.columnType;
    }

    public Class<?> getListElementType() {
        return this.listElementType;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public <T> List<T> getValues(Class<? extends T> type) {
        if (type == null) {
            throw new NullPointerException("type argument must not be null.");
        }
        if (type != this.columnType) {
            throw new IllegalArgumentException("expected " + this.columnType.getName() + " got " + type.getName() + ".");
        }
        return this.table.getColumnValues(this.columnName, type);
    }

    public VirtualColumnInfo getVirtualColumnInfo() {
        return this.virtualInfo;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.columnName;
    }
}

