/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.model.internal.tsort.TopoGraphNode;

public class AttribTopoGraphNode
implements TopoGraphNode {
    private final String nodeName;
    private final Collection<TopoGraphNode> dependents;

    public AttribTopoGraphNode(String nodeName, Collection<String> dependents) {
        this.nodeName = nodeName;
        this.dependents = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
        for (String dependent : dependents) {
            this.dependents.add(new AttribTopoGraphNode(dependent));
        }
    }

    private AttribTopoGraphNode(String nodeName) {
        this.nodeName = nodeName;
        this.dependents = new HashSet<TopoGraphNode>();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public Collection<TopoGraphNode> getDependents() {
        return this.dependents;
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AttribTopoGraphNode)) {
            return false;
        }
        AttribTopoGraphNode other = (AttribTopoGraphNode)o;
        return this.nodeName.equals(other.nodeName);
    }
}

