/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.events.RowsDeletedEvent;

public abstract class AbstractTableFacade
implements CyTable {
    private final CyTable actual;
    private final CyEventHelper cyEventHelper;
    private final Long suid;
    private final Map<CyRow, CyRow> facadeRows;
    private final Map<CyColumn, CyColumn> facadeColumns;
    private boolean isPublic = true;
    private final Object lock = new Object();

    public AbstractTableFacade(CyTable actual, CyEventHelper eventHelper) {
        this.actual = actual;
        this.cyEventHelper = eventHelper;
        this.suid = SUIDFactory.getNextSUID();
        this.facadeRows = new MapMaker().weakKeys().makeMap();
        this.facadeColumns = new MapMaker().weakKeys().makeMap();
    }

    public Long getSUID() {
        return this.suid;
    }

    public String toString() {
        return this.actual.toString();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public CyTable.Mutability getMutability() {
        return this.actual.getMutability();
    }

    public String getTitle() {
        return this.actual.getTitle();
    }

    public void setTitle(String title) {
        this.actual.setTitle(title);
    }

    public CyColumn getPrimaryKey() {
        return this.actual.getPrimaryKey();
    }

    public CyColumn getColumn(String columnName) {
        CyColumn actualColumn = this.actual.getColumn(columnName);
        if (actualColumn == null) {
            return null;
        }
        return this.getFacadeColumn(actualColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CyColumn getFacadeColumn(CyColumn actualColumn) {
        Object object = this.lock;
        synchronized (object) {
            CyColumn ret = this.facadeColumns.get(actualColumn);
            if (ret == null) {
                ret = new ColumnFacade(actualColumn);
                this.facadeColumns.put(actualColumn, ret);
            }
            return ret;
        }
    }

    public Collection<CyColumn> getColumns() {
        return this.getFacadeColumns(this.actual.getColumns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<CyColumn> getFacadeColumns(Collection<CyColumn> columns) {
        ArrayList<CyColumn> facadeColumns = new ArrayList<CyColumn>(columns.size());
        Object object = this.lock;
        synchronized (object) {
            columns.forEach(c -> facadeColumns.add(this.getFacadeColumn((CyColumn)c)));
        }
        return facadeColumns;
    }

    public CyRow getRow(Object primaryKey) {
        CyRow actualRow = this.actual.getRow(primaryKey);
        if (actualRow == null) {
            return null;
        }
        return this.getFacadeRow(actualRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CyRow getFacadeRow(CyRow actualRow) {
        Object object = this.lock;
        synchronized (object) {
            CyRow ret = this.facadeRows.get(actualRow);
            if (ret == null) {
                ret = new RowFacade(actualRow, this);
                this.facadeRows.put(actualRow, ret);
            }
            return ret;
        }
    }

    public boolean rowExists(Object primaryKey) {
        return this.actual.rowExists(primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRows(Collection<?> primaryKeys) {
        for (Object pk : primaryKeys) {
            CyRow row = this.actual.getRow(pk);
            Object object = this.lock;
            synchronized (object) {
                if (row != null && this.facadeRows.containsKey(row)) {
                    this.facadeRows.remove(row);
                }
            }
        }
        boolean changed = this.actual.deleteRows(primaryKeys);
        if (changed) {
            this.cyEventHelper.fireEvent((CyEvent)new RowsDeletedEvent((CyTable)this, primaryKeys));
        }
        return changed;
    }

    public List<CyRow> getAllRows() {
        return this.getFacadeRows(this.actual.getAllRows());
    }

    public String getLastInternalError() {
        return this.actual.getLastInternalError();
    }

    public Collection<CyRow> getMatchingRows(String columnName, Object value) {
        return this.getFacadeRows(this.actual.getMatchingRows(columnName, value));
    }

    public <T> Collection<T> getMatchingKeys(String columnName, Object value, Class<T> type) {
        return this.actual.getMatchingKeys(columnName, value, type);
    }

    private final List<CyRow> getFacadeRows(Collection<CyRow> rows) {
        ArrayList<CyRow> frows = new ArrayList<CyRow>(rows.size());
        for (CyRow r : rows) {
            frows.add(this.getFacadeRow(r));
        }
        return frows;
    }

    public int countMatchingRows(String columnName, Object value) {
        return this.actual.countMatchingRows(columnName, value);
    }

    public int getRowCount() {
        return this.actual.getRowCount();
    }

    public SavePolicy getSavePolicy() {
        return SavePolicy.DO_NOT_SAVE;
    }

    public void setSavePolicy(SavePolicy policy) {
        if (policy != SavePolicy.DO_NOT_SAVE) {
            throw new IllegalArgumentException("This table cannot be saved");
        }
    }

    public void swap(CyTable otherTable) {
        this.actual.swap(otherTable);
    }

    protected abstract void updateColumnName(String var1, String var2);

    private final class ColumnFacade
    implements CyColumn {
        private final CyColumn actualColumn;

        public ColumnFacade(CyColumn actualColumn) {
            this.actualColumn = actualColumn;
        }

        public Long getSUID() {
            return this.actualColumn.getSUID();
        }

        public String getName() {
            return this.actualColumn.getName();
        }

        public void setName(String newName) {
            AbstractTableFacade.this.updateColumnName(this.actualColumn.getName(), newName);
        }

        public Class<?> getType() {
            return this.actualColumn.getType();
        }

        public Class<?> getListElementType() {
            return this.actualColumn.getListElementType();
        }

        public boolean isPrimaryKey() {
            return this.actualColumn.isPrimaryKey();
        }

        public boolean isImmutable() {
            return this.actualColumn.isImmutable();
        }

        public CyTable getTable() {
            return AbstractTableFacade.this;
        }

        public <T> List<T> getValues(Class<? extends T> type) {
            return this.actualColumn.getValues(type);
        }

        public VirtualColumnInfo getVirtualColumnInfo() {
            return this.actualColumn.getVirtualColumnInfo();
        }

        public Object getDefaultValue() {
            return this.actualColumn.getDefaultValue();
        }

        public String toString() {
            return this.actualColumn.toString();
        }
    }

    private final class RowFacade
    implements CyRow {
        private final CyRow actualRow;
        private final CyTable table;

        RowFacade(CyRow actualRow, CyTable table) {
            this.actualRow = actualRow;
            this.table = table;
        }

        public Long getSUID() {
            return this.actualRow.getSUID();
        }

        public void set(String attributeName, Object value) {
            if (value != null && attributeName != null && attributeName.equals("edges.SUID")) {
                System.out.println("facade set (" + Long.toString((Long)this.actualRow.get("SUID", Long.class)) + " - " + this.table.getTitle() + ") " + attributeName + " " + value.toString());
                Thread.dumpStack();
            }
            this.actualRow.set(attributeName, value);
        }

        public <T> T get(String attributeName, Class<? extends T> c) {
            if (attributeName != null && c != null && attributeName.equals("edges.SUID")) {
                System.out.println("facade GET (" + Long.toString((Long)this.actualRow.get("SUID", Long.class)) + " - " + this.table.getTitle() + ") " + attributeName + " = " + this.actualRow.get(attributeName, c));
                Thread.dumpStack();
            }
            return (T)this.actualRow.get(attributeName, c);
        }

        public <T> T get(String attributeName, Class<? extends T> c, T defValue) {
            if (attributeName != null && c != null && attributeName.equals("edges.SUID")) {
                System.out.println("facade GET (" + Long.toString((Long)this.actualRow.get("SUID", Long.class)) + " - " + this.table.getTitle() + ") " + attributeName + " = " + this.actualRow.get(attributeName, c, defValue).toString());
                Thread.dumpStack();
            }
            return (T)this.actualRow.get(attributeName, c, defValue);
        }

        public <T> List<T> getList(String attributeName, Class<T> c) {
            if (attributeName != null && c != null && attributeName.equals("edges.SUID")) {
                System.out.println("facade GET LIST (" + Long.toString((Long)this.actualRow.get("SUID", Long.class)) + " - " + this.table.getTitle() + ") " + attributeName + " = " + this.actualRow.getList(attributeName, c).toString());
                Thread.dumpStack();
            }
            return this.actualRow.getList(attributeName, c);
        }

        public <T> List<T> getList(String attributeName, Class<T> c, List<T> defValue) {
            if (attributeName != null && c != null && attributeName.equals("edges.SUID")) {
                System.out.println("facade GET LIST (" + Long.toString((Long)this.actualRow.get("SUID", Long.class)) + " - " + this.table.getTitle() + ") " + attributeName + " = " + this.actualRow.getList(attributeName, c, defValue).toString());
                Thread.dumpStack();
            }
            return this.actualRow.getList(attributeName, c, defValue);
        }

        public Object getRaw(String attributeName) {
            return this.actualRow.getRaw(attributeName);
        }

        public boolean isSet(String attributeName) {
            return this.actualRow.isSet(attributeName);
        }

        public Map<String, Object> getAllValues() {
            return this.actualRow.getAllValues();
        }

        public CyTable getTable() {
            return this.table;
        }

        public String toString() {
            return "FACADE of: " + this.actualRow.toString();
        }
    }
}

