/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.edge.bundler.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.edge.bundler.internal.EdgeBundlerTask;

public final class EdgeCompatabilityRunner
implements Runnable {
    private final EdgeBundlerTask bundlerTask;
    private final Map<Integer, List<Integer>> edgeMatcher;
    private final int ei;
    private final double COMPATABILITY_THRESHOLD;

    public EdgeCompatabilityRunner(EdgeBundlerTask bundlerTask, int ei, Map<Integer, List<Integer>> edgeMatcher) {
        this.bundlerTask = bundlerTask;
        this.ei = ei;
        this.edgeMatcher = edgeMatcher;
        this.COMPATABILITY_THRESHOLD = bundlerTask.threshold();
    }

    @Override
    public void run() {
        ArrayList<Integer> compatibleEdges = new ArrayList<Integer>();
        for (int ej = 0; ej < this.ei && !this.bundlerTask.isCancelled(); ++ej) {
            if (!(this.bundlerTask.cEdgeCompatability(this.ei, ej) > this.COMPATABILITY_THRESHOLD)) continue;
            compatibleEdges.add(ej);
        }
        if (compatibleEdges.size() > 0) {
            this.edgeMatcher.put(this.ei, compatibleEdges);
        }
    }
}

