/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.edge.bundler.internal;

import java.util.List;
import java.util.Map;
import org.cytoscape.edge.bundler.internal.EdgeBundlerTask;

public final class EdgeBundlerRunner
implements Runnable {
    private final int ei;
    private final int numNubs;
    private final double[][][] nubs;
    private final double[][][] forces;
    private final EdgeBundlerTask bundlerTask;
    private final Map<Integer, List<Integer>> edgeMatcher;

    public EdgeBundlerRunner(int ei, int numNubs, EdgeBundlerTask bundlerTask, double[][][] nubs, double[][][] forces, Map<Integer, List<Integer>> edgeMatcher) {
        this.ei = ei;
        this.numNubs = numNubs;
        this.nubs = nubs;
        this.forces = forces;
        this.bundlerTask = bundlerTask;
        this.edgeMatcher = edgeMatcher;
    }

    @Override
    public void run() {
        for (int ni = 0; ni < this.numNubs; ++ni) {
            for (int ej : this.edgeMatcher.get(this.ei)) {
                int nj = this.bundlerTask.cEdgeAlign(this.ei, ej) ? ni : this.numNubs - ni - 1;
                double diffx = this.nubs[ni][0][this.ei] - this.nubs[nj][0][ej];
                double diffy = this.nubs[ni][1][this.ei] - this.nubs[nj][1][ej];
                double edgeCompatability = this.bundlerTask.cEdgeCompatability(this.ei, ej);
                if (Math.abs(diffx) > 1.0) {
                    double fx = edgeCompatability / diffx;
                    double[] dArray = this.forces[ni][0];
                    int n = this.ei;
                    dArray[n] = dArray[n] - fx;
                    double[] dArray2 = this.forces[nj][0];
                    int n2 = ej;
                    dArray2[n2] = dArray2[n2] + fx;
                }
                if (!(Math.abs(diffy) > 1.0)) continue;
                double fy = edgeCompatability / diffy;
                double[] dArray = this.forces[ni][1];
                int n = this.ei;
                dArray[n] = dArray[n] - fy;
                double[] dArray3 = this.forces[nj][1];
                int n3 = ej;
                dArray3[n3] = dArray3[n3] + fy;
            }
        }
    }
}

