/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;
import org.ivis.layout.util.Polyomino;
import org.ivis.layout.util.PolyominoQuickSort;

public class PolyominoPacking {
    Polyomino[] polyominoes;
    Rectangle[] rect;
    byte[][] grid;
    int gcx;
    int gcy;
    int sizeX;
    int sizeY;
    int curmino;
    int[] ind;
    Random Rgen;

    public void pack(Polyomino[] pm, int pcount) {
        this.polyominoes = pm;
        this.rect = new Rectangle[pcount];
        this.makeGrid(100, 100, 0);
        this.Rgen = new Random(1L);
        for (int k = 0; k < pcount; ++k) {
            this.RandomizeMino(k);
        }
        double[] key = new double[pcount];
        this.ind = new int[pcount];
        for (int i = 0; i < pcount; ++i) {
            key[i] = -(this.rect[i].getMaxX() - this.rect[i].getMinX()) - (this.rect[i].getMaxY() - this.rect[i].getMinY());
        }
        PolyominoQuickSort qsort = new PolyominoQuickSort();
        qsort.sort(pcount, key, this.ind);
        this.curmino = 0;
        while (this.curmino < pcount) {
            this.putMino(this.ind[this.curmino]);
            ++this.curmino;
        }
    }

    void makeGrid(int dimx, int dimy, int mN) {
        int i;
        this.grid = new byte[dimy][];
        for (i = 0; i < dimy; ++i) {
            this.grid[i] = new byte[dimx];
        }
        int dx = dimx / 2 - this.gcx;
        int dy = dimy / 2 - this.gcy;
        this.gcx = dimx / 2;
        this.gcy = dimy / 2;
        this.sizeX = dimx;
        this.sizeY = dimy;
        for (i = 0; i < mN; ++i) {
            Polyomino p = this.polyominoes[this.ind[i]];
            p.x += dx;
            p.y += dy;
            for (int k = 0; k < p.l; ++k) {
                int xx = (int)(p.coord[k].getX() + (double)p.x);
                int yy = (int)(p.coord[k].getY() + (double)p.y);
                this.grid[yy][xx] = 1;
            }
        }
    }

    boolean IsFreePlace(int x, int y, Polyomino p) {
        for (int k = 0; k < p.l; ++k) {
            int xx = (int)(p.coord[k].getX() + (double)x);
            int yy = (int)(p.coord[k].getY() + (double)y);
            if (xx < 0 || yy < 0 || xx >= this.sizeX || yy >= this.sizeY) {
                return false;
            }
            if (this.grid[yy][xx] == 0) continue;
            return false;
        }
        p.x = x;
        p.y = y;
        return true;
    }

    boolean tryPlacing(int pi) {
        int cy;
        Polyomino p = this.polyominoes[pi];
        int cx = this.gcx - (int)(this.rect[pi].getMaxX() + this.rect[pi].getMinX()) / 2;
        if (this.IsFreePlace(cx, cy = this.gcy - (int)(this.rect[pi].getMaxY() + this.rect[pi].getMinY()) / 2, p)) {
            return true;
        }
        for (int d = 1; d < this.sizeX / 2; ++d) {
            for (int i = -d; i < d; ++i) {
                int i1 = (i + d + 1) / 2 * ((i & 1) == 1 ? 1 : -1);
                if (this.IsFreePlace(-d + cx, -i1 + cy, p)) {
                    return true;
                }
                if (this.IsFreePlace(d + cx, i1 + cy, p)) {
                    return true;
                }
                if (this.IsFreePlace(cx - i1, d + cy, p)) {
                    return true;
                }
                if (!this.IsFreePlace(i1 + cx, -d + cy, p)) continue;
                return true;
            }
        }
        return false;
    }

    void putMino(int pi) {
        Polyomino p = this.polyominoes[pi];
        while (!this.tryPlacing(pi)) {
            this.sizeX += 10;
            this.sizeY += 10;
            this.makeGrid(this.sizeX, this.sizeY, this.curmino);
        }
        for (int k = 0; k < p.l; ++k) {
            int xx = (int)(p.coord[k].getX() + (double)p.x);
            int yy = (int)(p.coord[k].getY() + (double)p.y);
            this.grid[yy][xx] = 1;
        }
    }

    void RandomizeMino(int pi) {
        int i;
        Polyomino p = this.polyominoes[pi];
        for (i = 0; i < p.l; ++i) {
            int i1 = this.Rgen.nextInt(p.l - i) + i;
            Point tmp = p.coord[i];
            p.coord[i] = p.coord[i1];
            p.coord[i1] = tmp;
        }
        this.rect[pi] = new Rectangle();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        p.y = 0;
        p.x = 0;
        for (i = 0; i < p.l; ++i) {
            if (p.coord[i].getX() < (double)minX) {
                minX = (int)p.coord[i].getX();
            }
            if (p.coord[i].getY() < (double)minY) {
                minY = (int)p.coord[i].getY();
            }
            if (p.coord[i].getX() > (double)maxX) {
                maxX = (int)p.coord[i].getX();
            }
            if (!(p.coord[i].getY() > (double)maxY)) continue;
            maxY = (int)p.coord[i].getY();
        }
        this.rect[pi].x = minX;
        this.rect[pi].y = minY;
        this.rect[pi].width = maxX - minX;
        this.rect[pi].height = maxY - minY;
    }
}

