/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.LayoutConstants;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.ProgressListener;
import org.ivis.layout.Updatable;
import org.ivis.util.PointD;
import org.ivis.util.Transform;

public abstract class Layout {
    public int layoutQuality = 1;
    public boolean createBendsAsNeeded = false;
    public boolean incremental = false;
    public boolean animationOnLayout = true;
    public boolean animationDuringLayout = false;
    public int animationPeriod = 50;
    public boolean uniformLeafNodeSizes = false;
    protected LGraphManager graphManager;
    private boolean isLayoutFinished = false;
    public boolean isSubLayout = false;
    protected HashMap edgeToDummyNodes = new HashMap();
    protected boolean isRemoteUse = false;
    public long executionTime = 0L;
    protected volatile boolean cancelled;
    private Set<ProgressListener> progressListeners = new LinkedHashSet<ProgressListener>();
    public static final long RANDOM_SEED = 1L;

    public Layout() {
        this.graphManager = this.newGraphManager();
        assert (this.graphManager != null);
    }

    public Layout(boolean isRemoteUse) {
        this();
        this.isRemoteUse = isRemoteUse;
    }

    public LGraphManager getGraphManager() {
        return this.graphManager;
    }

    public Object[] getAllNodes() {
        return this.graphManager.getAllNodes();
    }

    public Object[] getAllEdges() {
        return this.graphManager.getAllEdges();
    }

    public Object[] getAllNodesToApplyGravitation() {
        return this.graphManager.getAllNodesToApplyGravitation();
    }

    protected LGraphManager newGraphManager() {
        LGraphManager gm;
        this.graphManager = gm = new LGraphManager(this);
        return gm;
    }

    public LGraph newGraph(Object vGraph) {
        return new LGraph(null, this.graphManager, vGraph);
    }

    public LNode newNode(Object vNode) {
        return new LNode(this.graphManager, vNode);
    }

    public LEdge newEdge(Object vEdge) {
        return new LEdge(null, null, vEdge);
    }

    public boolean runLayout() {
        boolean isLayoutSuccessfull;
        this.isLayoutFinished = false;
        if (!this.isSubLayout) {
            this.doPreLayout();
        }
        this.initParameters();
        if (this.graphManager.getRoot() == null || this.graphManager.getRoot().getNodes().size() == 0 || this.graphManager.includesInvalidEdge()) {
            isLayoutSuccessfull = false;
        } else {
            long startTime = 0L;
            if (!this.isSubLayout) {
                startTime = System.currentTimeMillis();
            }
            isLayoutSuccessfull = this.layout();
            if (!this.isSubLayout) {
                long excTime;
                long endTime = System.currentTimeMillis();
                this.executionTime = excTime = endTime - startTime;
                System.out.println("Total execution time: " + excTime + " miliseconds.");
                LayoutConstants.time = excTime;
            }
        }
        if (isLayoutSuccessfull && !this.isSubLayout) {
            this.doPostLayout();
        }
        this.isLayoutFinished = true;
        return isLayoutSuccessfull;
    }

    public void doPreLayout() {
    }

    public void doPostLayout() {
        assert (!this.isSubLayout) : "Should not be called on sub-layout!";
        this.transform();
        this.update();
    }

    public abstract boolean layout();

    public void update() {
        if (this.createBendsAsNeeded) {
            this.createBendpointsFromDummyNodes();
            this.graphManager.resetAllEdges();
        }
        if (!this.isRemoteUse) {
            for (Object obj : this.graphManager.getAllEdges()) {
                LEdge edge = (LEdge)obj;
                this.update(edge);
            }
            for (Object obj : this.graphManager.getRoot().getNodes()) {
                LNode node = (LNode)obj;
                this.update(node);
            }
            this.update(this.graphManager.getRoot());
        }
    }

    public void update(LNode node) {
        if (node.getChild() != null) {
            for (Object obj : node.getChild().getNodes()) {
                this.update((LNode)obj);
            }
        }
        if (node.vGraphObject != null) {
            Updatable vNode = (Updatable)node.vGraphObject;
            vNode.update(node);
        }
    }

    public void update(LEdge edge) {
        if (edge.vGraphObject != null) {
            Updatable vEdge = (Updatable)edge.vGraphObject;
            vEdge.update(edge);
        }
    }

    public void update(LGraph graph) {
        if (graph.vGraphObject != null) {
            Updatable vGraph = (Updatable)graph.vGraphObject;
            vGraph.update(graph);
        }
    }

    public void initParameters() {
        if (!this.isSubLayout) {
            LayoutOptionsPack.General layoutOptionsPack = LayoutOptionsPack.getInstance().getGeneral();
            this.layoutQuality = layoutOptionsPack.layoutQuality;
            this.animationDuringLayout = layoutOptionsPack.animationDuringLayout;
            this.animationPeriod = (int)Layout.transform(layoutOptionsPack.animationPeriod, 50.0);
            this.animationOnLayout = layoutOptionsPack.animationOnLayout;
            this.incremental = layoutOptionsPack.incremental;
            this.createBendsAsNeeded = layoutOptionsPack.createBendsAsNeeded;
            this.uniformLeafNodeSizes = layoutOptionsPack.uniformLeafNodeSizes;
        }
        if (this.animationDuringLayout) {
            this.animationOnLayout = false;
        }
    }

    public void transform() {
        this.transform(new PointD(0.0, 0.0));
    }

    public void transform(PointD newLeftTop) {
        Transform trans = new Transform();
        Point leftTop = this.graphManager.getRoot().updateLeftTop();
        if (leftTop != null) {
            trans.setWorldOrgX(newLeftTop.x);
            trans.setWorldOrgY(newLeftTop.y);
            trans.setDeviceOrgX(leftTop.x);
            trans.setDeviceOrgY(leftTop.y);
            Object[] nodes = this.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                LNode node = (LNode)nodes[i];
                node.transform(trans);
            }
        }
    }

    public void positionNodesRandomly() {
        assert (!this.incremental);
        this.positionNodesRandomly(this.getGraphManager().getRoot());
        this.getGraphManager().getRoot().updateBounds(true);
    }

    private void positionNodesRandomly(LGraph graph) {
        for (Object obj : graph.getNodes()) {
            LNode lNode = (LNode)obj;
            LGraph childGraph = lNode.getChild();
            if (childGraph == null) {
                lNode.scatter();
                continue;
            }
            if (childGraph.getNodes().size() == 0) {
                lNode.scatter();
                continue;
            }
            this.positionNodesRandomly(childGraph);
            lNode.updateBounds();
        }
    }

    public ArrayList<ArrayList<LNode>> getFlatForest() {
        ArrayList<ArrayList<LNode>> flatForest = new ArrayList<ArrayList<LNode>>();
        boolean isForest = true;
        List allNodes = this.graphManager.getRoot().getNodes();
        boolean isFlat = true;
        for (int i = 0; i < allNodes.size(); ++i) {
            if (((LNode)allNodes.get(i)).getChild() == null) continue;
            isFlat = false;
        }
        if (!isFlat) {
            return flatForest;
        }
        HashSet<LNode> visited = new HashSet<LNode>();
        LinkedList<LNode> toBeVisited = new LinkedList<LNode>();
        HashMap<LNode, LNode> parents = new HashMap<LNode, LNode>();
        LinkedList unProcessedNodes = new LinkedList();
        unProcessedNodes.addAll(allNodes);
        while (unProcessedNodes.size() > 0 && isForest) {
            toBeVisited.add((LNode)unProcessedNodes.getFirst());
            block2: while (!toBeVisited.isEmpty() && isForest) {
                LNode currentNode = (LNode)toBeVisited.poll();
                visited.add(currentNode);
                List neighborEdges = currentNode.getEdges();
                for (int i = 0; i < neighborEdges.size(); ++i) {
                    LNode currentNeighbor = ((LEdge)neighborEdges.get(i)).getOtherEnd(currentNode);
                    if (parents.get(currentNode) == currentNeighbor) continue;
                    if (!visited.contains(currentNeighbor)) {
                        toBeVisited.addLast(currentNeighbor);
                        parents.put(currentNeighbor, currentNode);
                        continue;
                    }
                    isForest = false;
                    continue block2;
                }
            }
            if (!isForest) {
                flatForest.clear();
                continue;
            }
            flatForest.add(new ArrayList(visited));
            unProcessedNodes.removeAll(visited);
            visited.clear();
            parents.clear();
        }
        return flatForest;
    }

    public List createDummyNodesForBendpoints(LEdge edge) {
        ArrayList<LNode> dummyNodes = new ArrayList<LNode>();
        LNode prev = edge.source;
        LGraph graph = this.graphManager.calcLowestCommonAncestor(edge.source, edge.target);
        for (int i = 0; i < edge.bendpoints.size(); ++i) {
            LNode dummyNode = this.newNode(null);
            dummyNode.setRect(new Point(0, 0), new Dimension(1, 1));
            graph.add(dummyNode);
            LEdge dummyEdge = this.newEdge(null);
            this.graphManager.add(dummyEdge, prev, dummyNode);
            dummyNodes.add(dummyNode);
            prev = dummyNode;
        }
        LEdge dummyEdge = this.newEdge(null);
        this.graphManager.add(dummyEdge, prev, edge.target);
        this.edgeToDummyNodes.put(edge, dummyNodes);
        if (edge.isInterGraph()) {
            this.graphManager.remove(edge);
        } else {
            graph.remove(edge);
        }
        return dummyNodes;
    }

    public void createBendpointsFromDummyNodes() {
        ArrayList<Object> edges = new ArrayList<Object>();
        edges.addAll(Arrays.asList(this.graphManager.getAllEdges()));
        edges.addAll(0, this.edgeToDummyNodes.keySet());
        for (int k = 0; k < edges.size(); ++k) {
            LEdge lEdge = (LEdge)edges.get(k);
            if (lEdge.bendpoints.size() <= 0) continue;
            List path = (List)this.edgeToDummyNodes.get(lEdge);
            for (int i = 0; i < path.size(); ++i) {
                LNode dummyNode = (LNode)path.get(i);
                PointD p = new PointD(dummyNode.getCenterX(), dummyNode.getCenterY());
                PointD ebp = lEdge.bendpoints.get(i);
                ebp.x = p.x;
                ebp.y = p.y;
                dummyNode.getOwner().remove(dummyNode);
            }
            this.graphManager.add(lEdge, lEdge.source, lEdge.target);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    protected void updateProgress(double value) {
        for (ProgressListener listener : this.progressListeners) {
            listener.update(value);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public static double transform(int sliderValue, double defaultValue) {
        double b;
        double a;
        if (sliderValue <= 50) {
            a = 9.0 * defaultValue / 500.0;
            b = defaultValue / 10.0;
        } else {
            a = 9.0 * defaultValue / 50.0;
            b = -8.0 * defaultValue;
        }
        return a * (double)sliderValue + b;
    }

    public static double transform(int sliderValue, double defaultValue, double minDiv, double maxMul) {
        double value = defaultValue;
        if (sliderValue <= 50) {
            double minValue = defaultValue / minDiv;
            value -= (defaultValue - minValue) / 50.0 * (double)(50 - sliderValue);
        } else {
            double maxValue = defaultValue * maxMul;
            value += (maxValue - defaultValue) / 50.0 * (double)(sliderValue - 50);
        }
        return value;
    }

    public static List<LNode> findCenterOfEachTree(List<List> listofLists) {
        ArrayList<LNode> centers = new ArrayList<LNode>();
        for (int i = 0; i < listofLists.size(); ++i) {
            List list = listofLists.get(i);
            LNode center = Layout.findCenterOfTree(list);
            centers.add(i, center);
        }
        return centers;
    }

    public static LNode findCenterOfTree(List<LNode> nodes) {
        ArrayList<LNode> list = new ArrayList<LNode>();
        list.addAll(nodes);
        ArrayList<LNode> removedNodes = new ArrayList<LNode>();
        HashMap<LNode, Integer> remainingDegrees = new HashMap<LNode, Integer>();
        boolean foundCenter = false;
        LNode centerNode = null;
        if (list.size() == 1 || list.size() == 2) {
            foundCenter = true;
            centerNode = (LNode)list.get(0);
        }
        for (LNode node : list) {
            Integer degree = new Integer(node.getNeighborsList().size());
            remainingDegrees.put(node, degree);
            if (degree != 1) continue;
            removedNodes.add(node);
        }
        ArrayList<LNode> tempList = new ArrayList<LNode>();
        tempList.addAll(removedNodes);
        while (!foundCenter) {
            ArrayList<LNode> tempList2 = new ArrayList<LNode>();
            tempList2.addAll(tempList);
            tempList.removeAll(tempList);
            for (LNode node : tempList2) {
                list.remove(node);
                Set neighbours = node.getNeighborsList();
                for (LNode neighbor : neighbours) {
                    if (removedNodes.contains(neighbor)) continue;
                    Integer otherDegree = (Integer)remainingDegrees.get(neighbor);
                    Integer newDegree = new Integer(otherDegree - 1);
                    if (newDegree == 1) {
                        tempList.add(neighbor);
                    }
                    remainingDegrees.put(neighbor, newDegree);
                }
            }
            removedNodes.addAll(tempList);
            if (list.size() != 1 && list.size() != 2) continue;
            foundCenter = true;
            centerNode = (LNode)list.get(0);
        }
        return centerNode;
    }

    public void setGraphManager(LGraphManager gm) {
        this.graphManager = gm;
    }
}

