/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.graphPartition;

import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.PrimeFinder;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import csapps.layout.algorithms.graphPartition.ISOMLayoutContext;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class ISOMLayoutTask
extends AbstractPartitionLayoutTask {
    private int epoch;
    private double adaption;
    private LayoutPartition partition;
    private LongArrayList q;
    OpenLongObjectHashMap nodeIndexToDataMap;
    OpenLongIntHashMap nodeIndexToLayoutIndex;
    double globalX;
    double globalY;
    double squared_size;
    CyNetwork network;
    private ISOMLayoutContext context;

    public ISOMLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, ISOMLayoutContext context, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
        this.network = (CyNetwork)networkView.getModel();
        this.q = new LongArrayList();
    }

    public void layoutPartition(LayoutPartition partition) {
        this.partition = partition;
        int nodeCount = partition.nodeCount();
        this.nodeIndexToDataMap = new OpenLongObjectHashMap(PrimeFinder.nextPrime((int)nodeCount));
        this.nodeIndexToLayoutIndex = new OpenLongIntHashMap(PrimeFinder.nextPrime((int)nodeCount));
        this.squared_size = (double)this.network.getNodeCount() * this.context.sizeFactor;
        this.epoch = 1;
        this.adaption = this.context.initialAdaptation;
        while (this.epoch < this.context.maxEpoch) {
            partition.resetNodes();
            this.adjust();
            this.updateParameters();
            if (!this.cancelled) continue;
            break;
        }
    }

    public long getClosestPosition(double x, double y) {
        double minDistance = Double.MAX_VALUE;
        long closest = 0L;
        Iterator nodeIter = this.partition.nodeIterator();
        while (nodeIter.hasNext()) {
            double dy;
            LayoutNode node = (LayoutNode)nodeIter.next();
            long rootGraphIndex = node.getNode().getSUID();
            this.nodeIndexToLayoutIndex.put(rootGraphIndex, node.getIndex());
            double dx = node.getX();
            double dist = dx * dx + (dy = node.getY()) * dy;
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = rootGraphIndex;
        }
        return closest;
    }

    public void adjust() {
        ISOMVertexData tempISOM = new ISOMVertexData();
        this.globalX = 10.0 + Math.random() * this.squared_size;
        this.globalY = 10.0 + Math.random() * this.squared_size;
        long winner = this.getClosestPosition(this.globalX, this.globalY);
        Iterator nodeIter = this.partition.nodeIterator();
        while (nodeIter.hasNext()) {
            long nodeIndex = ((LayoutNode)nodeIter.next()).getNode().getSUID();
            ISOMVertexData ivd = this.getISOMVertexData(nodeIndex);
            ivd.distance = 0;
            ivd.visited = false;
        }
        this.adjustVertex(winner);
    }

    public void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.context.coolingFactor * (1.0 * (double)this.epoch / (double)this.context.maxEpoch));
        this.adaption = Math.max(this.context.minAdaptation, factor * this.context.initialAdaptation);
        if (this.context.radius > this.context.minRadius && this.epoch % this.context.radiusConstantTime == 0) {
            --this.context.radius;
        }
    }

    public void adjustVertex(long v) {
        this.q.clear();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.q.add(v);
        List nodeList = this.partition.getNodeList();
        while (!this.q.isEmpty()) {
            long current = this.q.get(0);
            this.q.remove(0);
            int layoutIndex = this.nodeIndexToLayoutIndex.get(current);
            LayoutNode currentNode = (LayoutNode)nodeList.get(layoutIndex);
            ISOMVertexData currData = this.getISOMVertexData(current);
            double current_x = currentNode.getX();
            double current_y = currentNode.getY();
            double dx = this.globalX - current_x;
            double dy = this.globalY - current_y;
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            currentNode.setX(current_x + factor * dx);
            currentNode.setY(current_y + factor * dy);
            this.partition.moveNodeToLocation(currentNode);
            if (currData.distance >= this.context.radius) continue;
            long[] neighbors = this.neighborsArray(this.network, currentNode.getNode());
            for (int neighbor_index = 0; neighbor_index < neighbors.length; ++neighbor_index) {
                ISOMVertexData childData = this.getISOMVertexData(neighbors[neighbor_index]);
                if (childData.visited) continue;
                childData.visited = true;
                childData.distance = currData.distance + 1;
                this.q.add(neighbors[neighbor_index]);
            }
        }
    }

    public ISOMVertexData getISOMVertexData(long v) {
        ISOMVertexData vd = (ISOMVertexData)this.nodeIndexToDataMap.get(v);
        if (vd == null) {
            vd = new ISOMVertexData();
            this.nodeIndexToDataMap.put(v, (Object)vd);
        }
        return vd;
    }

    public long[] neighborsArray(CyNetwork network, CyNode node) {
        List neighborList = network.getNeighborList(node, CyEdge.Type.ANY);
        long[] neighbors = new long[neighborList.size()];
        int offset = 0;
        for (CyNode n : neighborList) {
            neighbors[offset++] = n.getSUID();
        }
        return neighbors;
    }

    public static class ISOMVertexData {
        public DoubleMatrix1D disp;
        int distance;
        boolean visited;

        public ISOMVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
            this.distance = 0;
            this.visited = false;
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

