/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.graphPartition;

import csapps.layout.algorithms.graphPartition.AttributeCircleLayoutContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class AttributeCircleLayoutTask
extends AbstractPartitionLayoutTask {
    private final AttributeCircleLayoutContext context;

    public AttributeCircleLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, AttributeCircleLayoutContext context, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
    }

    public void layoutPartition(LayoutPartition partition) {
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>();
        for (LayoutNode ln : partition.getNodeList()) {
            if (ln.isLocked()) continue;
            nodes.add(ln);
        }
        int count = nodes.size();
        int r = (int)Math.sqrt(count);
        r = (int)((double)r * this.context.spacing);
        if (this.layoutAttribute != null && count > 0) {
            Class klass;
            CyColumn column = ((LayoutNode)nodes.get(0)).getRow().getTable().getColumn(this.layoutAttribute);
            Class clazz = klass = column == null ? null : column.getType();
            if (klass != null && Comparable.class.isAssignableFrom(klass)) {
                Collections.sort(nodes, new AttributeComparator(klass));
            }
        }
        double phi = Math.PI * 2 / (double)count;
        partition.resetNodes();
        for (int i = 0; i < count; ++i) {
            LayoutNode node = (LayoutNode)nodes.get(i);
            double x = (double)r + (double)r * Math.sin((double)i * phi);
            double y = (double)r + (double)r * Math.cos((double)i * phi);
            node.setX(x);
            node.setY(y);
            partition.moveNodeToLocation(node);
        }
    }

    private class AttributeComparator<T extends Comparable<T>>
    implements Comparator<LayoutNode> {
        Class<T> klass;

        private AttributeComparator(Class<T> klass) {
            this.klass = klass;
        }

        @Override
        public int compare(LayoutNode o1, LayoutNode o2) {
            Comparable v1 = (Comparable)o1.getRow().get(AttributeCircleLayoutTask.this.layoutAttribute, this.klass);
            Comparable v2 = (Comparable)o2.getRow().get(AttributeCircleLayoutTask.this.layoutAttribute, this.klass);
            if (String.class.isAssignableFrom(this.klass)) {
                String s1 = (String)String.class.cast(v1);
                String s2 = (String)String.class.cast(v2);
                if (s1 != null && s2 != null) {
                    return s1.compareToIgnoreCase(s2);
                }
                if (s1 == null && s2 != null) {
                    return -1;
                }
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 != null && s2 == null) {
                    return 1;
                }
            } else {
                return this.compareEvenIfNull(v1, v2);
            }
            return 0;
        }

        public int compareEvenIfNull(T v1, T v2) {
            if (v1 != null && v2 != null) {
                return v1.compareTo(v2);
            }
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 == null && v2 == null) {
                return 0;
            }
            return 1;
        }
    }
}

