/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.cose;

import csapps.layout.algorithms.cose.CoSELayoutContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.ProgressListener;
import org.ivis.layout.Updatable;
import org.ivis.layout.cose.CoSELayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoSELayoutAlgorithmTask
extends AbstractPartitionLayoutTask {
    private CoSELayout cose;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CoSELayoutAlgorithmTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, CoSELayoutContext context, UndoSupport undo, CyServiceRegistrar serviceRegistrar) {
        super(displayName, true, networkView, nodesToLayOut, "", undo);
        this.serviceRegistrar = serviceRegistrar;
        LayoutOptionsPack.General generalOpt = LayoutOptionsPack.getInstance().getGeneral();
        generalOpt.layoutQuality = context.layoutQuality.getValue();
        generalOpt.incremental = context.incremental;
        LayoutOptionsPack.CoSE coseOpt = LayoutOptionsPack.getInstance().getCoSE();
        coseOpt.idealEdgeLength = context.idealEdgeLength;
        coseOpt.springStrength = context.springStrength;
        coseOpt.repulsionStrength = context.repulsionStrength;
        coseOpt.gravityStrength = context.gravityStrength;
        coseOpt.compoundGravityStrength = context.compoundGravityStrength;
        coseOpt.gravityRange = context.gravityRange;
        coseOpt.compoundGravityRange = context.compoundGravityRange;
        coseOpt.smartEdgeLengthCalc = context.smartEdgeLengthCalc;
        coseOpt.smartRepulsionRangeCalc = context.smartRepulsionRangeCalc;
    }

    public void layoutPartition(LayoutPartition partition) {
        if (this.cancelled) {
            return;
        }
        CyGroupManager groupManager = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        CyNetwork network = (CyNetwork)this.networkView.getModel();
        this.cose = new CoSELayout();
        this.cose.addProgressListener(new ProgressListener(){

            @Override
            public void update(double value) {
                CoSELayoutAlgorithmTask.this.taskMonitor.setProgress(value);
            }
        });
        LGraphManager gm = this.cose.getGraphManager();
        LGraph root = gm.addRoot();
        HashMap<CyNode, LayoutNode> layoutNodeMap = new HashMap<CyNode, LayoutNode>();
        for (Object n : partition.getNodeList()) {
            layoutNodeMap.put(n.getNode(), (LayoutNode)n);
        }
        HashMap<CyNode, LNode> lNodeMap = new HashMap<CyNode, LNode>();
        for (LayoutNode n : partition.getNodeList()) {
            if (!groupManager.getGroupsForNode(n.getNode(), network).isEmpty()) continue;
            this.traverseLNodeTree(n, root, this.cose, lNodeMap, layoutNodeMap, groupManager);
        }
        if (this.cancelled) {
            return;
        }
        HashMap<CyEdge, LEdge> lEdgeMap = new HashMap<CyEdge, LEdge>();
        Iterator edgeIter = partition.edgeIterator();
        while (edgeIter.hasNext() && !this.cancelled) {
            LayoutEdge e = (LayoutEdge)edgeIter.next();
            this.createLEdge(e, this.cose, lNodeMap, lEdgeMap);
        }
        if (this.cancelled) {
            return;
        }
        try {
            this.cose.runLayout();
        }
        catch (Exception e) {
            logger.error("Error running CoSE Layout", (Throwable)e);
            return;
        }
        if (this.cancelled) {
            return;
        }
        for (LayoutNode n : partition.getNodeList()) {
            partition.moveNodeToLocation(n);
        }
    }

    public void cancel() {
        super.cancel();
        if (this.cose != null) {
            this.cose.cancel();
        }
    }

    private void traverseLNodeTree(LayoutNode layoutNode, LGraph graph, CoSELayout cose, Map<CyNode, LNode> lNodeMap, Map<CyNode, LayoutNode> layoutNodeMap, CyGroupManager groupManager) {
        CyGroup group;
        if (lNodeMap.containsKey(layoutNode.getNode())) {
            return;
        }
        LNode ln = this.createLNode(layoutNode, graph, cose, lNodeMap);
        if (groupManager.isGroup(layoutNode.getNode(), (CyNetwork)this.networkView.getModel()) && (group = groupManager.getGroup(layoutNode.getNode(), (CyNetwork)this.networkView.getModel())) != null) {
            LGraphManager gm = cose.getGraphManager();
            LGraph subGraph = gm.add(cose.newGraph("G" + group.getGroupNetwork().getSUID()), ln);
            for (CyNode childNode : group.getNodeList()) {
                LayoutNode childLayoutNode = layoutNodeMap.get(childNode);
                if (childLayoutNode == null) continue;
                this.traverseLNodeTree(childLayoutNode, subGraph, cose, lNodeMap, layoutNodeMap, groupManager);
            }
        }
    }

    private LNode createLNode(LayoutNode layoutNode, LGraph graph, CoSELayout cose, Map<CyNode, LNode> lNodeMap) {
        VNode vn = new VNode(layoutNode);
        LNode ln = graph.add(cose.newNode(vn));
        ln.setCenter(layoutNode.getX(), layoutNode.getY());
        ln.setWidth(layoutNode.getWidth());
        ln.setHeight(layoutNode.getHeight());
        lNodeMap.put(layoutNode.getNode(), ln);
        return ln;
    }

    private LEdge createLEdge(LayoutEdge layoutEdge, CoSELayout cose, Map<CyNode, LNode> lNodeMap, Map<CyEdge, LEdge> lEdgeMap) {
        LNode ln1 = lNodeMap.get(layoutEdge.getSource().getNode());
        LNode ln2 = lNodeMap.get(layoutEdge.getTarget().getNode());
        if (ln1 != null && ln2 != null) {
            VEdge ve = new VEdge(layoutEdge);
            LEdge le = cose.getGraphManager().add(cose.newEdge(ve), ln1, ln2);
            lEdgeMap.put(layoutEdge.getEdge(), le);
            return le;
        }
        return null;
    }

    private class VNode
    implements Updatable {
        private final LayoutNode layoutNode;

        VNode(LayoutNode layoutNode) {
            this.layoutNode = layoutNode;
        }

        @Override
        public void update(LGraphObject go) {
            if (this.layoutNode != null) {
                LNode ln = (LNode)go;
                this.layoutNode.setX(ln.getCenterX());
                this.layoutNode.setY(ln.getCenterY());
            }
        }

        LayoutNode getLayoutNode() {
            return this.layoutNode;
        }
    }

    private class VEdge
    implements Updatable {
        private final LayoutEdge layoutEdge;

        VEdge(LayoutEdge layoutEdge) {
            this.layoutEdge = layoutEdge;
        }

        @Override
        public void update(LGraphObject go) {
        }

        LayoutEdge getLayoutEdge() {
            return this.layoutEdge;
        }
    }
}

