/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.bioLayout;

import csapps.layout.algorithms.bioLayout.BioLayoutAlgorithmTask;
import csapps.layout.algorithms.bioLayout.BioLayoutFRContext;
import java.util.ArrayList;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.layout.LayoutPoint;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class BioLayoutFRAlgorithmTask
extends BioLayoutAlgorithmTask {
    private double attraction_constant;
    private double repulsion_constant;
    private double gravity_constant;
    private double maxDistance;
    private double maxVelocity_divisor = 25.0;
    private double maxVelocity;
    private ArrayList<Double> displacementArray;
    private LayoutPartition partition;
    private double width;
    private double height;
    private double depth;
    private BioLayoutFRContext context;

    public BioLayoutFRAlgorithmTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, BioLayoutFRContext context, boolean supportWeights, String attrName, UndoSupport undo) {
        super(displayName, networkView, nodesToLayOut, context.singlePartition, attrName, undo);
        this.context = context;
        this.supportWeights = supportWeights;
        this.edgeWeighter = context.edgeWeighter;
        this.edgeWeighter.setWeightAttribute(this.layoutAttribute);
        this.displacementArray = new ArrayList(100);
    }

    public String getName() {
        return "fruchterman-rheingold";
    }

    public String toString() {
        if (this.supportWeights) {
            return "Edge-weighted Force directed (BioLayout)";
        }
        return "Force directed (BioLayout)";
    }

    @Override
    public void layoutPartition(LayoutPartition partition) {
        this.partition = partition;
        LayoutPoint initialLocation = null;
        this.calculateSize();
        double temp = this.context.temperature == 0.0 ? Math.sqrt(this.width * this.height) / 2.0 : Math.sqrt(this.width * this.height) * this.context.temperature / 100.0;
        initialLocation = partition.getAverageLocation();
        if (this.context.randomize) {
            partition.randomizeLocations(this.context.layout3D);
        }
        this.calculateForces();
        partition.calculateEdgeWeights();
        this.taskMonitor.setStatusMessage("Calculating new node positions...");
        this.setTaskStatus(2);
        for (int i = 0; i < this.context.nIterations; ++i) {
            block22: {
                block21: {
                    if (this.cancelled) {
                        return;
                    }
                    this.taskMonitor.setStatusMessage("Calculating new node positions: Iteration " + (i + 1) + " of " + this.context.nIterations + "...");
                    temp = this.doOneIteration(i, temp);
                    if (temp == 0.0) {
                        this.setTaskStatus(92);
                        break;
                    }
                    if (debug) break block21;
                    if (BioLayoutFRContext.update_iterations <= 0) break block22;
                    if (i % BioLayoutFRContext.update_iterations != 0) break block22;
                }
                if (i > 0) {
                    for (LayoutNode v : partition.getNodeList()) {
                        if (this.cancelled) {
                            return;
                        }
                        if (this.context.layout3D) {
                            v.moveToLocation3D();
                            continue;
                        }
                        v.moveToLocation();
                    }
                }
                if (debug) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.setTaskStatus(Math.round(2.0f + (float)(i + 1) / (float)this.context.nIterations * 90.0f));
        }
        this.taskMonitor.setStatusMessage("Updating display...");
        partition.resetNodes();
        for (LayoutNode v : partition.getNodeList()) {
            if (this.cancelled) {
                return;
            }
            if (this.context.layout3D) {
                partition.moveNodeToLocation3D(v);
                continue;
            }
            partition.moveNodeToLocation(v);
        }
        this.setTaskStatus(96);
        double xDelta = 0.0;
        double yDelta = 0.0;
        double zDelta = 0.0;
        LayoutPoint finalLocation = partition.getAverageLocation();
        xDelta = finalLocation.getX() - initialLocation.getX();
        yDelta = finalLocation.getY() - initialLocation.getY();
        if (this.context.layout3D) {
            zDelta = finalLocation.getZ() - initialLocation.getZ();
        }
        partition.resetNodes();
        for (LayoutNode v : partition.getNodeList()) {
            if (this.cancelled) {
                return;
            }
            if (v.isLocked()) continue;
            v.decrement(xDelta, yDelta, zDelta);
            if (this.context.layout3D) {
                partition.moveNodeToLocation3D(v);
                continue;
            }
            partition.moveNodeToLocation(v);
        }
    }

    public double doOneIteration(int iteration, double temp) {
        double xAverage = 0.0;
        double yAverage = 0.0;
        double zAverage = 0.0;
        for (LayoutNode v : this.partition.getNodeList()) {
            if (this.cancelled) {
                return 0.0;
            }
            if (v.isLocked()) continue;
            xAverage += v.getX() / (double)this.partition.nodeCount();
            yAverage += v.getY() / (double)this.partition.nodeCount();
            zAverage += v.getZ() / (double)this.partition.nodeCount();
        }
        for (LayoutNode v : this.partition.getNodeList()) {
            if (this.cancelled) {
                return 0.0;
            }
            if (v.isLocked()) continue;
            this.calculateRepulsion(v);
            if (this.gravity_constant == 0.0) continue;
            this.calculateGravity(v, xAverage, yAverage, zAverage);
        }
        for (LayoutEdge e : this.partition.getEdgeList()) {
            if (this.cancelled) {
                return 0.0;
            }
            this.calculateAttraction(e);
        }
        double xDispTotal = 0.0;
        double yDispTotal = 0.0;
        for (LayoutNode v : this.partition.getNodeList()) {
            if (this.cancelled) {
                return 0.0;
            }
            if (v.isLocked()) continue;
            this.calculatePosition(v, temp);
            xDispTotal += Math.abs(v.getXDisp());
            yDispTotal += Math.abs(v.getYDisp());
        }
        if (this.complete(xDispTotal, yDispTotal)) {
            return 0.0;
        }
        return this.cool(temp, iteration);
    }

    private boolean complete(double xDisp, double yDisp) {
        Double disp = new Double(Math.sqrt(xDisp * xDisp + yDisp * yDisp));
        this.displacementArray.add(disp);
        Object[] dispArray = this.displacementArray.toArray();
        if (dispArray.length < 99) {
            return false;
        }
        double averageSlope = 0.0;
        double averageValue = (Double)dispArray[0] / (double)dispArray.length;
        for (int i = 1; i < dispArray.length; ++i) {
            averageSlope += ((Double)dispArray[i] - (Double)dispArray[i - 1]) / (double)dispArray.length;
            averageValue += (Double)dispArray[i] / (double)dispArray.length;
        }
        if (Math.abs(averageSlope) < 0.001) {
            return true;
        }
        if (this.displacementArray.size() > 99) {
            this.displacementArray.remove(0);
        }
        return false;
    }

    private void calculateRepulsion(LayoutNode v) {
        v.setDisp(0.0, 0.0, 0.0);
        double radius = v.getWidth() / 2.0;
        for (LayoutNode u : this.partition.getNodeList()) {
            double zVector;
            double deltaDistance;
            double dx = v.getX() - u.getX();
            double dy = v.getY() - u.getY();
            double dz = v.getZ() - u.getZ();
            if (v == u) continue;
            double d = deltaDistance = this.context.layout3D ? v.distance3D(u) : v.distance(u);
            if (deltaDistance == 0.0) {
                deltaDistance = this.EPSILON;
            }
            double fr = this.forceR(this.repulsion_constant, deltaDistance);
            if (deltaDistance < radius + u.getWidth() / 2.0) {
                fr += this.context.conflict_avoidance;
            }
            if (Double.isNaN(fr)) {
                fr = 500.0;
            }
            double xVector = dx * fr / deltaDistance;
            double yVector = dy * fr / deltaDistance;
            double d2 = zVector = this.context.layout3D ? dz * fr / deltaDistance : 0.0;
            if (v.isLocked()) {
                return;
            }
            if (u.isLocked()) {
                v.incrementDisp(xVector * 2.0, yVector * 2.0, zVector * 2.0);
                continue;
            }
            v.incrementDisp(xVector, yVector, zVector);
        }
    }

    private void calculateAttraction(LayoutEdge e) {
        double zVector;
        LayoutNode v = e.getSource();
        LayoutNode u = e.getTarget();
        double dx = v.getX() - u.getX();
        double dy = v.getY() - u.getY();
        double dz = v.getZ() - u.getZ();
        double deltaDistance = this.context.layout3D ? v.distance3D(u) : v.distance(u);
        double fa = this.forceA(this.attraction_constant, deltaDistance, e.getWeight());
        if (Double.isNaN(fa)) {
            fa = this.EPSILON;
        }
        double xVector = dx * fa;
        double yVector = dy * fa;
        double d = zVector = this.context.layout3D ? dz * fa : 0.0;
        if (u.isLocked() && v.isLocked()) {
            return;
        }
        if (u.isLocked()) {
            v.decrementDisp(xVector * 2.0, yVector * 2.0, zVector * 2.0);
        } else if (v.isLocked()) {
            u.incrementDisp(xVector * 2.0, yVector * 2.0, zVector * 2.0);
        } else {
            v.decrementDisp(xVector, yVector, zVector);
            u.incrementDisp(xVector, yVector, zVector);
        }
    }

    private void calculateGravity(LayoutNode v, double xAverage, double yAverage, double zAverage) {
        double zVector;
        double distance;
        double dx = v.getX() - xAverage;
        double dy = v.getY() - yAverage;
        double dz = v.getZ() - zAverage;
        double d = distance = this.context.layout3D ? Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0)) : Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        if (distance == 0.0) {
            distance = this.EPSILON;
        }
        double phi = (1 + v.getDegree()) / 3;
        double force = this.gravity_constant * distance * phi;
        double xVector = dx * force;
        double yVector = dy * force;
        double d2 = zVector = this.context.layout3D ? dz * force : 0.0;
        if (v.isLocked()) {
            return;
        }
        v.decrementDisp(xVector, yVector, zVector);
    }

    private void calculatePosition(LayoutNode v, double temp) {
        double newYDisp;
        double deltaDistance = this.context.layout3D ? v.distance3D(v.getXDisp(), v.getYDisp(), v.getZDisp()) : v.distance(v.getXDisp(), v.getYDisp());
        double newXDisp = v.getXDisp() / deltaDistance * Math.min(deltaDistance, temp);
        if (Double.isNaN(newXDisp)) {
            newXDisp = 0.0;
        }
        if (Double.isNaN(newYDisp = v.getYDisp() / deltaDistance * Math.min(deltaDistance, temp))) {
            newYDisp = 0.0;
        }
        double newZDisp = 0.0;
        if (this.context.layout3D) {
            newZDisp = v.getZDisp() / deltaDistance * Math.min(deltaDistance, temp);
        }
        v.increment(newXDisp, newYDisp, newZDisp);
    }

    private double cool(double temp, int iteration) {
        return temp *= 1.0 - (double)iteration / (double)this.context.nIterations;
    }

    private void calculateSize() {
        double node_area;
        double spreadFactor = this.context.spread_factor;
        double averageWidth = this.partition.getWidth() / (double)this.partition.nodeCount();
        double averageHeight = this.partition.getHeight() / (double)this.partition.nodeCount();
        double current_area = (this.partition.getMaxX() - this.partition.getMinX()) * (this.partition.getMaxY() - this.partition.getMinY());
        if (current_area > (node_area = this.partition.getWidth() * this.partition.getHeight())) {
            this.width = (this.partition.getMaxX() - this.partition.getMinX()) * spreadFactor;
            this.height = (this.partition.getMaxY() - this.partition.getMinY()) * spreadFactor;
            this.height = this.width = Math.max(this.width, this.height);
        } else {
            this.width = Math.sqrt(node_area) * spreadFactor;
            this.height = Math.sqrt(node_area) * spreadFactor;
        }
        this.maxVelocity = Math.max(Math.max(averageWidth * 2.0, averageHeight * 2.0), Math.max(this.width, this.height) / this.maxVelocity_divisor);
        this.maxDistance = Math.max(Math.max(averageWidth * 10.0, averageHeight * 10.0), Math.min(this.width, this.height) * this.context.max_distance_factor / 100.0);
        this.depth = this.width;
    }

    private void calculateForces() {
        double force = this.context.layout3D ? Math.pow(this.height * this.width * this.depth / (double)this.partition.nodeCount(), 0.3333333333333333) : Math.sqrt(this.height * this.width / (double)this.partition.nodeCount());
        this.attraction_constant = force * this.context.attraction_multiplier;
        this.repulsion_constant = force * this.context.repulsion_multiplier;
        this.gravity_constant = this.context.gravity_multiplier;
    }

    private double forceR(double k, double distance) {
        if (distance > this.maxDistance) {
            return 0.0;
        }
        return k * k / distance;
    }

    private double forceA(double k, double distance, double weight) {
        return distance * distance / k * weight;
    }
}

