/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.VisualProperty;

class NumberValueDialog
extends JDialog {
    private final String NO_ERROR_MSG = "<html>&nbsp;</html>";
    private final String ERROR_MSG = "<html><font color=\"red\">Invalid number!</font></html>";
    private Number value = null;

    public <S extends Number> NumberValueDialog(Component parent, VisualProperty<S> vizProp, S initialValue) {
        super(JOptionPane.getFrameForComponent(parent), vizProp.getDisplayName(), true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NumberValueDialog.this.value = null;
                NumberValueDialog.this.dispose();
            }
        });
        final ContinuousRange range = (ContinuousRange)vizProp.getRange();
        JLabel titleLabel = new JLabel(String.format("Enter %s:", NumberValueDialog.readableRange(range)));
        final JLabel errorLabel = new JLabel("<html>&nbsp;</html>");
        errorLabel.setHorizontalAlignment(0);
        final JTextField field = new JTextField(6);
        field.setHorizontalAlignment(4);
        if (initialValue != null) {
            field.setText(initialValue.toString());
        }
        JButton okBtn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberValueDialog.this.onOkAction(range, errorLabel, field);
            }
        });
        JButton cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberValueDialog.this.value = null;
                NumberValueDialog.this.dispose();
            }
        });
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberValueDialog.this.onOkAction(range, errorLabel, field);
            }
        });
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.clear();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.clear();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.clear();
            }

            void clear() {
                errorLabel.setText("<html>&nbsp;</html>");
                NumberValueDialog.this.pack();
            }
        });
        JPanel btnPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okBtn, (JButton)cancelBtn);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)okBtn.getAction(), (Action)cancelBtn.getAction());
        this.getRootPane().setDefaultButton(okBtn);
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        int HGAP = 20;
        int VGAP = 10;
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap(20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addComponent(titleLabel, -1, -1, Short.MAX_VALUE).addComponent(field)).addComponent(errorLabel).addComponent(btnPanel)).addContainerGap(20, 20));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap(10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(titleLabel).addComponent(field)).addComponent(errorLabel).addComponent(btnPanel).addContainerGap(10, 10));
        this.setContentPane(contentPane);
        this.setLocationRelativeTo(parent);
        this.pack();
        this.setVisible(true);
    }

    public Number getValue() {
        return this.value;
    }

    private <S extends Number> void onOkAction(ContinuousRange<S> range, JLabel errorLabel, JTextField field) {
        this.value = NumberValueDialog.parseNumber(field.getText(), range.getType());
        if (this.value != null && !range.inRange((Object)((Number)range.getType().cast(this.value)))) {
            this.value = null;
        }
        if (this.value == null) {
            errorLabel.setText("<html><font color=\"red\">Invalid number!</font></html>");
            this.pack();
        } else {
            this.dispose();
        }
    }

    private static boolean isUnbounded(Number value, Class<?> type) {
        if (type.equals(Integer.class)) {
            return value.equals(Integer.MIN_VALUE) || value.equals(Integer.MAX_VALUE);
        }
        if (type.equals(Long.class)) {
            return value.equals(Long.MIN_VALUE) || value.equals(Long.MAX_VALUE);
        }
        if (type.equals(Float.class)) {
            return ((Float)value).isInfinite();
        }
        if (type.equals(Double.class)) {
            return ((Double)value).isInfinite();
        }
        throw new IllegalArgumentException("Unknown number type: " + type);
    }

    private static <S extends Number> String readableRange(ContinuousRange<S> range) {
        boolean rightBounded;
        Class type = range.getType();
        boolean isWholeNumber = type.equals(Integer.class) || type.equals(Long.class);
        String numStr = String.format("a %snumber", isWholeNumber ? "whole " : "");
        Number left = (Number)range.getMin();
        Number right = (Number)range.getMax();
        boolean includeLeft = range.includeMin();
        boolean includeRight = range.includeMax();
        boolean leftBounded = !NumberValueDialog.isUnbounded(left, range.getType());
        boolean bl = rightBounded = !NumberValueDialog.isUnbounded(right, range.getType());
        if (!leftBounded && !rightBounded) {
            return numStr;
        }
        if (leftBounded && !rightBounded) {
            if (includeLeft) {
                return String.format("%s that is %s or greater", numStr, left);
            }
            return String.format("%s greater than %s", numStr, left);
        }
        if (!leftBounded && rightBounded) {
            if (includeRight) {
                return String.format("%s that is %s or less", numStr, right);
            }
            return String.format("%s that is less than %s", numStr, right);
        }
        if (includeLeft && includeRight) {
            return String.format("%s between %s and %s", numStr, left, right);
        }
        return String.format("%s that is greater than%s %s and less than%s %s", numStr, includeLeft ? " or equal to" : "", left, includeRight ? " or equal to" : "", right);
    }

    private static Number parseNumber(String s, Class<?> type) {
        try {
            Double d = new Double(s);
            if (type.equals(Integer.class)) {
                return d.intValue();
            }
            if (type.equals(Long.class)) {
                return d.longValue();
            }
            if (type.equals(Float.class)) {
                return Float.valueOf(d.floatValue());
            }
            if (type.equals(Double.class)) {
                return d;
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

