/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CyComboBoxPropertyEditor
extends AbstractPropertyEditor {
    private Object oldValue;
    private Icon[] icons;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public CyComboBoxPropertyEditor() {
        JComboBox<Object> combo;
        this.editor = combo = new JComboBox<Object>();
        combo.setRenderer(new Renderer());
        combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                try {
                    if (combo.getSelectedItem() == null && combo.getItemCount() != 0) {
                        combo.setSelectedIndex(0);
                        CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getItemAt(0));
                    } else {
                        CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CyComboBoxPropertyEditor.this.oldValue = combo.getSelectedItem();
            }
        });
        combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
                }
            }
        });
        combo.setSelectedIndex(-1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
            if (l != listener) continue;
            return;
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        this.pcs.firePropertyChange("value", oldValue, newValue);
    }

    public Object getValue() {
        Object selected = ((JComboBox)this.editor).getSelectedItem();
        if (selected instanceof Value) {
            return ((Value)selected).value;
        }
        return selected;
    }

    public void setValue(Object value) {
        JComboBox combo = (JComboBox)this.editor;
        Object current = null;
        int index = -1;
        int c = combo.getModel().getSize();
        for (int i = 0; i < c; ++i) {
            current = combo.getModel().getElementAt(i);
            if (value != current && (current == null || !current.equals(value))) continue;
            index = i;
            break;
        }
        ((JComboBox)this.editor).setSelectedIndex(index);
    }

    public void setAvailableValues(Object[] values) {
        ((JComboBox)this.editor).setModel(new DefaultComboBoxModel<Object>(values));
        if (((JComboBox)this.editor).getItemCount() != 0) {
            ((JComboBox)this.editor).setSelectedIndex(0);
        }
    }

    public Set<Object> getAvailableValues() {
        int itemCount = ((JComboBox)this.editor).getModel().getSize();
        HashSet<Object> items = new HashSet<Object>();
        for (int i = 0; i < itemCount; ++i) {
            items.add(((JComboBox)this.editor).getModel().getElementAt(i));
        }
        return items;
    }

    public void setAvailableIcons(Icon[] icons) {
        this.icons = icons;
    }

    protected class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1213748837110925L;

        protected Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = value instanceof Value ? ((Value)value).visualValue : value;
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel lbl = index >= 0 && component instanceof JLabel ? (JLabel)component : new JLabel();
            if (CyComboBoxPropertyEditor.this.icons != null && index >= 0 && component instanceof JLabel) {
                lbl.setIcon(CyComboBoxPropertyEditor.this.icons[index]);
            }
            return lbl;
        }
    }

    public static final class Value {
        Object value;
        Object visualValue;

        public Value(Object value, Object visualValue) {
            this.value = value;
            this.visualValue = visualValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.value == o || this.value != null && this.value.equals(o);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }
}

