/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;

public final class TriangleThumbRenderer
extends JComponent
implements ThumbRenderer {
    private static final long serialVersionUID = 1202339877445372L;
    private final Color FOCUS_COLOR = UIManager.getColor("Focus.color");
    private final Color SELECTION_COLOR = UIManager.getColor("Table.focusCellBackground");
    private final Color DEFAULT_COLOR = UIManager.getColor("Label.foreground");
    private final Color BACKGROUND_COLOR = UIManager.getColor("Table.background");
    private static final int STROKE_WIDTH = 1;
    private boolean selected;
    private int selectedIndex;
    private int currentIndex;

    public TriangleThumbRenderer() {
        this.setBackground(this.BACKGROUND_COLOR);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color color = g.getColor();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.selected || this.selectedIndex == this.currentIndex) {
            g2d.setColor(this.SELECTION_COLOR);
        } else {
            g2d.setColor(this.DEFAULT_COLOR);
        }
        Polygon p1 = new Polygon();
        p1.addPoint(0, 0);
        p1.addPoint(w, 0);
        p1.addPoint(w / 2, h);
        g2d.fillPolygon(p1);
        Polygon p2 = new Polygon();
        p2.addPoint(2, 1);
        p2.addPoint(w - 2, 1);
        p2.addPoint(w / 2, h - 2);
        g2d.setColor(color);
        g2d.fillPolygon(p2);
        g2d.dispose();
    }

    public JComponent getThumbRendererComponent(JXMultiThumbSlider slider, int index, boolean selected) {
        this.selected = selected;
        this.selectedIndex = slider.getSelectedIndex();
        this.currentIndex = index;
        Object currentValue = slider.getModel().getThumbAt(index).getObject();
        if (currentValue.getClass() == Color.class) {
            this.setForeground((Color)currentValue);
        } else if (selected || this.selectedIndex == this.currentIndex) {
            this.setForeground(this.FOCUS_COLOR);
        } else {
            this.setForeground(this.DEFAULT_COLOR);
        }
        return this;
    }
}

