/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.editor.ValueEditor;
import org.cytoscape.view.vizmap.gui.internal.util.NumberConverter;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.CyGradientTrackRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.TriangleThumbRenderer;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class GradientEditorPanel<T extends Number>
extends ContinuousMappingEditorPanel<T, Color> {
    private static final long serialVersionUID = 1202339877433771L;
    private Color DEF_BELOW_LOWER_COLOR = Color.decode("#2166ac");
    private Color DEF_LOWER_COLOR = Color.decode("#4393c3");
    private Color DEF_MID_COLOR = Color.decode("#f7f7f7");
    private Color DEF_UPPER_COLOR = Color.decode("#d6604d");
    private Color DEF_ABOVE_UPPER_COLOR = Color.decode("#b2182b");
    protected final ValueEditor<Paint> colorEditor;
    protected final CyColorPaletteChooserFactory paletteChooserFactory;

    public GradientEditorPanel(VisualStyle style, ContinuousMapping<T, Color> mapping, CyTable attr, EditorManager editorManager, ValueEditor<Paint> colorEditor, ServicesUtil servicesUtil) {
        super(style, mapping, attr, editorManager, servicesUtil);
        this.colorEditor = colorEditor;
        this.paletteChooserFactory = servicesUtil.get(CyColorPaletteChooserFactory.class);
        this.getIconPanel().setVisible(false);
        this.getPaletteButton().addActionListener(evt -> {
            Object[] options;
            int n;
            CyColorPaletteChooser chooser = this.paletteChooserFactory.getColorPaletteChooser(this.paletteType, false);
            Palette newPalette = chooser.showDialog((Component)this, "Set Palette", this.currentPalette, 9);
            if (newPalette == null) {
                return;
            }
            Color[] colors = newPalette.getColors();
            if (colors.length < 9) {
                colors = newPalette.getColors(9);
            }
            this.DEF_BELOW_LOWER_COLOR = colors[colors.length - 1];
            this.DEF_LOWER_COLOR = colors[colors.length - 2];
            this.DEF_MID_COLOR = colors[(colors.length - 1) / 2];
            this.DEF_UPPER_COLOR = colors[1];
            this.DEF_ABOVE_UPPER_COLOR = colors[0];
            if (!this.userEdited) {
                this.setCurrentPalette(newPalette);
                this.savePalette(this.currentPalette);
                this.createSimpleGradient();
            } else if (this.userEdited && (n = JOptionPane.showOptionDialog(null, "This will reset your current settings.\nAre you sure you want to continue?", "Warning", -1, 2, null, options = new Object[]{"Yes", "No"}, options[1])) == 0) {
                this.setCurrentPalette(newPalette);
                this.savePalette(this.currentPalette);
                this.createSimpleGradient();
            }
        });
        if (this.currentPalette != null) {
            Color[] colors = this.currentPalette.getColors();
            if (colors.length < 9) {
                colors = this.currentPalette.getColors(9);
            }
            this.DEF_BELOW_LOWER_COLOR = colors[colors.length - 1];
            this.DEF_LOWER_COLOR = colors[colors.length - 2];
            this.DEF_MID_COLOR = colors[(colors.length - 1) / 2];
            this.DEF_UPPER_COLOR = colors[1];
            this.DEF_ABOVE_UPPER_COLOR = colors[0];
        } else if (this.paletteType == BrewerType.SEQUENTIAL) {
            this.DEF_BELOW_LOWER_COLOR = Color.decode("#fde725");
            this.DEF_LOWER_COLOR = Color.decode("#fbe723");
            this.DEF_MID_COLOR = Color.decode("#21918c");
            this.DEF_UPPER_COLOR = Color.decode("#440256");
            this.DEF_ABOVE_UPPER_COLOR = Color.decode("#440154");
        }
        this.initSlider();
        this.getSlider().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Color oldColor;
                Color newColor;
                JComponent selectedThumb = GradientEditorPanel.this.getSlider().getSelectedThumb();
                if (selectedThumb != null && e.getClickCount() == 2 && (newColor = GradientEditorPanel.this.changeThumbColor(oldColor = (Color)GradientEditorPanel.this.getSlider().getModel().getThumbAt(GradientEditorPanel.this.getSlider().getSelectedIndex()).getObject())) != null) {
                    GradientEditorPanel.this.setColor(newColor);
                }
            }
        });
        if (mapping != null && mapping.getPointCount() == 0) {
            this.addButtonActionPerformed(null);
        }
        this.getColorButton().addActionListener(evt -> {
            int idx = this.getSlider().getSelectedIndex();
            if (idx == -1 || idx >= this.getSlider().getModel().getThumbCount()) {
                return;
            }
            Color oldColor = (Color)this.getSlider().getModel().getThumbAt(idx).getObject();
            Color newColor = this.changeThumbColor(oldColor);
            if (newColor != null) {
                this.setColor(newColor);
                this.setButtonColor(newColor);
            }
        });
    }

    public ImageIcon getLegend(int width, int height) {
        CyGradientTrackRenderer rend = (CyGradientTrackRenderer)this.getSlider().getTrackRenderer();
        rend.getRendererComponent(this.getSlider());
        return rend.getLegend(width, height);
    }

    protected Color changeThumbColor(Color oldColor) {
        if (this.currentPalette != null) {
            PaletteType type = this.currentPalette.getType();
            CyColorPaletteChooser chooser = this.paletteChooserFactory.getColorPaletteChooser(type, false);
            Color newColor = chooser.showDialog((Component)this, "Set thumb color", this.currentPalette, oldColor, 9);
            Palette newPalette = chooser.getSelectedPalette();
            if (newPalette != null) {
                this.currentPalette = newPalette;
            }
            return newColor;
        }
        return (Color)this.colorEditor.showEditor(null, oldColor);
    }

    @Override
    protected void addButtonActionPerformed(ActionEvent evt) {
        if (this.mapping.getPointCount() == 0) {
            this.createSimpleGradient();
        } else {
            this.updateGradient();
        }
        this.update();
    }

    private void updateGradient() {
        double maxValue = tracer.getMax(this.type);
        this.getSlider().getModel().addThumb(70.0f, (Object)Color.WHITE);
        ContinuousMappingPoint previousPoint = this.mapping.getPoint(this.mapping.getPointCount() - 1);
        BoundaryRangeValues previousRange = previousPoint.getRange();
        Color lesserVal = (Color)((Thumb)this.getSlider().getModel().getSortedThumbs().get(this.getSlider().getModel().getThumbCount() - 1)).getObject();
        Color equalVal = Color.WHITE;
        Color greaterVal = (Color)previousRange.greaterValue;
        BoundaryRangeValues lowerRange = new BoundaryRangeValues((Object)lesserVal, (Object)equalVal, (Object)greaterVal);
        Number value = (Number)NumberConverter.convert(this.columnType, maxValue);
        this.mapping.addPoint((Object)value, lowerRange);
        this.updateMap();
        this.userEdited = true;
    }

    private void createSimpleGradient() {
        double minValue = tracer.getMin(this.type);
        double maxValue = tracer.getMax(this.type);
        for (int index = this.mapping.getPointCount() - 1; index >= 0; --index) {
            this.mapping.removePoint(index);
        }
        List sorted = this.getSlider().getModel().getSortedThumbs();
        for (Thumb t : sorted) {
            this.getSlider().getModel().removeThumb(this.getSlider().getModel().getThumbIndex(t));
        }
        if (minValue < 0.0 && maxValue > 0.0) {
            if (Math.abs(minValue) > maxValue) {
                maxValue = Math.abs(minValue);
            } else {
                minValue = maxValue * -1.0;
            }
            this.getSlider().getModel().addThumb(0.0f, (Object)this.DEF_LOWER_COLOR);
            this.getSlider().getModel().addThumb(50.0f, (Object)this.DEF_MID_COLOR);
            this.getSlider().getModel().addThumb(100.0f, (Object)this.DEF_UPPER_COLOR);
            lowerRange = new BoundaryRangeValues((Object)this.DEF_BELOW_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR);
            midRange = new BoundaryRangeValues((Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR);
            BoundaryRangeValues upperRange = new BoundaryRangeValues((Object)this.DEF_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR, (Object)this.DEF_ABOVE_UPPER_COLOR);
            this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, minValue)), lowerRange);
            this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, 0.0)), midRange);
            this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, maxValue)), upperRange);
            this.initSlider();
        } else if (minValue >= 0.0) {
            if (this.currentPalette != null && this.currentPalette.getType() == BrewerType.SEQUENTIAL) {
                this.getSlider().getModel().addThumb(0.0f, (Object)this.DEF_UPPER_COLOR);
                this.getSlider().getModel().addThumb(50.0f, (Object)this.DEF_MID_COLOR);
                this.getSlider().getModel().addThumb(100.0f, (Object)this.DEF_LOWER_COLOR);
                lowerRange = new BoundaryRangeValues((Object)this.DEF_ABOVE_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR);
                midRange = new BoundaryRangeValues((Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR);
                BoundaryRangeValues upperRange = new BoundaryRangeValues((Object)this.DEF_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR, (Object)this.DEF_BELOW_LOWER_COLOR);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, minValue)), lowerRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, (double)((float)(maxValue - minValue) / 2.0f) + minValue)), midRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, maxValue)), upperRange);
            } else {
                this.getSlider().getModel().addThumb(0.0f, (Object)this.DEF_LOWER_COLOR);
                this.getSlider().getModel().addThumb(50.0f, (Object)this.DEF_MID_COLOR);
                this.getSlider().getModel().addThumb(100.0f, (Object)this.DEF_UPPER_COLOR);
                lowerRange = new BoundaryRangeValues((Object)this.DEF_BELOW_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR);
                midRange = new BoundaryRangeValues((Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR);
                BoundaryRangeValues upperRange = new BoundaryRangeValues((Object)this.DEF_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR, (Object)this.DEF_ABOVE_UPPER_COLOR);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, minValue)), lowerRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, (double)((float)(maxValue - minValue) / 2.0f) + minValue)), midRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, maxValue)), upperRange);
            }
            this.initSlider();
        } else if (maxValue <= 0.0) {
            if (this.currentPalette != null && this.currentPalette.getType() == BrewerType.SEQUENTIAL) {
                this.getSlider().getModel().addThumb(0.0f, (Object)this.DEF_LOWER_COLOR);
                this.getSlider().getModel().addThumb(50.0f, (Object)this.DEF_MID_COLOR);
                this.getSlider().getModel().addThumb(100.0f, (Object)this.DEF_UPPER_COLOR);
                lowerRange = new BoundaryRangeValues((Object)this.DEF_BELOW_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR);
                midRange = new BoundaryRangeValues((Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR);
                BoundaryRangeValues upperRange = new BoundaryRangeValues((Object)this.DEF_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR, (Object)this.DEF_ABOVE_UPPER_COLOR);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, minValue)), lowerRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, (double)((float)(maxValue - minValue) / 2.0f) + minValue)), midRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, maxValue)), upperRange);
            } else {
                this.getSlider().getModel().addThumb(0.0f, (Object)this.DEF_UPPER_COLOR);
                this.getSlider().getModel().addThumb(50.0f, (Object)this.DEF_MID_COLOR);
                this.getSlider().getModel().addThumb(100.0f, (Object)this.DEF_LOWER_COLOR);
                lowerRange = new BoundaryRangeValues((Object)this.DEF_ABOVE_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR, (Object)this.DEF_UPPER_COLOR);
                midRange = new BoundaryRangeValues((Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR, (Object)this.DEF_MID_COLOR);
                BoundaryRangeValues upperRange = new BoundaryRangeValues((Object)this.DEF_LOWER_COLOR, (Object)this.DEF_LOWER_COLOR, (Object)this.DEF_BELOW_LOWER_COLOR);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, minValue)), lowerRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, (double)((float)(maxValue - minValue) / 2.0f) + minValue)), midRange);
                this.mapping.addPoint((Object)((Number)NumberConverter.convert(this.columnType, maxValue)), upperRange);
            }
            this.initSlider();
        }
        this.userEdited = false;
    }

    @Override
    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.getSlider().getSelectedIndex();
        if (selectedIndex >= 0) {
            this.getSlider().getModel().removeThumb(selectedIndex);
            this.mapping.removePoint(selectedIndex);
            this.updateMap();
            CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
            appMgr.getCurrentNetworkView().updateView();
            this.update();
        }
    }

    private void setColor(Color newColor) {
        this.getSlider().getModel().getThumbAt(this.getSlider().getSelectedIndex()).setObject((Object)newColor);
        int selected = this.getSelectedPoint(this.getSlider().getSelectedIndex());
        Color lesserVal = (Color)this.mapping.getPoint((int)selected).getRange().lesserValue;
        Color equalVal = newColor;
        Color greaterVal = (Color)this.mapping.getPoint((int)selected).getRange().greaterValue;
        int numPoints = this.mapping.getAllPoints().size();
        if (numPoints > 1) {
            if (selected == 0) {
                greaterVal = newColor;
            } else if (selected == numPoints - 1) {
                lesserVal = newColor;
            } else {
                lesserVal = newColor;
                greaterVal = newColor;
            }
        }
        BoundaryRangeValues brv = new BoundaryRangeValues((Object)lesserVal, (Object)equalVal, (Object)greaterVal);
        this.mapping.getPoint(selected).setRange(brv);
        if (numPoints > 1) {
            this.getSlider().repaint();
        }
        this.userEdited = true;
    }

    protected void initSlider() {
        this.getSlider().updateUI();
        double actualRange = tracer.getRange(this.type);
        double minValue = tracer.getMin(this.type);
        List sorted = this.getSlider().getModel().getSortedThumbs();
        for (Object t : sorted) {
            this.getSlider().getModel().removeThumb(this.getSlider().getModel().getThumbIndex((Thumb)t));
        }
        ArrayList points = new ArrayList(this.mapping.getAllPoints());
        points.sort((p1, p2) -> Double.compare(((Number)p1.getValue()).doubleValue(), ((Number)p2.getValue()).doubleValue()));
        for (ContinuousMappingPoint point : points) {
            BoundaryRangeValues bound = point.getRange();
            this.getSlider().getModel().addThumb(((Number)((((Number)point.getValue()).doubleValue() - minValue) / actualRange)).floatValue() * 100.0f, (Object)((Color)bound.equalValue));
        }
        if (!points.isEmpty()) {
            this.below = ((ContinuousMappingPoint)points.get((int)0)).getRange().lesserValue;
            this.above = ((ContinuousMappingPoint)points.get((int)(points.size() - 1))).getRange().greaterValue;
        } else {
            this.below = Color.BLACK;
            this.above = Color.WHITE;
        }
        this.setSidePanelIconColor((Color)this.below, (Color)this.above);
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer();
        CyGradientTrackRenderer gRend = new CyGradientTrackRenderer((VisualProperty<Color>)this.type, (Color)this.below, (Color)this.above, this.mapping.getMappingColumnName(), tracer);
        this.getSlider().setThumbRenderer((ThumbRenderer)thumbRend);
        this.getSlider().setTrackRenderer((TrackRenderer)gRend);
        this.getSlider().setToolTipText("Double-click handles to edit boundary colors.");
    }

    void updateView() {
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        this.style.apply(appMgr.getCurrentNetworkView());
        appMgr.getCurrentNetworkView().updateView();
        this.getSlider().repaint();
    }

    @Override
    public ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        CyGradientTrackRenderer rend = (CyGradientTrackRenderer)this.getSlider().getTrackRenderer();
        rend.getRendererComponent(this.getSlider());
        return rend.drawIcon(iconWidth, iconHeight, detail);
    }

    @Override
    protected void cancelChanges() {
        this.initSlider();
    }
}

