/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.VizMapTrackRenderer;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

public class DiscreteTrackRenderer<K, V>
extends JComponent
implements VizMapTrackRenderer {
    private static final long serialVersionUID = 1213748837182053L;
    private static final Dimension MIN_SIZE = new Dimension(200, 100);
    private static final int ICON_SIZE = 32;
    private static final int THUMB_WIDTH = 12;
    private static final int V_PADDING = 20;
    private int trackHeight = 70;
    private int arrowBarYPosition = this.trackHeight + 50;
    private final String title;
    private V below;
    private V above;
    private VisualProperty<V> vp;
    private JXMultiThumbSlider<V> slider;
    private final EditorValueRangeTracer tracer;
    private final Map<V, Icon> iconMap;
    private final RenderingEngine<CyNetwork> engine;

    public DiscreteTrackRenderer(ContinuousMapping<K, V> mapping, V below, V above, EditorValueRangeTracer tracer, RenderingEngine<CyNetwork> engine) {
        if (mapping == null) {
            throw new NullPointerException("Mapping is null.");
        }
        if (tracer == null) {
            throw new NullPointerException("Tracer is null.");
        }
        if (engine == null) {
            throw new NullPointerException("Rendering engine is null.");
        }
        this.below = below;
        this.above = above;
        this.tracer = tracer;
        this.engine = engine;
        this.vp = mapping.getVisualProperty();
        Range rangeObject = this.vp.getRange();
        this.iconMap = new HashMap<V, Icon>();
        if (rangeObject.isDiscrete()) {
            Set values = ((DiscreteRange)rangeObject).values();
            for (Object value : values) {
                this.iconMap.put((Icon)value, engine.createIcon(this.vp, value, 32, 32));
            }
        }
        this.title = mapping.getMappingColumnName();
        this.setBackground(BACKGROUND_COLOR);
        this.setMinimumSize(MIN_SIZE);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        int iconLocY;
        int iconLocX;
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.trackHeight = this.slider.getHeight() - 100;
        this.arrowBarYPosition = this.trackHeight + 50;
        int trackWidth = this.slider.getWidth() - 12;
        g.translate(6, 12);
        double minValue = this.tracer.getMin(this.vp);
        double maxValue = this.tracer.getMax(this.vp);
        double valueRange = this.tracer.getRange(this.vp);
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        g.setStroke(STROKE1);
        g.setColor(BORDER_COLOR);
        g.drawLine(0, this.arrowBarYPosition, trackWidth, this.arrowBarYPosition);
        Polygon arrow = new Polygon();
        arrow.addPoint(trackWidth, this.arrowBarYPosition);
        arrow.addPoint(trackWidth - 20, this.arrowBarYPosition - 8);
        arrow.addPoint(trackWidth - 20, this.arrowBarYPosition);
        g.fill(arrow);
        g.setColor(LABEL_COLOR);
        g.drawLine(0, this.arrowBarYPosition, 15, this.arrowBarYPosition - 30);
        g.drawLine(15, this.arrowBarYPosition - 30, 25, this.arrowBarYPosition - 30);
        g.setFont(SMALL_FONT);
        g.drawString("Min=" + minValue, 28, this.arrowBarYPosition - 25);
        g.drawLine(trackWidth, this.arrowBarYPosition, trackWidth - 15, this.arrowBarYPosition + 30);
        g.drawLine(trackWidth - 15, this.arrowBarYPosition + 30, trackWidth - 25, this.arrowBarYPosition + 30);
        String maxStr = "Max=" + maxValue;
        int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
        g.drawString(maxStr, trackWidth - strWidth - 26, this.arrowBarYPosition + 35);
        g.setColor(LABEL_COLOR);
        strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
        g.drawString(this.title, trackWidth / 2 - strWidth / 2, this.arrowBarYPosition + 35);
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.drawRect(0, 5, trackWidth, this.trackHeight);
            return;
        }
        g.setStroke(STROKE1);
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 5, trackWidth, this.trackHeight);
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < stops.size(); ++i) {
            int newX = (int)((float)trackWidth * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 5.0);
            g.setColor(LABEL_COLOR);
            g.setStroke(STROKE1);
            g.drawLine(newX, 5, newX, this.trackHeight + 4);
            g.setColor(LABEL_COLOR);
            g.setFont(SMALL_FONT);
            Float curPositionValue = Float.valueOf(((Number)((double)(fractions[i] / 100.0f) * valueRange + minValue)).floatValue());
            String valueString = String.format("%.5f", curPositionValue);
            int flipLimit = 90;
            int borderVal = trackWidth - newX;
            if (i % 2 == 0 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX + 20, this.arrowBarYPosition - 15);
                g.drawLine(newX + 20, this.arrowBarYPosition - 15, newX + 30, this.arrowBarYPosition - 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX + 33, this.arrowBarYPosition - 11);
            } else if (i % 2 == 1 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX + 20, this.arrowBarYPosition + 15);
                g.drawLine(newX + 20, this.arrowBarYPosition + 15, newX + 30, this.arrowBarYPosition + 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX + 33, this.arrowBarYPosition + 19);
            } else if (i % 2 == 0 && flipLimit >= borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX - 20, this.arrowBarYPosition - 15);
                g.drawLine(newX - 20, this.arrowBarYPosition - 15, newX - 30, this.arrowBarYPosition - 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX - 90, this.arrowBarYPosition - 11);
            } else {
                g.drawLine(newX, this.arrowBarYPosition, newX - 20, this.arrowBarYPosition + 15);
                g.drawLine(newX - 20, this.arrowBarYPosition + 15, newX - 30, this.arrowBarYPosition + 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX - 90, this.arrowBarYPosition + 19);
            }
            g.setColor(LABEL_COLOR);
            g.fillOval(newX - 3, this.arrowBarYPosition - 3, 6, 6);
            iconLocX = (int)(((Point2D)p2).getX() - ((((Point2D)p2).getX() - ((Point2D)p1).getX()) / 2.0 + 16.0));
            iconLocY = (int)((double)(this.trackHeight / 2 - 16) + ((Point2D)p2).getY());
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY);
            }
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(trackWidth, 5.0);
        iconLocX = (int)(((Point2D)p2).getX() - ((((Point2D)p2).getX() - ((Point2D)p1).getX()) / 2.0 + 16.0));
        iconLocY = (int)((double)(this.trackHeight / 2 - 16) + ((Point2D)p2).getY());
        this.drawIcon(this.above, g, iconLocX, iconLocY);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        g.drawRect(0, 5, trackWidth, this.trackHeight);
        g.translate(-6, -12);
    }

    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        return this;
    }

    protected List<V> getRanges() {
        ArrayList range = new ArrayList();
        return range;
    }

    public String getToolTipForCurrentLocation(int x, int y) {
        int oldX = 0;
        List stops = this.slider.getModel().getSortedThumbs();
        int i = 1;
        for (Thumb thumb : stops) {
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + this.trackHeight) {
                return "This is region " + i;
            }
            ++i;
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + this.trackHeight) {
            return "Last Area: " + oldX + " - " + this.slider.getWidth() + " (x, y) = " + x + ", " + y;
        }
        return null;
    }

    protected int getRangeID(int x, int y) {
        int i;
        int oldX = 0;
        List stops = this.slider.getModel().getSortedThumbs();
        for (i = 0; i < stops.size(); ++i) {
            Thumb thumb = (Thumb)stops.get(i);
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + this.trackHeight) {
                return i;
            }
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + this.trackHeight) {
            return i;
        }
        return -1;
    }

    private void drawIcon(V key, Graphics2D g, int x, int y) {
        if (key == null) {
            return;
        }
        Icon icon = this.iconMap.get(key);
        if (icon == null) {
            icon = this.engine.createIcon(this.vp, key, 32, 32);
        }
        g.setColor(LABEL_COLOR);
        icon.paintIcon(this, g, x, y);
    }

    public ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight) {
        return this.createIcon(iconWidth, iconHeight, false);
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.createIcon(iconWidth, iconHeight, true);
    }

    private ImageIcon createIcon(int iconWidth, int iconHeight, boolean detail) {
        int iconLocY;
        int iconLocX;
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, iconWidth, iconHeight);
        double minValue = this.tracer.getMin(this.vp);
        double maxValue = this.tracer.getMax(this.vp);
        double valueRange = this.tracer.getRange(this.vp);
        int track_width = iconWidth;
        int trackHeight = iconHeight - 8;
        trackHeight = detail ? iconHeight - 30 : iconHeight - 8;
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(0, 0, track_width - 3, trackHeight);
            return new ImageIcon(bi);
        }
        int newX = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < stops.size(); ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 0.0);
            iconLocX = newX - ((newX - (int)((Point2D)p1).getX()) / 2 + 16);
            iconLocY = trackHeight / 2 - 16;
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY);
            }
            g.setColor(BORDER_COLOR);
            g.setStroke(STROKE1);
            g.drawLine(newX, 0, newX, trackHeight);
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 0.0);
        iconLocX = track_width - ((track_width - (int)((Point2D)p1).getX()) / 2 + 16);
        iconLocY = trackHeight / 2 - 16;
        this.drawIcon(this.above, g, iconLocX, iconLocY);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRect(0, 0, track_width - 3, trackHeight);
        g.setFont(ICON_FONT);
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g.setColor(LABEL_COLOR);
        if (detail) {
            int strWidth;
            String fNum = null;
            for (int j = 0; j < fractions.length; ++j) {
                fNum = String.format("%.2f", (double)(fractions[j] / 100.0f) * valueRange + minValue);
                strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fNum);
                g.drawString(fNum, fractions[j] / 100.0f * (float)iconWidth - (float)(strWidth / 2), (float)(iconHeight - 20));
            }
            g.drawString(minStr, 0, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g.setFont(TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
            g.setColor(LABEL_COLOR);
            g.drawString(this.title, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g.fillPolygon(p);
            g.drawLine(0, iconHeight - 9, iconWidth / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
        } else {
            g.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    public Double getSelectedThumbValue() {
        double minValue = this.tracer.getMin(this.vp);
        double valueRange = this.tracer.getRange(this.vp);
        float position = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).getPosition();
        return (double)(position / 100.0f) * valueRange + minValue;
    }
}

