/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.editor.ContinuousEditorType;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.internal.util.NumberConverter;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.VisualPropertyUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.BelowAndAbovePanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.MinMaxDialog;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.YValueLegendPanel;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContinuousMappingEditorPanel<K extends Number, V>
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Dimension SPINNER_SIZE = new Dimension(100, 25);
    protected static final String BELOW_VALUE_CHANGED = "BELOW_VALUE_CHANGED";
    protected static final String ABOVE_VALUE_CHANGED = "ABOVE_VALUE_CHANGED";
    private JLabel attrNameLabel;
    private JLabel handlePositionLabel;
    private JButton addButton;
    private JButton colorButton;
    private JButton deleteButton;
    private JButton minMaxButton;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel mainPanel;
    private JPanel editorPanel;
    private JPanel formPanel;
    private JPanel iconPanel;
    private JPanel palettesPanel;
    private Palette lastPalette;
    protected Palette currentPalette;
    protected PaletteType paletteType;
    private JButton paletteButton;
    private BelowAndAbovePanel abovePanel;
    private BelowAndAbovePanel belowPanel;
    private JXMultiThumbSlider<V> slider;
    private JSpinner valueSpinner;
    private JSpinner propertySpinner;
    private JLabel propertyLabel;
    private JComponent valueEditor;
    protected final ContinuousMapping<K, V> mapping;
    protected final VisualProperty<V> type;
    private final WeakReference<CyTable> dataTable;
    protected final EditorManager editorManager;
    private SpinnerNumberModel spinnerModel;
    protected V below;
    protected V above;
    protected boolean userEdited = false;
    protected Double lastSpinnerNumber;
    protected static EditorValueRangeTracer tracer;
    protected final ServicesUtil servicesUtil;
    protected final VisualStyle style;
    protected final Class<K> columnType;
    protected final Class<V> vpValueType;
    protected PaletteProviderManager paletteProviderMgr;
    private final ContinuousMapping<K, V> original;
    boolean commitChanges;

    public ContinuousMappingEditorPanel(VisualStyle style, ContinuousMapping<K, V> mapping, CyTable table, EditorManager editorManager, ServicesUtil servicesUtil) {
        Class attrType;
        if (style == null) {
            throw new IllegalArgumentException("'style' should not be null.");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("'mapping' should not be null.");
        }
        if (table == null) {
            throw new IllegalArgumentException("'table' should not be null.");
        }
        this.mapping = mapping;
        this.type = mapping.getVisualProperty();
        this.style = style;
        this.dataTable = new WeakReference<CyTable>(table);
        this.editorManager = editorManager;
        this.servicesUtil = servicesUtil;
        this.original = this.createCopy(mapping);
        this.columnType = mapping.getMappingColumnType();
        this.vpValueType = mapping.getVisualProperty().getRange().getType();
        String controllingAttrName = mapping.getMappingColumnName();
        this.paletteProviderMgr = servicesUtil.get(PaletteProviderManager.class);
        CyColumn col = table.getColumn(controllingAttrName);
        if (col == null) {
            logger.info("The column \"" + controllingAttrName + "\" does not exist in the \"" + table.getTitle() + "\" table");
        }
        if (!Number.class.isAssignableFrom(attrType = mapping.getMappingColumnType())) {
            throw new IllegalArgumentException("Cannot support column data type.  Numerical values only: " + attrType);
        }
        if (tracer == null) {
            tracer = new EditorValueRangeTracer(servicesUtil);
        }
        if (mapping.getPointCount() > 0) {
            this.userEdited = true;
        }
        this.initRangeValues();
        this.initComponents();
        this.setSpinner();
        this.getSlider().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int selectedIndex = ContinuousMappingEditorPanel.this.getSlider().getSelectedIndex();
                int tCount = ContinuousMappingEditorPanel.this.getSlider().getModel().getThumbCount();
                if (selectedIndex >= 0 && tCount > selectedIndex) {
                    Thumb handle = ContinuousMappingEditorPanel.this.getSlider().getModel().getThumbAt(selectedIndex);
                    Double handlePosition = (double)(handle.getPosition() / 100.0f) * tracer.getRange(ContinuousMappingEditorPanel.this.type) + tracer.getMin(ContinuousMappingEditorPanel.this.type);
                    ContinuousMappingEditorPanel.this.updateMap();
                    ContinuousMappingEditorPanel.this.spinnerModel = new SpinnerNumberModel(handlePosition, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.01);
                    ContinuousMappingEditorPanel.this.spinnerModel.addChangeListener(new SpinnerChangeListener());
                    ContinuousMappingEditorPanel.this.getValueSpinner().setModel(ContinuousMappingEditorPanel.this.spinnerModel);
                }
                ContinuousMappingEditorPanel.this.update();
            }
        });
    }

    public static void setTracer(EditorValueRangeTracer t) {
        tracer = t;
    }

    public static void resetTracer(VisualProperty<?> vp) {
        if (tracer == null) {
            return;
        }
        tracer.setMin(vp, 0.0);
        tracer.setMax(vp, 0.0);
    }

    private ContinuousMapping<K, V> createCopy(ContinuousMapping<K, V> source) {
        String attribute = source.getMappingColumnName();
        Class attributeType = source.getMappingColumnType();
        VisualProperty visualProperty = source.getVisualProperty();
        VisualMappingFunctionFactory continuousMappingFactory = this.servicesUtil.get(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
        ContinuousMapping mapping = (ContinuousMapping)continuousMappingFactory.createVisualMappingFunction(attribute, attributeType, visualProperty);
        for (ContinuousMappingPoint point : source.getAllPoints()) {
            BoundaryRangeValues range = new BoundaryRangeValues(point.getRange());
            mapping.addPoint((Object)((Number)point.getValue()), range);
        }
        return mapping;
    }

    private void setSpinner() {
        this.spinnerModel = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.01);
        this.spinnerModel.addChangeListener(new SpinnerChangeListener());
        this.getValueSpinner().setModel(this.spinnerModel);
    }

    protected void reset() {
        this.initRangeValues();
        this.updateMap();
        this.userEdited = false;
        this.repaint();
    }

    private void initComponents() {
        this.attrNameLabel = new JLabel("Column Name");
        this.attrNameLabel.setFont(this.attrNameLabel.getFont().deriveFont(1, 14.0f));
        this.handlePositionLabel = new JLabel("Handle Position:");
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getPalettesPanel()).addComponent(this.getMainPanel()).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getPalettesPanel(), -2, -1, -2).addComponent(this.getMainPanel(), -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -2, -1, -2));
        this.update();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    JDialog dialog = (JDialog)this.getRootPane().getParent();
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent event) {
                            if (!ContinuousMappingEditorPanel.this.commitChanges) {
                                ContinuousMappingEditorPanel.this.cancelChangesInternal();
                            }
                        }
                    });
                }
            };
            GroupLayout layout = new GroupLayout(this.mainPanel);
            this.mainPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getEditorPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getFormPanel(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getEditorPanel(), -1, -1, Short.MAX_VALUE).addGap(20).addComponent(this.getFormPanel(), -2, -1, -2));
        }
        return this.mainPanel;
    }

    protected JPanel getPalettesPanel() {
        if (this.palettesPanel == null) {
            this.palettesPanel = new JPanel();
            JLabel label = new JLabel("Current Palette:");
            GroupLayout layout = new GroupLayout(this.palettesPanel);
            this.palettesPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(label, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getPaletteButton(), -1, -1, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label, -1, -1, Short.MAX_VALUE).addComponent(this.getPaletteButton(), -1, -1, Short.MAX_VALUE));
        }
        return this.palettesPanel;
    }

    protected JButton getPaletteButton() {
        if (this.paletteButton == null) {
            this.paletteButton = new JButton("None");
            this.paletteType = tracer.getMax(this.type) > 0.0 && tracer.getMin(this.type) < 0.0 ? BrewerType.DIVERGING : BrewerType.SEQUENTIAL;
            this.lastPalette = this.retrievePalette();
            if (this.lastPalette != null) {
                this.setCurrentPalette(this.lastPalette);
            }
        }
        return this.paletteButton;
    }

    protected void savePalette(Palette palette) {
        this.paletteProviderMgr.savePalette((Object)(this.style.getTitle() + " " + this.type.getIdString()), palette);
    }

    protected Palette retrievePalette() {
        return this.paletteProviderMgr.retrievePalette((Object)(this.style.getTitle() + " " + this.type.getIdString()));
    }

    protected void setCurrentPalette(Palette palette) {
        this.paletteButton.setText(palette.toString());
        this.currentPalette = palette;
    }

    private JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.editorPanel.setMinimumSize(new Dimension(280, 240));
            GroupLayout layout = new GroupLayout(this.editorPanel);
            this.editorPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getIconPanel(), 52, 52, -2).addComponent(this.getBelowPanel(), 26, 26, -2).addGap(2).addComponent((Component)this.getSlider(), 120, 280, Short.MAX_VALUE).addGap(2).addComponent(this.getAbovePanel(), 26, 26, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.getIconPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getBelowPanel(), -1, -1, Short.MAX_VALUE).addComponent((Component)this.getSlider(), 120, 180, Short.MAX_VALUE).addComponent(this.getAbovePanel(), -1, -1, Short.MAX_VALUE));
        }
        return this.editorPanel;
    }

    private JPanel getFormPanel() {
        if (this.formPanel == null) {
            this.formPanel = new JPanel();
            this.formPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Edit Handle Positions and Values"));
            JLabel infoLabel = new JLabel("Double-click on icon to change " + this.type.getDisplayName());
            infoLabel.setFont(infoLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            if (Number.class.isAssignableFrom(this.vpValueType) || Paint.class.isAssignableFrom(this.vpValueType)) {
                infoLabel.setVisible(false);
            }
            GroupLayout layout = new GroupLayout(this.formPanel);
            this.formPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.handlePositionLabel).addComponent(this.getPropertyLabel())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.getValueSpinner()).addGap(10, 20, Short.MAX_VALUE).addComponent(this.getMinMaxButton()).addGap(10, 20, Short.MAX_VALUE).addComponent(this.getAddButton()).addComponent(this.getDeleteButton())).addComponent(this.getValueEditor()))).addComponent(infoLabel));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.handlePositionLabel).addComponent(this.getValueSpinner(), -2, -1, -2).addComponent(this.getMinMaxButton(), -2, -1, -2).addComponent(this.getDeleteButton(), -2, -1, -2).addComponent(this.getAddButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getPropertyLabel()).addComponent(this.getValueEditor(), -2, -1, -2)).addComponent(infoLabel));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getAddButton(), this.getDeleteButton()});
        }
        return this.formPanel;
    }

    protected JPanel getIconPanel() {
        if (this.iconPanel == null) {
            this.iconPanel = new YValueLegendPanel(this.type);
        }
        return this.iconPanel;
    }

    protected JXMultiThumbSlider<V> getSlider() {
        if (this.slider == null) {
            this.slider = new JXMultiThumbSlider();
            this.slider.setMaximumValue(100.0f);
        }
        return this.slider;
    }

    protected BelowAndAbovePanel getBelowPanel() {
        if (this.belowPanel == null) {
            this.belowPanel = new BelowAndAbovePanel(Color.WHITE, true, this.mapping, this);
            this.belowPanel.setName("belowPanel");
        }
        return this.belowPanel;
    }

    protected BelowAndAbovePanel getAbovePanel() {
        if (this.abovePanel == null) {
            this.abovePanel = new BelowAndAbovePanel(Color.YELLOW, false, this.mapping, this);
            this.abovePanel.setName("abovePanel");
        }
        return this.abovePanel;
    }

    private JLabel getPropertyLabel() {
        if (this.propertyLabel == null) {
            this.propertyLabel = new JLabel();
            if (Number.class.isAssignableFrom(this.vpValueType) || Paint.class.isAssignableFrom(this.vpValueType)) {
                this.propertyLabel.setText(this.type.getDisplayName() + ":");
                this.propertyLabel.setLabelFor(this.getValueEditor());
            } else {
                this.propertyLabel.setVisible(false);
            }
        }
        return this.propertyLabel;
    }

    private JComponent getValueEditor() {
        if (this.valueEditor == null) {
            if (Number.class.isAssignableFrom(this.vpValueType)) {
                this.valueEditor = this.getPropertySpinner();
            } else if (Paint.class.isAssignableFrom(this.vpValueType)) {
                this.valueEditor = this.getColorButton();
            } else {
                this.valueEditor = new JLabel();
                this.valueEditor.setVisible(false);
            }
        }
        return this.valueEditor;
    }

    protected JSpinner getPropertySpinner() {
        if (this.propertySpinner == null) {
            this.propertySpinner = new JSpinner();
            this.propertySpinner.setPreferredSize(SPINNER_SIZE);
            this.propertySpinner.setMaximumSize(SPINNER_SIZE);
            this.propertySpinner.setEnabled(false);
        }
        return this.propertySpinner;
    }

    protected JButton getColorButton() {
        if (this.colorButton == null) {
            this.colorButton = new JButton();
            if (LookAndFeelUtil.isAquaLAF()) {
                this.colorButton.putClientProperty("JButton.buttonType", "gradient");
            }
            this.colorButton.setHorizontalTextPosition(0);
            this.colorButton.setVerticalTextPosition(0);
            this.colorButton.setEnabled(false);
            this.setButtonColor(new Color(0, 0, 0, 0));
        }
        return this.colorButton;
    }

    protected JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(evt -> this.addButtonActionPerformed(evt));
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton("Delete");
            this.deleteButton.addActionListener(evt -> this.deleteButtonActionPerformed(evt));
        }
        return this.deleteButton;
    }

    private JButton getMinMaxButton() {
        if (this.minMaxButton == null) {
            this.minMaxButton = new JButton("Set Min and Max...");
            this.minMaxButton.addActionListener(evt -> this.minMaxButtonActionPerformed(evt));
        }
        return this.minMaxButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog dialog = (JDialog)ContinuousMappingEditorPanel.this.getMainPanel().getRootPane().getParent();
                    dialog.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContinuousMappingEditorPanel.this.commitChanges = true;
                    JDialog dialog = (JDialog)ContinuousMappingEditorPanel.this.getMainPanel().getRootPane().getParent();
                    dialog.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JSpinner getValueSpinner() {
        if (this.valueSpinner == null) {
            this.valueSpinner = new JSpinner();
            this.valueSpinner.setPreferredSize(SPINNER_SIZE);
            this.valueSpinner.setMaximumSize(SPINNER_SIZE);
        }
        return this.valueSpinner;
    }

    protected void minMaxButtonActionPerformed(ActionEvent evt) {
        CyTable table = (CyTable)this.dataTable.get();
        if (table != null) {
            CyColumn col = table.getColumn(this.mapping.getMappingColumnName());
            double minTgtVal = Double.POSITIVE_INFINITY;
            double maxTgtVal = Double.NEGATIVE_INFINITY;
            List valueList = col.getValues(col.getType());
            for (Object o : valueList) {
                double val;
                if (!(o instanceof Number) || Double.isNaN(val = ((Number)o).doubleValue())) continue;
                maxTgtVal = Math.max(maxTgtVal, val);
                minTgtVal = Math.min(minTgtVal, val);
            }
            JDialog dialog = (JDialog)this.getMainPanel().getRootPane().getParent();
            Double[] newVal = MinMaxDialog.getMinMax(tracer.getMin(this.type), tracer.getMax(this.type), minTgtVal, maxTgtVal, dialog);
            if (newVal == null) {
                return;
            }
            tracer.setMin(this.type, newVal[0]);
            tracer.setMax(this.type, newVal[1]);
            this.updateMap();
            this.repaint();
        }
    }

    protected abstract void deleteButtonActionPerformed(ActionEvent var1);

    protected abstract void addButtonActionPerformed(ActionEvent var1);

    public abstract ImageIcon drawIcon(int var1, int var2, boolean var3);

    private void initRangeValues() {
        CyColumn col;
        CyTable table;
        if (tracer.getRange(this.type) == 0.0 && (table = (CyTable)this.dataTable.get()) != null && (col = table.getColumn(this.mapping.getMappingColumnName())) != null) {
            Double max = VisualPropertyUtil.getMaxValue(this.mapping);
            Double min = VisualPropertyUtil.getMinValue(this.mapping);
            if (max == null || min == null) {
                max = max == null ? Double.NEGATIVE_INFINITY : max;
                min = min == null ? Double.POSITIVE_INFINITY : min;
                List valueList = col.getValues(col.getType());
                boolean hasValue = false;
                for (Object o : valueList) {
                    if (!(o instanceof Number)) continue;
                    hasValue = true;
                    Number val = (Number)o;
                    if (val.doubleValue() > max) {
                        max = val.doubleValue();
                    }
                    if (!(val.doubleValue() < min)) continue;
                    min = val.doubleValue();
                }
                if (hasValue) {
                    tracer.setMax(this.type, max);
                    tracer.setMin(this.type, min);
                } else {
                    tracer.setMin(this.type, 0.0);
                    tracer.setMax(this.type, 1.0);
                }
            } else {
                tracer.setMax(this.type, max);
                tracer.setMin(this.type, min);
            }
        }
        if (tracer.getRange(this.type) == 0.0) {
            tracer.setMax(this.type, tracer.getMax(this.type) + 1.0);
        }
    }

    protected void setSidePanelIconColor(Color below, Color above) {
        this.getAbovePanel().setColor(above);
        this.getBelowPanel().setColor(below);
        this.repaint();
    }

    protected int getSelectedPoint(int selectedIndex) {
        List thumbs = this.getSlider().getModel().getSortedThumbs();
        Thumb selected = this.getSlider().getModel().getThumbAt(selectedIndex);
        for (int i = 0; i < thumbs.size(); ++i) {
            if (thumbs.get(i) != selected) continue;
            return i;
        }
        return -1;
    }

    protected void updateMap() {
        int mappingPointCount;
        List thumbs = this.getSlider().getModel().getSortedThumbs();
        double min = tracer.getMin(this.type);
        double range = tracer.getRange(this.type);
        this.userEdited = true;
        if (thumbs.size() == 1) {
            this.updateOnePoint(thumbs, min, range);
            return;
        }
        int size = thumbs.size();
        if (size != (mappingPointCount = this.mapping.getPointCount())) {
            throw new IllegalStateException("Number of handles (" + size + ") is not equal to mapping points (" + mappingPointCount + ").");
        }
        int i = 0;
        for (Thumb handle : thumbs) {
            Object greaterVal;
            Object lesserVal;
            ContinuousMappingPoint point = this.mapping.getPoint(i);
            Double handlePosition = (double)(handle.getPosition() / 100.0f) * range + min;
            Object equalVal = handle.getObject();
            if (i == 0) {
                lesserVal = this.below;
                greaterVal = handle.getObject();
            } else if (i == size - 1) {
                greaterVal = this.above;
                lesserVal = handle.getObject();
            } else {
                lesserVal = handle.getObject();
                greaterVal = handle.getObject();
            }
            BoundaryRangeValues newRange = equalVal instanceof Number ? new BoundaryRangeValues(NumberConverter.convert(this.vpValueType, (Number)lesserVal), NumberConverter.convert(this.vpValueType, (Number)equalVal), NumberConverter.convert(this.vpValueType, (Number)greaterVal)) : new BoundaryRangeValues(lesserVal, equalVal, greaterVal);
            point.setRange(newRange);
            point.setValue((Object)handlePosition);
            ++i;
        }
    }

    private void updateOnePoint(List<Thumb<V>> thumbs, double min, double range) {
        Object equalVal = thumbs.get(0).getObject();
        V lesserVal = this.below;
        V greaterVal = this.above;
        if (equalVal instanceof Number) {
            this.mapping.getPoint(0).setRange(new BoundaryRangeValues(NumberConverter.convert(this.vpValueType, (Number)lesserVal), NumberConverter.convert(this.vpValueType, (Number)equalVal), NumberConverter.convert(this.vpValueType, (Number)greaterVal)));
        } else {
            this.mapping.getPoint(0).setRange(new BoundaryRangeValues(lesserVal, equalVal, greaterVal));
        }
        Double newVal = (double)(thumbs.get(0).getPosition() / 100.0f) * range + min;
        this.mapping.getPoint(0).setValue((Object)newVal);
    }

    protected void setButtonColor(Color newColor) {
        this.getColorButton().setIcon(new ColorIcon(newColor));
    }

    void cancelChangesInternal() {
        while (this.mapping.getPointCount() > 0) {
            this.mapping.removePoint(0);
        }
        for (ContinuousMappingPoint point : this.original.getAllPoints()) {
            this.mapping.addPoint((Object)((Number)point.getValue()), point.getRange());
        }
        if (this.lastPalette != null) {
            this.savePalette(this.lastPalette);
        }
        this.cancelChanges();
        this.getSlider().repaint();
    }

    protected abstract void cancelChanges();

    protected void update() {
        int selectedIndex = this.getSlider().getSelectedIndex();
        int count = this.getSlider().getModel().getThumbCount();
        if (selectedIndex >= 0 && count > selectedIndex) {
            ContinuousEditorType editorType = this.editorManager != null ? this.editorManager.getVisualPropertyEditor(this.type).getContinuousEditorType() : null;
            this.getDeleteButton().setEnabled(editorType == ContinuousEditorType.DISCRETE && count > 1 || editorType != ContinuousEditorType.DISCRETE && count > 2);
            this.getValueSpinner().setEnabled(true);
            this.getValueEditor().setEnabled(true);
            Thumb handle = this.getSlider().getModel().getThumbAt(selectedIndex);
            Object value = handle.getObject();
            if (Number.class.isAssignableFrom(this.vpValueType)) {
                this.getPropertySpinner().setValue(value);
            } else if (Paint.class.isAssignableFrom(this.vpValueType)) {
                this.setButtonColor((Color)value);
            }
        } else {
            this.getDeleteButton().setEnabled(false);
            this.getValueSpinner().setEnabled(false);
            this.getValueEditor().setEnabled(false);
            this.getValueSpinner().setValue(0);
            if (Number.class.isAssignableFrom(this.vpValueType)) {
                this.getPropertySpinner().setValue(0);
            } else if (Paint.class.isAssignableFrom(this.vpValueType)) {
                this.setButtonColor(null);
            }
        }
        this.getSlider().repaint();
        this.repaint();
    }

    private final class SpinnerChangeListener
    implements ChangeListener {
        private SpinnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Number newVal = ContinuousMappingEditorPanel.this.spinnerModel.getNumber();
            if (ContinuousMappingEditorPanel.this.lastSpinnerNumber == null) {
                ContinuousMappingEditorPanel.this.lastSpinnerNumber = newVal.doubleValue();
            } else if (newVal.equals(ContinuousMappingEditorPanel.this.lastSpinnerNumber)) {
                return;
            }
            int selectedIndex = ContinuousMappingEditorPanel.this.getSlider().getSelectedIndex();
            if (0 <= selectedIndex && ContinuousMappingEditorPanel.this.getSlider().getModel().getThumbCount() >= 1) {
                if (newVal.doubleValue() < tracer.getMin(ContinuousMappingEditorPanel.this.type) || newVal.doubleValue() > tracer.getMax(ContinuousMappingEditorPanel.this.type)) {
                    if (ContinuousMappingEditorPanel.this.lastSpinnerNumber > tracer.getMin(ContinuousMappingEditorPanel.this.type) && ContinuousMappingEditorPanel.this.lastSpinnerNumber < tracer.getMax(ContinuousMappingEditorPanel.this.type)) {
                        ContinuousMappingEditorPanel.this.spinnerModel.setValue(ContinuousMappingEditorPanel.this.lastSpinnerNumber);
                    } else {
                        ContinuousMappingEditorPanel.this.spinnerModel.setValue(0);
                    }
                    return;
                }
                Double newPosition = ((double)newVal.floatValue() - tracer.getMin(ContinuousMappingEditorPanel.this.type)) / tracer.getRange(ContinuousMappingEditorPanel.this.type);
                ContinuousMappingEditorPanel.this.getSlider().getModel().getThumbAt(selectedIndex).setPosition(newPosition.floatValue() * 100.0f);
                ContinuousMappingEditorPanel.this.getSlider().getSelectedThumb().setLocation((int)((double)(ContinuousMappingEditorPanel.this.getSlider().getSize().width - 12) * newPosition), 0);
                ContinuousMappingEditorPanel.this.updateMap();
                ContinuousMappingEditorPanel.this.getSlider().getSelectedThumb().repaint();
                ContinuousMappingEditorPanel.this.getSlider().getParent().repaint();
                ContinuousMappingEditorPanel.this.getSlider().repaint();
                ContinuousMappingEditorPanel.this.lastSpinnerNumber = newVal.doubleValue();
            }
        }
    }

    private class ColorIcon
    implements Icon {
        private final Color color;
        private final Color borderColor;

        ColorIcon(Color c) {
            this.color = c != null ? c : new Color(0, 0, 0, 0);
            this.borderColor = VisualPropertyUtil.getContrastingColor(this.color);
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 44;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(this.color);
            g.fillRect(x, y, w, h);
            g.setColor(this.borderColor);
            g.drawRect(x, y, w, h);
        }
    }
}

