/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.DefaultViewPanel;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.DiscreteTrackRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.TriangleThumbRenderer;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbRenderer;

public class C2DMappingEditorPanel<V>
extends ContinuousMappingEditorPanel<Number, V> {
    private static final long serialVersionUID = 1213748837197780L;

    public C2DMappingEditorPanel(VisualStyle style, ContinuousMapping<Number, V> mapping, CyTable attr, EditorManager editorManager, ServicesUtil servicesUtil) {
        super(style, mapping, attr, editorManager, servicesUtil);
        this.getIconPanel().setVisible(false);
        this.getBelowPanel().setVisible(false);
        this.getAbovePanel().setVisible(false);
        this.getPalettesPanel().setVisible(false);
        this.initSlider();
    }

    @Override
    protected void addButtonActionPerformed(ActionEvent evt) {
        BoundaryRangeValues newRange;
        Float ratio;
        Object defValue = this.type.getDefault();
        Double maxValue = tracer.getMax(this.type);
        if (this.mapping.getPointCount() == 0) {
            ratio = Float.valueOf(50.0f);
            this.getSlider().getModel().addThumb(ratio.floatValue(), defValue);
            newRange = new BoundaryRangeValues(this.below, defValue, this.above);
        } else {
            ratio = Float.valueOf(70.0f);
            this.getSlider().getModel().addThumb(ratio.floatValue(), defValue);
            ContinuousMappingPoint previousPoint = this.mapping.getPoint(this.mapping.getPointCount() - 1);
            BoundaryRangeValues previousRange = previousPoint.getRange();
            Object lesserVal = ((Thumb)this.getSlider().getModel().getSortedThumbs().get(this.getSlider().getModel().getThumbCount() - 1)).getObject();
            Object equalVal = defValue;
            Object greaterVal = previousRange.greaterValue;
            newRange = new BoundaryRangeValues(lesserVal, equalVal, greaterVal);
        }
        this.mapping.addPoint((Object)(maxValue * (double)(ratio.floatValue() / 100.0f)), newRange);
        this.updateMap();
        this.update();
    }

    @Override
    protected void updateMap() {
        List thumbs = this.getSlider().getModel().getSortedThumbs();
        double minValue = tracer.getMin(this.type);
        double valRange = tracer.getRange(this.type);
        if (thumbs.size() == 1) {
            this.mapping.getPoint(0).setRange(new BoundaryRangeValues(this.below, this.below, this.above));
            Double newPosition = (double)(((Thumb)thumbs.get(0)).getPosition() / 100.0f) * valRange + minValue;
            this.mapping.getPoint(0).setValue((Object)newPosition);
            return;
        }
        for (int i = 0; i < thumbs.size(); ++i) {
            Object greaterVal;
            Object equalVal;
            Object lesserVal;
            Thumb t = (Thumb)thumbs.get(i);
            if (i == 0) {
                lesserVal = this.below;
                equalVal = this.below;
                greaterVal = ((Thumb)thumbs.get(i + 1)).getObject();
            } else if (i == thumbs.size() - 1) {
                greaterVal = this.above;
                equalVal = t.getObject();
                lesserVal = t.getObject();
            } else {
                lesserVal = t.getObject();
                equalVal = t.getObject();
                greaterVal = ((Thumb)thumbs.get(i + 1)).getObject();
            }
            this.mapping.getPoint(i).setRange(new BoundaryRangeValues(lesserVal, equalVal, greaterVal));
            Double newPosition = (double)(t.getPosition() / 100.0f) * valRange + minValue;
            this.mapping.getPoint(i).setValue((Object)newPosition);
        }
    }

    @Override
    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.getSlider().getSelectedIndex();
        if (selectedIndex >= 0) {
            this.getSlider().getModel().removeThumb(selectedIndex);
            this.mapping.removePoint(selectedIndex);
            this.updateMap();
            this.update();
        }
    }

    private void initSlider() {
        this.getSlider().updateUI();
        double minValue = tracer.getMin(this.type);
        final C2DMappingEditorPanel parentComponent = this;
        final DefaultViewPanel defViewPanel = this.servicesUtil.get(DefaultViewPanel.class);
        this.getSlider().addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                int range = ((DiscreteTrackRenderer)C2DMappingEditorPanel.this.getSlider().getTrackRenderer()).getRangeID(e.getX(), e.getY());
                Object newValue = null;
                if (e.getClickCount() == 2) {
                    try {
                        newValue = C2DMappingEditorPanel.this.editorManager.showVisualPropertyValueEditor(parentComponent, C2DMappingEditorPanel.this.type, null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (newValue == null) {
                        return;
                    }
                    if (range >= 0) {
                        if (range == 0) {
                            C2DMappingEditorPanel.this.below = newValue;
                        } else if (range == C2DMappingEditorPanel.this.getSlider().getModel().getThumbCount()) {
                            C2DMappingEditorPanel.this.above = newValue;
                        } else if (range < C2DMappingEditorPanel.this.getSlider().getModel().getThumbCount()) {
                            ((Thumb)C2DMappingEditorPanel.this.getSlider().getModel().getSortedThumbs().get(range)).setObject(newValue);
                        }
                    }
                    C2DMappingEditorPanel.this.updateMap();
                    C2DMappingEditorPanel.this.getSlider().setTrackRenderer(new DiscreteTrackRenderer(C2DMappingEditorPanel.this.mapping, C2DMappingEditorPanel.this.below, C2DMappingEditorPanel.this.above, ContinuousMappingEditorPanel.tracer, defViewPanel.getRenderingEngine()));
                    C2DMappingEditorPanel.this.getSlider().repaint();
                }
            }
        });
        double actualRange = tracer.getRange(this.type);
        for (Object point : this.mapping.getAllPoints()) {
            BoundaryRangeValues bound = point.getRange();
            Float fraction = Float.valueOf(((Number)((((Number)point.getValue()).doubleValue() - minValue) / actualRange)).floatValue() * 100.0f);
            this.getSlider().getModel().addThumb(fraction.floatValue(), bound.equalValue);
        }
        TreeMap<Double, ContinuousMappingPoint> sortedPoints = new TreeMap<Double, ContinuousMappingPoint>();
        for (ContinuousMappingPoint point : this.mapping.getAllPoints()) {
            Number val = (Number)point.getValue();
            sortedPoints.put(val.doubleValue(), point);
        }
        if (!sortedPoints.isEmpty()) {
            this.below = ((ContinuousMappingPoint)sortedPoints.get(sortedPoints.firstKey())).getRange().lesserValue;
            this.above = ((ContinuousMappingPoint)sortedPoints.get(sortedPoints.lastKey())).getRange().greaterValue;
        } else {
            Object defaultVal;
            this.below = defaultVal = this.type.getDefault();
            this.above = defaultVal;
        }
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer();
        DiscreteTrackRenderer dRend = new DiscreteTrackRenderer(this.mapping, this.below, this.above, tracer, defViewPanel.getRenderingEngine());
        this.getSlider().setThumbRenderer((ThumbRenderer)thumbRend);
        this.getSlider().setTrackRenderer(dRend);
    }

    @Override
    public ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        DiscreteTrackRenderer rend = (DiscreteTrackRenderer)this.getSlider().getTrackRenderer();
        rend.getRendererComponent(this.getSlider());
        return rend.getTrackGraphicIcon(iconWidth, iconHeight);
    }

    public ImageIcon getLegend(int width, int height) {
        if (!(this.getSlider().getTrackRenderer() instanceof DiscreteTrackRenderer)) {
            return null;
        }
        DiscreteTrackRenderer rend = (DiscreteTrackRenderer)this.getSlider().getTrackRenderer();
        rend.getRendererComponent(this.getSlider());
        return rend.getLegend(width, height);
    }

    @Override
    protected void cancelChanges() {
        this.initSlider();
    }
}

