/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.SpinnerNumberModel;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.internal.util.NumberConverter;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousTrackRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.TriangleThumbRenderer;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class C2CMappingEditorPanel<K extends Number, V extends Number>
extends ContinuousMappingEditorPanel<K, V>
implements PropertyChangeListener {
    private static final long serialVersionUID = 1213748836613718L;
    private static final Number DEF_BELOW_AND_ABOVE = 1.0;
    private static final Number FIRST_LOCATION = 10.0;
    private static final Number SECOND_LOCATION = 30.0;

    public C2CMappingEditorPanel(VisualStyle style, ContinuousMapping<K, V> mapping, CyTable attr, EditorManager editorManager, ServicesUtil servicesUtil) {
        super(style, mapping, attr, editorManager, servicesUtil);
        this.getAbovePanel().setVisible(false);
        this.getBelowPanel().setVisible(false);
        this.getPalettesPanel().setVisible(false);
        this.initSlider();
        if (mapping.getAllPoints().isEmpty()) {
            this.addSlider(0.0, FIRST_LOCATION);
            this.addSlider(100.0, SECOND_LOCATION);
        }
        this.setPropertySpinner();
    }

    private V convertToValue(Number value) {
        return (V)((Number)NumberConverter.convert(this.vpValueType, value));
    }

    private K convertToColumnValue(Number value) {
        return (K)((Number)NumberConverter.convert(this.columnType, value));
    }

    public ImageIcon getIcon(int iconWidth, int iconHeight) {
        TrackRenderer rend = this.getSlider().getTrackRenderer();
        if (rend instanceof ContinuousTrackRenderer) {
            rend.getRendererComponent(this.getSlider());
            return ((ContinuousTrackRenderer)rend).getTrackGraphicIcon(iconWidth, iconHeight);
        }
        return null;
    }

    public ImageIcon getLegend(int width, int height) {
        ContinuousTrackRenderer rend = (ContinuousTrackRenderer)this.getSlider().getTrackRenderer();
        rend.getRendererComponent(this.getSlider());
        return rend.getLegend(width, height);
    }

    private void addSlider(Number position, Number value) {
        K maxValue = this.convertToColumnValue(tracer.getMax(this.type));
        this.getSlider().getModel().addThumb(position.floatValue(), this.convertToValue(value));
        if (this.mapping.getPointCount() == 0) {
            BoundaryRangeValues newRange = new BoundaryRangeValues(this.convertToValue((Number)this.below), this.convertToValue(5.0), this.convertToValue((Number)this.above));
            K newKey = this.convertToColumnValue(((Number)maxValue).doubleValue() / 2.0);
            this.mapping.addPoint(newKey, newRange);
            this.updateMap();
            return;
        }
        TreeMap<Double, ContinuousMappingPoint> sortedPoints = new TreeMap<Double, ContinuousMappingPoint>();
        for (ContinuousMappingPoint point : this.mapping.getAllPoints()) {
            Number val = (Number)point.getValue();
            sortedPoints.put(val.doubleValue(), point);
        }
        ContinuousMappingPoint previousPoint = (ContinuousMappingPoint)sortedPoints.get(sortedPoints.lastKey());
        BoundaryRangeValues previousRange = previousPoint.getRange();
        Number lesserVal = (Number)previousPoint.getRange().greaterValue;
        Number equalVal = (Number)previousPoint.getRange().greaterValue;
        Number greaterVal = (Number)previousRange.greaterValue;
        BoundaryRangeValues newRange = new BoundaryRangeValues(this.convertToValue(lesserVal), this.convertToValue(equalVal), this.convertToValue(greaterVal));
        this.mapping.addPoint(maxValue, newRange);
        this.updateMap();
    }

    @Override
    protected void addButtonActionPerformed(ActionEvent evt) {
        this.addSlider(50.0, (Number)this.convertToValue(5.0));
        this.update();
    }

    @Override
    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.getSlider().getSelectedIndex();
        if (selectedIndex >= 0) {
            if (this.getSlider().getModel().getThumbCount() > selectedIndex) {
                this.getSlider().getModel().removeThumb(selectedIndex);
            }
            if (this.mapping.getPointCount() > selectedIndex) {
                this.mapping.removePoint(selectedIndex);
            }
            this.initSlider();
        }
        this.update();
    }

    private void initSlider() {
        this.getSlider().updateUI();
        Double minValue = tracer.getMin(this.type);
        Double actualRange = tracer.getRange(this.type);
        List sorted = this.getSlider().getModel().getSortedThumbs();
        for (Object t : sorted) {
            this.getSlider().getModel().removeThumb(this.getSlider().getModel().getThumbIndex((Thumb)t));
        }
        TreeMap<Double, ContinuousMappingPoint> sortedPoints = new TreeMap<Double, ContinuousMappingPoint>();
        for (ContinuousMappingPoint point : this.mapping.getAllPoints()) {
            Number val = (Number)point.getValue();
            sortedPoints.put(val.doubleValue(), point);
        }
        for (Double key : sortedPoints.keySet()) {
            ContinuousMappingPoint point = (ContinuousMappingPoint)sortedPoints.get(key);
            BoundaryRangeValues bound = point.getRange();
            Double fraction = (double)((Number)((((Number)point.getValue()).doubleValue() - minValue) / actualRange)).floatValue() * 100.0;
            this.getSlider().getModel().addThumb(((Number)fraction).floatValue(), (Object)((Number)bound.equalValue));
        }
        if (!sortedPoints.isEmpty()) {
            this.below = ((ContinuousMappingPoint)sortedPoints.get(sortedPoints.firstKey())).getRange().lesserValue;
            this.above = ((ContinuousMappingPoint)sortedPoints.get(sortedPoints.lastKey())).getRange().greaterValue;
        } else {
            this.below = this.convertToValue(DEF_BELOW_AND_ABOVE);
            this.above = this.convertToValue(DEF_BELOW_AND_ABOVE);
        }
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer();
        ContinuousTrackRenderer cRend = new ContinuousTrackRenderer(this.style, this.mapping, (Number)this.below, (Number)this.above, tracer, this.servicesUtil);
        cRend.addPropertyChangeListener(this);
        this.getSlider().setThumbRenderer((ThumbRenderer)thumbRend);
        this.getSlider().setTrackRenderer(cRend);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("BELOW_VALUE_CHANGED")) {
            this.below = this.convertToValue((Number)evt.getNewValue());
        } else if (evt.getPropertyName().equals("ABOVE_VALUE_CHANGED")) {
            this.above = this.convertToValue((Number)evt.getNewValue());
        }
    }

    @Override
    public ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        TrackRenderer rend = this.getSlider().getTrackRenderer();
        if (rend instanceof ContinuousTrackRenderer) {
            rend.getRendererComponent(this.getSlider());
            return ((ContinuousTrackRenderer)rend).getTrackGraphicIcon(iconWidth, iconHeight);
        }
        return null;
    }

    private void setPropertySpinner() {
        SpinnerNumberModel model = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.01);
        model.addChangeListener(evt -> {
            if (!this.getPropertySpinner().isEnabled()) {
                return;
            }
            Double newVal = model.getNumber().doubleValue();
            int selectedIndex = this.getSlider().getSelectedIndex();
            Number currentValue = (Number)this.getSlider().getModel().getThumbAt(selectedIndex).getObject();
            if (currentValue.equals(newVal)) {
                return;
            }
            this.getSlider().getModel().getThumbAt(selectedIndex).setObject(this.convertToValue(newVal));
            this.getSlider().repaint();
            this.updateMap();
        });
        this.getPropertySpinner().setModel(model);
    }

    @Override
    protected void cancelChanges() {
        this.initSlider();
    }
}

