/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.cellrenderer;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingEditor;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberContinuousCellRenderer
extends DefaultCellRenderer {
    private static final long serialVersionUID = -6734053848878359286L;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final ContinuousMappingEditor<?, ?> editor;

    public NumberContinuousCellRenderer(ContinuousMappingEditor<?, ?> editor) {
        if (editor == null) {
            throw new NullPointerException("Editor object is null.");
        }
        this.editor = editor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || !(value instanceof ContinuousMapping)) {
            this.setText("Unkonown Mapping");
            return this;
        }
        logger.debug("Number cell renderer called: " + value.toString());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        int height = table.getRowHeight(row);
        int width = table.getColumnModel().getColumn(column).getWidth();
        ImageIcon icon = this.editor.drawIcon(width, height - 2, false);
        this.setIcon(icon);
        return this;
    }
}

