/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class IconCellRenderer<T>
extends JPanel
implements TableCellRenderer,
ListCellRenderer {
    private static final long serialVersionUID = 8942821990143018260L;
    private final JLabel iconLbl;
    private final JLabel textLbl;
    private Map<? extends T, Icon> icons;

    public IconCellRenderer(Map<? extends T, Icon> icons) {
        this.icons = icons;
        this.iconLbl = new JLabel();
        this.iconLbl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.textLbl = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.iconLbl);
        this.add(Box.createHorizontalStrut(20));
        this.add(this.textLbl);
        this.add(Box.createHorizontalGlue());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = isSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background");
        Color fg = this.getForeground();
        this.update(value, bg, fg);
        Color BORDER_COLOR = UIManager.getColor("Separator.foreground");
        CompoundBorder BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR), BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setBorder(BORDER);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color bg = isSelected ? table.getSelectionBackground() : table.getBackground();
        Color fg = isSelected ? table.getSelectionForeground() : table.getForeground();
        this.update(value, bg, fg);
        return this;
    }

    private void update(Object value, Color bg, Color fg) {
        this.setBackground(bg);
        this.setForeground(fg);
        String label = this.getLabel(value);
        Icon icon = this.icons.get(value);
        this.iconLbl.setIcon(icon);
        this.iconLbl.setBackground(bg);
        this.iconLbl.setForeground(fg);
        this.textLbl.setText(label);
        this.textLbl.setToolTipText(label);
        this.textLbl.setBackground(bg);
        this.textLbl.setForeground(fg);
    }

    private String getLabel(T value) {
        String text = null;
        if (value != null) {
            Class<?> valueClass = value.getClass();
            try {
                Method displayMethod = valueClass.getMethod("getDisplayName", new Class[]{null});
                Object returnVal = displayMethod.invoke(value, new Object[]{null});
                if (returnVal != null) {
                    text = returnVal.toString();
                }
            }
            catch (Exception e) {
                text = value.toString();
            }
        }
        return text;
    }
}

