/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.cytoscape.application.swing.CyEdgeViewContextMenuFactory;
import org.cytoscape.application.swing.CyMenuItem;
import org.cytoscape.application.swing.CyNetworkViewContextMenuFactory;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValuesVO;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.puremvc.java.multicore.interfaces.INotification;
import org.puremvc.java.multicore.patterns.mediator.Mediator;

public class VizMapperMenuMediator
extends Mediator {
    public static final String NAME = "VizMapperMenuMediator";
    private static final String METADATA_MENU_KEY = "menu";
    private final ServicesUtil servicesUtil;
    private final VizMapperMainPanel vizMapperMainPanel;
    private VizMapperProxy proxy;
    private final Set<RenderingEngineFactory<?>> engineFactories = new HashSet();

    public VizMapperMenuMediator(VizMapperMainPanel vizMapperMainPanel, ServicesUtil servicesUtil) {
        super(NAME, (Object)vizMapperMainPanel);
        if (vizMapperMainPanel == null) {
            throw new IllegalArgumentException("'vizMapperMainPanel' must not be null");
        }
        if (servicesUtil == null) {
            throw new IllegalArgumentException("'servicesUtil' must not be null");
        }
        this.vizMapperMainPanel = vizMapperMainPanel;
        this.servicesUtil = servicesUtil;
    }

    public final void onRegister() {
        this.proxy = (VizMapperProxy)this.getFacade().retrieveProxy("VisualStyleProxy");
        this.registerMenuItems();
        super.onRegister();
    }

    public String[] listNotificationInterests() {
        return new String[0];
    }

    public void handleNotification(INotification notification) {
        String id = notification.getName();
        Object body = notification.getBody();
    }

    public void onRenderingEngineFactoryRegistered(RenderingEngineFactory<?> factory, Map<?, ?> properties) {
        this.engineFactories.add(factory);
    }

    public void onRenderingEngineFactoryUnregistered(RenderingEngineFactory<?> factory, Map<?, ?> properties) {
        this.engineFactories.remove(factory);
    }

    private void registerMenuItems() {
        Properties nodeProp = new Properties();
        nodeProp.setProperty("preferredTaskManager", METADATA_MENU_KEY);
        nodeProp.setProperty("preferredMenu", "Edit[-1100]");
        nodeProp.setProperty("menuGravity", "-1");
        NodeBypassContextMenuFactory nodeBypassContextMenuFactory = new NodeBypassContextMenuFactory();
        this.servicesUtil.registerAllServices(nodeBypassContextMenuFactory, nodeProp);
        Properties edgeProp = new Properties();
        edgeProp.setProperty("preferredTaskManager", METADATA_MENU_KEY);
        edgeProp.setProperty("preferredMenu", "Edit[-1100]");
        edgeProp.setProperty("menuGravity", "-1");
        EdgeBypassContextMenuFactory edgeBypassContextMenuFactory = new EdgeBypassContextMenuFactory();
        this.servicesUtil.registerAllServices(edgeBypassContextMenuFactory, edgeProp);
        Properties netProp = new Properties();
        netProp.setProperty("preferredTaskManager", METADATA_MENU_KEY);
        netProp.setProperty("preferredMenu", "Edit[-1080]");
        netProp.setProperty("menuGravity", "-1");
        NetworkBypassContextMenuFactory netBypassContextMenuFactory = new NetworkBypassContextMenuFactory();
        this.servicesUtil.registerAllServices(netBypassContextMenuFactory, netProp);
    }

    private class NodeBypassContextMenuFactory
    implements CyNodeViewContextMenuFactory {
        private NodeBypassContextMenuFactory() {
        }

        public CyMenuItem createMenuItem(CyNetworkView netView, View<CyNode> nodeView) {
            BypassContextMenuBuilder menuBuilder = new BypassContextMenuBuilder(BasicVisualLexicon.NODE);
            return menuBuilder.build(netView, nodeView);
        }
    }

    private class EdgeBypassContextMenuFactory
    implements CyEdgeViewContextMenuFactory {
        private EdgeBypassContextMenuFactory() {
        }

        public CyMenuItem createMenuItem(CyNetworkView netView, View<CyEdge> edgeView) {
            BypassContextMenuBuilder menuBuilder = new BypassContextMenuBuilder(BasicVisualLexicon.EDGE);
            return menuBuilder.build(netView, edgeView);
        }
    }

    private class NetworkBypassContextMenuFactory
    implements CyNetworkViewContextMenuFactory {
        private NetworkBypassContextMenuFactory() {
        }

        public CyMenuItem createMenuItem(CyNetworkView netView) {
            BypassContextMenuBuilder menuBuilder = new BypassContextMenuBuilder(BasicVisualLexicon.NETWORK);
            return menuBuilder.build(netView, (View<? extends CyIdentifiable>)netView);
        }
    }

    private class BypassContextMenuBuilder {
        private static final String ROOT = "Bypass Style";
        private static final String REMOVE_ALL_FROM = "Remove All from this ";
        private static final String REMOVE_ALL_FROM_SELECTED_NODES = "Remove All from Selected Nodes";
        private static final String REMOVE_ALL_FROM_SELECTED_EDGES = "Remove All from Selected Edges";
        private static final String SET_TO_SELECTED_NODES = "Set Bypass to Selected Nodes";
        private static final String SET_TO_SELECTED_EDGES = "Set Bypass to Selected Edges";
        private static final String SET_TO_NETWORK = "Set Bypass to Network";
        private final VisualProperty<?> root;
        private final Set<VisualProperty<?>> vpSet = new HashSet();

        public BypassContextMenuBuilder(VisualProperty<?> root) {
            this.root = root;
        }

        CyMenuItem build(CyNetworkView netView, View<? extends CyIdentifiable> view) {
            JMenuItem mi;
            Set<View<? extends CyIdentifiable>> selectedViews;
            this.vpSet.clear();
            for (RenderingEngineFactory<?> ef : VizMapperMenuMediator.this.engineFactories) {
                this.vpSet.addAll(ef.getVisualLexicon().getAllDescendants(this.root));
            }
            JMenu rootMenu = new JMenu(ROOT);
            Class targetDataType = this.root.getTargetDataType();
            String viewName = targetDataType.getSimpleName().replace("Cy", "");
            JMenuItem mi2 = new JMenuItem(REMOVE_ALL_FROM + viewName);
            mi2.setEnabled(this.hasLockedValues(view));
            mi2.addActionListener(evt -> {
                LockedValuesVO vo = new LockedValuesVO(netView, Collections.singleton(view), this.vpSet);
                VizMapperMenuMediator.this.sendNotification("REMOVE_LOCKED_VALUES", vo);
            });
            rootMenu.add(mi2);
            if (targetDataType == CyNode.class || targetDataType == CyNetwork.class) {
                selectedViews = VizMapperMenuMediator.this.proxy.getSelectedNodeViews(netView);
                mi = new JMenuItem(REMOVE_ALL_FROM_SELECTED_NODES);
                mi.setEnabled(this.hasLockedValues(selectedViews));
                mi.addActionListener(evt -> {
                    LockedValuesVO vo = new LockedValuesVO(netView, selectedViews, this.vpSet);
                    VizMapperMenuMediator.this.sendNotification("REMOVE_LOCKED_VALUES", vo);
                });
                rootMenu.add(mi);
            }
            if (targetDataType == CyEdge.class || targetDataType == CyNetwork.class) {
                selectedViews = VizMapperMenuMediator.this.proxy.getSelectedEdgeViews(netView);
                mi = new JMenuItem(REMOVE_ALL_FROM_SELECTED_EDGES);
                mi.setEnabled(this.hasLockedValues(selectedViews));
                mi.addActionListener(evt -> {
                    LockedValuesVO vo = new LockedValuesVO(netView, selectedViews, this.vpSet);
                    VizMapperMenuMediator.this.sendNotification("REMOVE_LOCKED_VALUES", vo);
                });
                rootMenu.add(mi);
            }
            rootMenu.add(new JSeparator());
            mi2 = new JMenuItem(SET_TO_SELECTED_NODES);
            mi2.setEnabled(!VizMapperMenuMediator.this.proxy.getSelectedNodeViews(netView).isEmpty());
            mi2.addActionListener(evt -> this.showVizMapperPanel(CyNode.class));
            rootMenu.add(mi2);
            mi2 = new JMenuItem(SET_TO_SELECTED_EDGES);
            mi2.setEnabled(!VizMapperMenuMediator.this.proxy.getSelectedEdgeViews(netView).isEmpty());
            mi2.addActionListener(evt -> this.showVizMapperPanel(CyEdge.class));
            rootMenu.add(mi2);
            mi2 = new JMenuItem(SET_TO_NETWORK);
            mi2.addActionListener(evt -> this.showVizMapperPanel(CyNetwork.class));
            rootMenu.add(mi2);
            return new CyMenuItem((JMenuItem)rootMenu, 1.0E7f);
        }

        private void showVizMapperPanel(Class<? extends CyIdentifiable> targetDataType) {
            CySwingApplication swingApp = VizMapperMenuMediator.this.servicesUtil.get(CySwingApplication.class);
            CytoPanel cytoPanel = swingApp.getCytoPanel(CytoPanelName.WEST);
            int vizMapperIndex = cytoPanel.indexOfComponent((Component)VizMapperMenuMediator.this.vizMapperMainPanel);
            if (vizMapperIndex > -1) {
                VisualPropertySheet vpSheet;
                if (cytoPanel.getState() == CytoPanelState.HIDE) {
                    cytoPanel.setState(CytoPanelState.DOCK);
                }
                if (cytoPanel.getSelectedIndex() != vizMapperIndex) {
                    cytoPanel.setSelectedIndex(vizMapperIndex);
                }
                if ((vpSheet = VizMapperMenuMediator.this.vizMapperMainPanel.getVisualPropertySheet(targetDataType)) != null) {
                    VizMapperMenuMediator.this.vizMapperMainPanel.setSelectedVisualPropertySheet(vpSheet);
                }
            }
        }

        private boolean hasLockedValues(View<? extends CyIdentifiable> view) {
            for (VisualProperty<?> vp : this.vpSet) {
                if (!view.isDirectlyLocked(vp)) continue;
                return true;
            }
            return false;
        }

        private boolean hasLockedValues(Set<View<? extends CyIdentifiable>> viewSet) {
            for (View<? extends CyIdentifiable> view : viewSet) {
                if (!this.hasLockedValues(view)) continue;
                return true;
            }
            return false;
        }
    }
}

