/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.events.UpdateNetworkPresentationListener;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.DefaultVisualizableVisualProperty;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.StyleAssociation;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedListener;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.event.LexiconStateChangedEvent;
import org.cytoscape.view.vizmap.gui.event.LexiconStateChangedListener;
import org.cytoscape.view.vizmap.gui.internal.ColumnSpec;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.VisualStyleSet;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.action.GenerateDiscreteValuesAction;
import org.cytoscape.view.vizmap.gui.internal.controller.CopyContinuousMappingCommand;
import org.cytoscape.view.vizmap.gui.internal.controller.RemoveVisualMappingsCommand;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValueState;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValuesVO;
import org.cytoscape.view.vizmap.gui.internal.model.MappingFunctionFactoryProxy;
import org.cytoscape.view.vizmap.gui.internal.model.PropsProxy;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicePropertiesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.ColumnStylePicker;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualStylePanelProvider;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.cytoscape.view.vizmap.gui.util.DiscreteMappingGenerator;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;
import org.puremvc.java.multicore.interfaces.INotification;
import org.puremvc.java.multicore.patterns.mediator.Mediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VizMapperMediator
extends Mediator
implements LexiconStateChangedListener,
RowsSetListener,
ColumnCreatedListener,
ColumnDeletedListener,
ColumnNameChangedListener,
UpdateNetworkPresentationListener,
VisualMappingFunctionChangedListener {
    public static final String NAME = "VizMapperMediator";
    static final List<Class<? extends CyIdentifiable>> NETWORK_SHEET_TYPES = List.of(CyNode.class, CyEdge.class, CyNetwork.class);
    static final List<Class<? extends CyIdentifiable>> TABLE_SHEET_TYPES = List.of(CyColumn.class);
    private VizMapperProxy vmProxy;
    private AttributeSetProxy attrProxy;
    private MappingFunctionFactoryProxy mappingFactoryProxy;
    private PropsProxy propsProxy;
    private boolean ignoreVisualStyleSelectedEvents;
    private VisualPropertySheetItem<?> curVpSheetItem;
    private VizMapperProperty<?, ?, ?> curVizMapperProperty;
    private ColumnSpec selectedColumn;
    private BiConsumer<ColumnSpec, ColumnStylePicker.Action> columnChangeListener;
    private String curRendererId;
    private final ServicesUtil servicesUtil;
    private final VizMapperMainPanel vizMapperMainPanel;
    private final VizMapPropertyBuilder vizMapPropertyBuilder;
    private final Map<String, GenerateDiscreteValuesAction> mappingGenerators;
    private final Map<TaskFactory, JMenuItem> taskFactories;
    private final Map<CyAction, JMenuItem> actions;
    private final Map<String, Boolean> userProps;
    private final Map<Class<? extends CyIdentifiable>, Set<String>> defVisibleProps;
    private final DebounceTimer debounceTimer = new DebounceTimer(240);
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public VizMapperMediator(VizMapperMainPanel vizMapperMainPanel, ServicesUtil servicesUtil, VizMapPropertyBuilder vizMapPropertyBuilder) {
        super(NAME, (Object)vizMapperMainPanel);
        this.vizMapperMainPanel = Objects.requireNonNull(vizMapperMainPanel, "'vizMapperMainPanel' must not be null");
        this.servicesUtil = Objects.requireNonNull(servicesUtil, "'servicesUtil' must not be null");
        this.vizMapPropertyBuilder = Objects.requireNonNull(vizMapPropertyBuilder, "'vizMapPropertyBuilder' must not be null");
        this.mappingGenerators = new TreeMap<String, GenerateDiscreteValuesAction>(Collator.getInstance(Locale.getDefault())::compare);
        this.taskFactories = new HashMap<TaskFactory, JMenuItem>();
        this.actions = new HashMap<CyAction, JMenuItem>();
        this.userProps = new HashMap<String, Boolean>();
        this.defVisibleProps = new HashMap<Class<? extends CyIdentifiable>, Set<String>>();
        this.setViewComponent(vizMapperMainPanel);
    }

    public final void onRegister() {
        this.vmProxy = (VizMapperProxy)this.getFacade().retrieveProxy("VisualStyleProxy");
        this.attrProxy = (AttributeSetProxy)this.getFacade().retrieveProxy("AttributeSetProxy");
        this.mappingFactoryProxy = (MappingFunctionFactoryProxy)this.getFacade().retrieveProxy("MappingFunctionFactoryProxy");
        this.propsProxy = (PropsProxy)this.getFacade().retrieveProxy("VizMapperPropsProxy");
        this.updateDefaultProps();
        this.initView();
        super.onRegister();
    }

    public VizMapperProxy getVizMapperProxy() {
        return this.vmProxy;
    }

    public String[] listNotificationInterests() {
        return new String[]{"VISUAL_STYLE_SET_CHANGED", "VISUAL_STYLE_ADDED", "VISUAL_STYLE_REMOVED", "CURRENT_VISUAL_STYLE_CHANGED", "VISUAL_STYLE_UPDATED", "CURRENT_NETWORK_VIEW_CHANGED", "VISUAL_STYLE_NAME_CHANGED", "TABLE_ASSOCIATED_VISUAL_STYLE_UPDATED"};
    }

    public void handleNotification(INotification notification) {
        String id = notification.getName();
        Object body = notification.getBody();
        switch (id) {
            case "VISUAL_STYLE_SET_CHANGED": {
                this.updateVisualStyleList((SortedSet)body, true);
                break;
            }
            case "VISUAL_STYLE_ADDED": 
            case "VISUAL_STYLE_REMOVED": {
                this.updateVisualStyleList(this.vmProxy.getVisualStyles(), false);
                break;
            }
            case "CURRENT_VISUAL_STYLE_CHANGED": {
                ViewUtil.invokeOnEDTAndWait(() -> {
                    this.ignoreVisualStyleSelectedEvents = true;
                    try {
                        this.selectCurrentVisualStyle((VisualStyle)body);
                    }
                    finally {
                        this.ignoreVisualStyleSelectedEvents = false;
                    }
                });
                ViewUtil.invokeOnEDT(() -> {
                    VisualStyle vs = (VisualStyle)body;
                    this.updateAllVisualPropertySheets(vs, false);
                });
                break;
            }
            case "VISUAL_STYLE_UPDATED": {
                if (body == null) break;
                VisualStyle style = (VisualStyle)body;
                VisualStyle currNetStyle = this.vmProxy.getCurrentNetworkVisualStyle();
                if (!style.equals(currNetStyle)) {
                    TableVisualMappingManager tableVMM = this.servicesUtil.get(TableVisualMappingManager.class);
                    Set netStyles = tableVMM.getAssociatedNetworkVisualStyles(style);
                    if (!netStyles.contains(currNetStyle)) break;
                    this.updateVisualPropertySheets(style, TABLE_SHEET_TYPES, false, false);
                    break;
                }
                this.updateAllVisualPropertySheets(style, false);
                ViewUtil.invokeOnEDT(() -> this.vizMapperMainPanel.getStylesPanelProvider().update(style));
                break;
            }
            case "CURRENT_NETWORK_VIEW_CHANGED": {
                String newRendererId;
                CyNetworkView view = (CyNetworkView)body;
                String string = newRendererId = view != null ? view.getRendererId() : null;
                if (view != null && newRendererId != null && !newRendererId.equals(this.curRendererId)) {
                    this.updateAllVisualPropertySheets(this.vmProxy.getNetworkVisualStyle(view), false);
                    this.curRendererId = newRendererId;
                    break;
                }
                if (view != null && !this.vmProxy.getNetworkVisualStyle(view).equals(this.vizMapperMainPanel.getSelectedVisualStyle())) break;
                this.updateLockedValues(view);
                if (body instanceof CyNetworkView) {
                    this.updateMappings(CyNode.class, ((CyNetwork)view.getModel()).getDefaultNodeTable());
                    this.updateMappings(CyEdge.class, ((CyNetwork)view.getModel()).getDefaultEdgeTable());
                }
                this.updateItemsStatus();
                this.updateColumnPickerWarnings();
                break;
            }
            case "VISUAL_STYLE_NAME_CHANGED": {
                ViewUtil.invokeOnEDT(() -> {
                    this.vizMapperMainPanel.getStylesBtn().update();
                    this.vizMapperMainPanel.getStylesPanelProvider().update((VisualStyle)body);
                });
                break;
            }
            case "TABLE_ASSOCIATED_VISUAL_STYLE_UPDATED": {
                StyleAssociation association = (StyleAssociation)body;
                this.updateColumnAssociation(association);
            }
        }
    }

    private VisualProperty<?> getRootVP(Class<? extends CyIdentifiable> type) {
        if (NETWORK_SHEET_TYPES.contains(type)) {
            return BasicVisualLexicon.NETWORK;
        }
        return BasicTableVisualLexicon.CELL;
    }

    public CyTable getCurrentMappingTable() {
        GraphObjectType tableType = this.getSelectedVisualPropertySheet().getModel().getTableType();
        return this.getCurrentMappingTable(tableType);
    }

    public CyTable getCurrentMappingTable(GraphObjectType type) {
        CyNetwork curNet = this.vmProxy.getCurrentNetwork();
        if (type == null) {
            return null;
        }
        if (type.type() == CyNode.class) {
            return curNet == null ? null : curNet.getDefaultNodeTable();
        }
        if (type.type() == CyEdge.class) {
            return curNet == null ? null : curNet.getDefaultEdgeTable();
        }
        if (type.type() == CyNetwork.class) {
            return curNet == null ? null : curNet.getDefaultNetworkTable();
        }
        return null;
    }

    @Override
    public void handleEvent(LexiconStateChangedEvent e) {
        VisualStyle curStyle = this.vmProxy.getCurrentNetworkVisualStyle();
        Set<CyNetworkView> views = this.vmProxy.getNetworkViewsWithStyle(curStyle);
        for (CyNetworkView view : views) {
            curStyle.apply(view);
            view.updateView();
        }
        ViewUtil.invokeOnEDT(() -> this.updateItemsStatus());
    }

    public void handleEvent(RowsSetEvent e) {
        CyNetwork curNet;
        CyTable tbl = (CyTable)e.getSource();
        CyNetworkView curNetView = this.vmProxy.getCurrentNetworkView();
        if (curNetView != null && e.containsColumn("selected")) {
            curNet = (CyNetwork)curNetView.getModel();
            if (tbl.equals(curNet.getDefaultEdgeTable())) {
                this.updateLockedValues(this.vmProxy.getSelectedEdgeViews(curNetView), CyEdge.class);
            } else if (tbl.equals(curNet.getDefaultNodeTable())) {
                this.updateLockedValues(this.vmProxy.getSelectedNodeViews(curNetView), CyNode.class);
            } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
                this.updateLockedValues(Collections.singleton(curNetView), CyNetwork.class);
            }
        }
        if ((curNet = this.vmProxy.getCurrentNetwork()) != null) {
            ArrayList<VisualPropertySheet> vpSheets = new ArrayList<VisualPropertySheet>(2);
            if (tbl.equals(curNet.getDefaultEdgeTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyEdge.class));
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
            } else if (tbl.equals(curNet.getDefaultNodeTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNode.class));
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
            } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class));
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
            }
            if (!vpSheets.isEmpty()) {
                Set columns = e.getColumns();
                for (VisualPropertySheet vpSheet : vpSheets) {
                    if (vpSheet == null) continue;
                    block1: for (VisualPropertySheetItem<?> item : vpSheet.getAllItems()) {
                        VisualMappingFunction<?, ?> mapping = item.getModel().getVisualMappingFunction();
                        if (mapping == null) continue;
                        for (String columnName : columns) {
                            if (!mapping.getMappingColumnName().equalsIgnoreCase(columnName)) continue;
                            ViewUtil.invokeOnEDT(() -> item.updateMapping());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        CyTable table = (CyTable)e.getSource();
        this.onColumnChangedUpdateMappings(e.getColumnName(), table);
    }

    public void handleEvent(ColumnCreatedEvent e) {
        CyTable table = (CyTable)e.getSource();
        this.onColumnChangedUpdateMappings(e.getColumnName(), table);
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        CyTable table = (CyTable)e.getSource();
        this.onColumnChangedUpdateMappings(e.getOldColumnName(), table);
        this.onColumnChangedUpdateMappings(e.getNewColumnName(), table);
    }

    public void handleEvent(UpdateNetworkPresentationEvent e) {
        CyNetworkView view = (CyNetworkView)e.getSource();
        if (view.equals(this.vmProxy.getCurrentNetworkView())) {
            this.updateLockedValues(view);
        }
    }

    public void handleEvent(VisualMappingFunctionChangedEvent e) {
        VisualMappingFunction vm = (VisualMappingFunction)e.getSource();
        VisualProperty vp = vm.getVisualProperty();
        VisualStyleSet curStyleSet = this.vmProxy.getCurrentVisualStyleSet();
        if (curStyleSet != null) {
            for (VisualStyle style : curStyleSet.getAllStyles()) {
                VisualPropertySheetItem vpSheetItem;
                VisualPropertySheet vpSheet;
                if (!vm.equals(style.getVisualMappingFunction(vp)) || (vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(vp.getTargetDataType())) == null || (vpSheetItem = vpSheet.getItem(vp)) == null) continue;
                ViewUtil.invokeOnEDT(() -> vpSheetItem.updateMapping());
            }
        }
    }

    public VisualPropertySheetItem<?> getCurrentVisualPropertySheetItem() {
        return this.curVpSheetItem;
    }

    public VisualPropertySheet getSelectedVisualPropertySheet() {
        return this.vizMapperMainPanel.getSelectedVisualPropertySheet();
    }

    public VizMapperProperty<?, ?, ?> getCurrentVizMapperProperty() {
        return this.curVizMapperProperty;
    }

    public synchronized void onCyActionRegistered(CyAction action, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType != null && serviceType.startsWith("vizmapUI")) {
            ViewUtil.invokeOnEDT(() -> {
                JMenuItem menuItem = this.createMenuItem(action, properties);
                if (menuItem != null) {
                    this.actions.put(action, menuItem);
                }
            });
        }
    }

    public synchronized void onCyActionUnregistered(CyAction action, Map<?, ?> properties) {
        JMenuItem menuItem = this.actions.remove(action);
        if (menuItem != null) {
            ViewUtil.invokeOnEDT(() -> {
                this.vizMapperMainPanel.removeOption(menuItem);
                this.vizMapperMainPanel.removeContextMenuItem(menuItem);
            });
        }
    }

    public void onTaskFactoryRegistered(final TaskFactory taskFactory, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType == null || !serviceType.toString().startsWith("vizmapUI")) {
            return;
        }
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            logger.error("Cannot create VizMapper menu item for: " + taskFactory + "; \"title\" metadata is missing from properties: " + properties);
            return;
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("title", title.toString());
        AbstractCyAction action = new AbstractCyAction(config, taskFactory){

            public void actionPerformed(ActionEvent e) {
                new Thread(() -> VizMapperMediator.this.servicesUtil.get(DialogTaskManager.class).execute(taskFactory.createTaskIterator())).start();
            }
        };
        ViewUtil.invokeOnEDT(() -> this.lambda$onTaskFactoryRegistered$9(action, properties, taskFactory));
    }

    public void onTaskFactoryUnregistered(TaskFactory taskFactory, Map<?, ?> properties) {
        JMenuItem menuItem = this.taskFactories.remove(taskFactory);
        if (menuItem != null) {
            ViewUtil.invokeOnEDT(() -> {
                this.vizMapperMainPanel.removeOption(menuItem);
                this.vizMapperMainPanel.removeContextMenuItem(menuItem);
            });
        }
    }

    public void onMappingGeneratorRegistered(DiscreteMappingGenerator<?> generator, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType == null) {
            logger.error("Cannot create VizMapper context menu item for: " + generator + "; \"service.type\" metadata is missing from properties: " + properties);
            return;
        }
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            logger.error("Cannot create VizMapper context menu item for: " + generator + "; \"title\" metadata is missing from properties: " + properties);
            return;
        }
        GenerateDiscreteValuesAction action = new GenerateDiscreteValuesAction(title.toString(), generator, this.servicesUtil);
        this.vizMapperMainPanel.getContextMenu().addPopupMenuListener((PopupMenuListener)((Object)action));
        this.mappingGenerators.put(generator.getDataType().getSimpleName() + "::" + title.toString(), action);
    }

    public void onMappingGeneratorUnregistered(DiscreteMappingGenerator<?> generator, Map<?, ?> properties) {
        Iterator<Map.Entry<String, GenerateDiscreteValuesAction>> iter = this.mappingGenerators.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, GenerateDiscreteValuesAction> entry = iter.next();
            GenerateDiscreteValuesAction action = entry.getValue();
            if (!action.getGenerator().equals(generator)) continue;
            this.vizMapperMainPanel.getContextMenu().removePopupMenuListener((PopupMenuListener)((Object)action));
            iter.remove();
            break;
        }
    }

    private void updateDefaultProps() {
        this.defVisibleProps.clear();
        this.defVisibleProps.put(CyNode.class, this.propsProxy.getDefaultVisualProperties(CyNode.class));
        this.defVisibleProps.put(CyEdge.class, this.propsProxy.getDefaultVisualProperties(CyEdge.class));
        this.defVisibleProps.put(CyNetwork.class, this.propsProxy.getDefaultVisualProperties(CyNetwork.class));
        this.defVisibleProps.put(CyColumn.class, this.propsProxy.getDefaultVisualProperties(CyColumn.class));
    }

    private void initView() {
        this.servicesUtil.registerAllServices(this.vizMapperMainPanel, new Properties());
        this.addViewListeners();
    }

    private void addViewListeners() {
        VisualStylePanelProvider.VisualStyleDropDownButton stylesBtn = this.vizMapperMainPanel.getStylesBtn();
        stylesBtn.addPropertyChangeListener("selectedStyle", evt -> this.onSelectedVisualStyleChanged(evt));
        this.columnChangeListener = this::onColumnStylePickerAction;
        this.vizMapperMainPanel.getColumnStylePnl().addColumnSelectionListener(this.columnChangeListener);
    }

    private void addViewListeners(VisualPropertySheet vpSheet) {
        for (VisualPropertySheetItem<?> vpSheetItem : vpSheet.getAllItems()) {
            this.addViewListeners(vpSheet, vpSheetItem);
        }
    }

    private void addViewListeners(VisualPropertySheet vpSheet, final VisualPropertySheetItem<?> vpSheetItem) {
        if (vpSheetItem.getModel().getVisualPropertyDependency() == null) {
            vpSheetItem.getDefaultBtn().addActionListener(evt -> this.openDefaultValueEditor(evt, vpSheetItem));
            vpSheetItem.getDefaultBtn().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowContextMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowContextMenu(e);
                }

                private void maybeShowContextMenu(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu contextMenu = new JPopupMenu();
                        contextMenu.add(new JMenuItem(new AbstractAction("Reset Default Value"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                vpSheetItem.getModel().resetDefaultValue();
                            }
                        }));
                        VizMapperMediator.this.showContextMenu(contextMenu, e);
                    }
                }
            });
            if (vpSheetItem.getModel().isLockedValueAllowed()) {
                final JPopupMenu bypassMenu = new JPopupMenu();
                bypassMenu.add(new JMenuItem(new AbstractAction("Set Bypass..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VizMapperMediator.this.openLockedValueEditor(e, vpSheetItem);
                    }
                }));
                final JMenuItem removeBypassMenuItem = new JMenuItem(new AbstractAction("Remove Bypass"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VizMapperMediator.this.removeLockedValue(e, vpSheetItem);
                    }
                });
                bypassMenu.add(removeBypassMenuItem);
                vpSheetItem.getBypassBtn().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.maybeShowContextMenu(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.maybeShowContextMenu(e);
                    }

                    private void maybeShowContextMenu(MouseEvent e) {
                        if (vpSheetItem.getBypassBtn().isEnabled() && e.isPopupTrigger()) {
                            LockedValueState state = vpSheetItem.getModel().getLockedValueState();
                            removeBypassMenuItem.setEnabled(state != LockedValueState.ENABLED_NOT_SET);
                            VizMapperMediator.this.showContextMenu(bypassMenu, e);
                        }
                    }
                });
                vpSheetItem.getBypassBtn().addActionListener(evt -> {
                    LockedValueState state = vpSheetItem.getModel().getLockedValueState();
                    JButton btn = vpSheetItem.getBypassBtn();
                    if (state == LockedValueState.ENABLED_NOT_SET) {
                        this.openLockedValueEditor(evt, vpSheetItem);
                    } else {
                        bypassMenu.show(btn, 0, btn.getHeight());
                        bypassMenu.requestFocusInWindow();
                    }
                });
            }
            ContextMenuMouseListener cmMouseListener = new ContextMenuMouseListener(vpSheet, vpSheetItem);
            vpSheetItem.addMouseListener(cmMouseListener);
            if (vpSheetItem.getModel().isVisualMappingAllowed()) {
                vpSheetItem.getPropSheetPnl().getTable().addMouseListener((MouseListener)cmMouseListener);
                vpSheetItem.getRemoveMappingBtn().addActionListener(evt -> {
                    this.curVpSheetItem = vpSheetItem;
                    this.removeVisualMapping(vpSheetItem);
                });
                if (vpSheetItem.isNodeColumnColor()) {
                    vpSheetItem.getCopyNodeColorMappingBtn().addActionListener(evt -> {
                        this.curVpSheetItem = vpSheetItem;
                        this.copyNodeColumnColorMappingToTable(vpSheetItem);
                    });
                }
                vpSheetItem.getPropSheetTbl().addPropertyChangeListener("editingVizMapperProperty", evt -> {
                    this.curVpSheetItem = vpSheetItem;
                    this.curVizMapperProperty = (VizMapperProperty)((Object)((Object)evt.getNewValue()));
                    VizMapperProperty<String, VisualMappingFunctionFactory, VisualMappingFunction<?, ?>> mappingTypeProperty = this.vizMapPropertyBuilder.getMappingTypeProperty(vpSheetItem.getPropSheetPnl());
                    VisualMappingFunctionFactory factory = (VisualMappingFunctionFactory)mappingTypeProperty.getValue();
                    this.attrProxy.setCurrentMappingType(factory != null ? factory.getMappingFunctionType() : null);
                    VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> columnProp = this.vizMapPropertyBuilder.getColumnProperty(vpSheetItem.getPropSheetPnl());
                    Object columnValue = columnProp.getValue();
                    this.mappingFactoryProxy.setCurrentColumnName(columnValue != null ? columnValue.toString() : null);
                    this.mappingFactoryProxy.setCurrentTargetDataType(vpSheet.getModel().getTableType());
                });
            }
        } else {
            vpSheetItem.getDependencyCkb().addItemListener(evt -> this.onDependencySelectionChanged(evt, vpSheetItem));
        }
        vpSheetItem.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                VizMapperMediator.this.userProps.put(vpSheetItem.getModel().getId(), Boolean.TRUE);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                VizMapperMediator.this.userProps.put(vpSheetItem.getModel().getId(), Boolean.FALSE);
            }
        });
    }

    protected void removeVisualMapping(VisualPropertySheetItem<?> vpSheetItem) {
        VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
        if (model == null) {
            return;
        }
        VisualMappingFunction<?, ?> vm = model.getVisualMappingFunction();
        if (vm == null) {
            return;
        }
        RemoveVisualMappingsCommand.Body body = new RemoveVisualMappingsCommand.Body(model.getVisualStyle(), Set.of(vm));
        this.sendNotification("REMOVE_VISUAL_MAPPINGS", body);
    }

    protected void copyNodeColumnColorMappingToTable(VisualPropertySheetItem<?> vpSheetItem) {
        VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
        if (model == null) {
            return;
        }
        VisualStyle sourceStyle = this.vmProxy.getCurrentNetworkVisualStyle();
        VisualProperty sourceVP = BasicVisualLexicon.NODE_FILL_COLOR;
        VisualStyle targetStyle = model.getVisualStyle();
        VisualProperty targetVP = BasicTableVisualLexicon.CELL_BACKGROUND_PAINT;
        CopyContinuousMappingCommand.Body body = new CopyContinuousMappingCommand.Body(sourceStyle, sourceVP, targetStyle, targetVP);
        this.sendNotification("COPY_CONTINUOUS_MAPPING", body);
    }

    private void updateVisualStyleList(SortedSet<VisualStyle> styles, boolean resetDefaultVisibleItems) {
        this.attrProxy.setCurrentMappingType(null);
        this.mappingFactoryProxy.setCurrentColumnName(null);
        this.debounceTimer.debounce(() -> {
            VisualStyle vs = this.vmProxy.getCurrentNetworkVisualStyle();
            ViewUtil.invokeOnEDT(() -> {
                this.ignoreVisualStyleSelectedEvents = true;
                this.vizMapperMainPanel.updateVisualStyles(styles, vs);
                this.selectCurrentVisualStyle(vs);
                this.ignoreVisualStyleSelectedEvents = false;
                this.updateAllVisualPropertySheets(vs, resetDefaultVisibleItems);
            });
        });
    }

    private void selectCurrentVisualStyle(VisualStyle vs) {
        ViewUtil.invokeOnEDT(() -> {
            VisualStyle selectedVs = this.vizMapperMainPanel.getSelectedVisualStyle();
            ContinuousMappingEditorPanel.setTracer(new EditorValueRangeTracer(this.servicesUtil));
            if (vs != null && !vs.equals(selectedVs)) {
                this.vizMapperMainPanel.setSelectedVisualStyle(vs);
            }
        });
    }

    private void updateAllVisualPropertySheets(VisualStyle netVS, boolean resetDefaultVisibleItems) {
        boolean rebuild = this.shouldRebuildVisualPropertySheets(netVS);
        TableVisualMappingManager tableVMM = this.servicesUtil.get(TableVisualMappingManager.class);
        Map nodeColStyles = tableVMM.getAssociatedColumnVisualStyles(netVS, CyNode.class);
        Map edgeColStyles = tableVMM.getAssociatedColumnVisualStyles(netVS, CyEdge.class);
        ArrayList<ColumnSpec> colSpecs = new ArrayList<ColumnSpec>();
        for (Map.Entry entry : nodeColStyles.entrySet()) {
            colSpecs.add(new ColumnSpec(GraphObjectType.node(), (String)entry.getKey()));
        }
        for (Map.Entry entry : edgeColStyles.entrySet()) {
            colSpecs.add(new ColumnSpec(GraphObjectType.edge(), (String)entry.getKey()));
        }
        colSpecs.sort(ColumnSpec.comparingName());
        if (colSpecs.isEmpty()) {
            this.selectedColumn = new ColumnSpec(GraphObjectType.node(), "shared name");
            colSpecs.add(this.selectedColumn);
            this.getOrCreateAssociatedColumnStyleForCurrentNetwork(this.selectedColumn);
        } else if (this.selectedColumn == null) {
            this.selectedColumn = (ColumnSpec)colSpecs.get(0);
        }
        VisualStyle colVS = tableVMM.getAssociatedColumnVisualStyle(netVS, this.selectedColumn.tableType().type(), this.selectedColumn.columnName());
        this.updateVisualPropertySheets(netVS, NETWORK_SHEET_TYPES, resetDefaultVisibleItems, rebuild);
        this.updateVisualPropertySheets(colVS, TABLE_SHEET_TYPES, resetDefaultVisibleItems, true);
        this.vizMapperMainPanel.getColumnStylePnl().removeColumnSelectionListener(this.columnChangeListener);
        this.vizMapperMainPanel.updateColumns(colSpecs, this.selectedColumn);
        this.vizMapperMainPanel.getColumnStylePnl().addColumnSelectionListener(this.columnChangeListener);
    }

    private void updateColumnPickerWarnings() {
        this.vizMapperMainPanel.updateColumnPickerWarnings();
    }

    private void onColumnStylePickerAction(ColumnSpec col, ColumnStylePicker.Action action) {
        if (col == null || action == null) {
            return;
        }
        ContinuousMappingEditorPanel.setTracer(new EditorValueRangeTracer(this.servicesUtil));
        VisualStyle netVS = this.vmProxy.getCurrentNetworkVisualStyle();
        TableVisualMappingManager tableVMM = this.servicesUtil.get(TableVisualMappingManager.class);
        Class<? extends CyIdentifiable> tableType = col.tableType().type();
        if (action == ColumnStylePicker.Action.CREATE) {
            this.selectedColumn = col;
            this.getOrCreateAssociatedColumnStyleForCurrentNetwork(col);
        } else if (action == ColumnStylePicker.Action.DELETE) {
            this.selectedColumn = null;
            tableVMM.setAssociatedVisualStyle(netVS, tableType, col.columnName(), null);
        } else {
            this.selectedColumn = col;
            VisualStyle colVS = tableVMM.getAssociatedColumnVisualStyle(netVS, tableType, col.columnName());
            this.updateVisualPropertySheets(colVS, TABLE_SHEET_TYPES, false, true);
        }
    }

    private VisualStyle getOrCreateAssociatedColumnStyleForCurrentNetwork(ColumnSpec col) {
        Class<? extends CyIdentifiable> tableType = col.tableType().type();
        VisualStyle netVS = this.vmProxy.getCurrentNetworkVisualStyle();
        TableVisualMappingManager tableVMM = this.servicesUtil.get(TableVisualMappingManager.class);
        VisualStyle colVS = tableVMM.getAssociatedColumnVisualStyle(netVS, tableType, col.columnName());
        if (colVS == null) {
            VisualStyleFactory visualStyleFactory = this.servicesUtil.get(VisualStyleFactory.class);
            colVS = visualStyleFactory.createVisualStyle(tableVMM.getDefaultVisualStyle());
            colVS.setTitle(UUID.randomUUID().toString());
            tableVMM.setAssociatedVisualStyle(netVS, tableType, col.columnName(), colVS);
        }
        return colVS;
    }

    private void updateColumnAssociation(StyleAssociation association) {
        VisualStyle netVS = association.networkVisualStyle();
        if (netVS == this.vmProxy.getCurrentNetworkVisualStyle()) {
            this.updateAllVisualPropertySheets(netVS, false);
        }
    }

    private void updateVisualPropertySheets(VisualStyle vs, List<Class<? extends CyIdentifiable>> sheetTypes, boolean resetDefaultVisibleItems, boolean rebuild) {
        if (vs == null) {
            return;
        }
        if (!rebuild) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Set dependencies = vs.getAllVisualPropertyDependencies();
            for (Object dep : dependencies) {
                Class type = dep.getParentVisualProperty().getTargetDataType();
                VisualPropertySheet sheet = this.vizMapperMainPanel.getVisualPropertySheet(type);
                if (sheet == null) continue;
                if (sheet.getItem(dep) == null) {
                    rebuild = true;
                    break;
                }
                map.put(dep.getIdString(), dep);
            }
            if (!rebuild) {
                Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
                block1: for (VisualPropertySheet sheet : vpSheets) {
                    for (VisualPropertySheetItem visualPropertySheetItem : sheet.getAllItems()) {
                        VisualPropertyDependency dep = visualPropertySheetItem.getModel().getVisualPropertyDependency();
                        if (dep == null || map.containsKey(dep.getIdString())) continue;
                        rebuild = true;
                        continue block1;
                    }
                }
            }
        }
        if (rebuild) {
            this.createVisualPropertySheets(vs, sheetTypes, resetDefaultVisibleItems);
        } else {
            Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
            for (VisualPropertySheet sheet : vpSheets) {
                List<VisualPropertySheetItem<?>> visibleList = sheet.getAllItems(false);
                for (VisualPropertySheetItem<?> item : sheet.getAllItems()) {
                    VisualPropertySheetItemModel<?> visualPropertySheetItemModel = item.getModel();
                    RenderingEngine<?> re = this.vmProxy.getRenderingEngine(visualPropertySheetItemModel.getLexiconType());
                    visualPropertySheetItemModel.update(re);
                    if (visualPropertySheetItemModel.getVisualPropertyDependency() != null) {
                        item.update();
                    }
                    if (visualPropertySheetItemModel.getVisualMappingFunction() == null) continue;
                    visibleList.add(item);
                }
                sheet.setVisibleItems(visibleList);
            }
            if (resetDefaultVisibleItems) {
                this.updateVisibleItems(resetDefaultVisibleItems);
            }
        }
    }

    private boolean shouldRebuildVisualPropertySheets(VisualStyle vs) {
        boolean rebuild;
        VisualPropertySheet curNetSheet = this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class);
        VisualPropertySheetModel curModel = curNetSheet != null ? curNetSheet.getModel() : null;
        VisualStyle curStyle = curModel != null ? curModel.getVisualStyle() : null;
        CyNetworkView curNetView = this.vmProxy.getCurrentNetworkView();
        String newRendererId = curNetView != null ? curNetView.getRendererId() : "";
        boolean bl = rebuild = !vs.equals(curStyle) || !newRendererId.equals(this.curRendererId);
        if (curNetView != null) {
            this.curRendererId = curNetView.getRendererId();
        }
        return rebuild;
    }

    public VisualLexicon getCurrentVisualLexicon(VisualProperty<?> vp) {
        Class type = vp.getTargetDataType();
        RenderingEngine<?> re = this.vmProxy.getRenderingEngine(type);
        if (re == null) {
            return this.getDefaultVisualLexicon(vp);
        }
        return re.getVisualLexicon();
    }

    private VisualLexicon getDefaultVisualLexicon(VisualProperty<?> vp) {
        Class type = vp.getTargetDataType();
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        if (type == CyNode.class || type == CyEdge.class || type == CyNetwork.class) {
            return appMgr.getDefaultNetworkViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
        }
        return appMgr.getDefaultTableViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
    }

    private void createVisualPropertySheets(VisualStyle style, List<Class<? extends CyIdentifiable>> sheetTypes, boolean resetDefaultVisibleItems) {
        ViewUtil.invokeOnEDT(() -> {
            VisualPropertySheet selVpSheet = this.getSelectedVisualPropertySheet();
            Class<CyNode> selectedTargetDataType = selVpSheet != null ? selVpSheet.getModel().getLexiconType() : CyNode.class;
            for (Object lexiconType : sheetTypes) {
                JMenuItem mi;
                VisualLexicon lexicon = this.vmProxy.getCurrentLexicon((Class<? extends CyIdentifiable>)lexiconType);
                GraphObjectType tableType = lexiconType == CyColumn.class ? (this.selectedColumn == null ? GraphObjectType.node() : this.selectedColumn.tableType()) : GraphObjectType.of((Class<? extends CyIdentifiable>)lexiconType);
                VisualPropertySheetModel model = new VisualPropertySheetModel((Class<? extends CyIdentifiable>)lexiconType, tableType, style, lexicon);
                VisualPropertySheet vpSheet = new VisualPropertySheet(model, this.servicesUtil);
                this.vizMapperMainPanel.addVisualPropertySheet(vpSheet);
                this.vizMapperMainPanel.setSelectedVisualPropertySheet(vpSheet);
                Set<VisualPropertySheetItem<?>> vpSheetItems = this.createVisualPropertySheetItems((Class<? extends CyIdentifiable>)lexiconType, tableType, lexicon, style);
                vpSheet.setItems(vpSheetItems);
                this.addViewListeners(vpSheet);
                if (vpSheetItems.size() > 1) {
                    vpSheet.getVpsMenu().add(new JSeparator());
                    mi = new JMenuItem("Show Default");
                    mi.addActionListener(evt -> this.showDefaultItems(vpSheet));
                    vpSheet.getVpsMenu().add(mi);
                    mi = new JMenuItem("Show All");
                    mi.addActionListener(evt -> this.setAllItemsVisible(vpSheet, true));
                    vpSheet.getVpsMenu().add(mi);
                    mi = new JMenuItem("Hide All");
                    mi.addActionListener(evt -> this.setAllItemsVisible(vpSheet, false));
                    vpSheet.getVpsMenu().add(mi);
                }
                vpSheet.getVpsMenu().add(new JSeparator());
                mi = new JMenuItem("Make Default");
                mi.addActionListener(evt -> this.saveDefaultVisibleItems(vpSheet));
                vpSheet.getVpsMenu().add(mi);
            }
            this.updateVisibleItems(resetDefaultVisibleItems);
            this.updateItemsStatus();
            int minWidth = 200;
            for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
                minWidth = Math.max(minWidth, vpSheet.getMinimumSize().width);
            }
            this.vizMapperMainPanel.setPreferredSize(new Dimension(this.vizMapperMainPanel.getPropertiesPnl().getComponent().getMinimumSize().width + 20, this.vizMapperMainPanel.getPreferredSize().height));
            VisualPropertySheet vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(selectedTargetDataType);
            this.vizMapperMainPanel.setSelectedVisualPropertySheet(vpSheet);
        });
    }

    private Set<VisualPropertySheetItem<?>> createVisualPropertySheetItems(Class<? extends CyIdentifiable> lexiconType, GraphObjectType tableType, VisualLexicon lexicon, VisualStyle style) {
        VisualPropertySheetItem sheetItem;
        HashSet items = new HashSet();
        if (lexicon == null || style == null) {
            return items;
        }
        Collection vpList = lexicon.getAllDescendants(this.getRootVP(lexiconType));
        Object engine = this.vmProxy.getRenderingEngine(lexiconType);
        if (engine == null) {
            engine = lexiconType == CyNode.class || lexiconType == CyEdge.class || lexiconType == CyNetwork.class ? this.vizMapperMainPanel.getRenderingEngine() : this.vmProxy.getDummyTableRenderingEngine();
        }
        for (VisualProperty vp : vpList) {
            if (vp.getTargetDataType() != lexiconType || vp instanceof DefaultVisualizableVisualProperty || !VizMapperProxy.isSupported(lexicon, vp)) continue;
            VisualPropertySheetItemModel model = new VisualPropertySheetItemModel(vp, tableType, (Class<CyIdentifiable>)lexiconType, style, (RenderingEngine<?>)engine, lexicon);
            if (vp.getTargetDataType() == CyNode.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set selectedNodeViews = this.vmProxy.getSelectedNodeViews(curNetView);
                values = this.getDistinctLockedValues(vp, selectedNodeViews);
                this.updateVpInfoLockedState(model, values, selectedNodeViews);
            } else if (vp.getTargetDataType() == CyEdge.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set selectedEdgeViews = this.vmProxy.getSelectedEdgeViews(curNetView);
                values = this.getDistinctLockedValues(vp, selectedEdgeViews);
                this.updateVpInfoLockedState(model, values, selectedEdgeViews);
            } else if (vp.getTargetDataType() == CyNetwork.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set<CyNetworkView> selectedNetViews = curNetView != null ? Collections.singleton(curNetView) : Collections.EMPTY_SET;
                values = this.getDistinctLockedValues(vp, selectedNetViews);
                this.updateVpInfoLockedState(model, values, selectedNetViews);
            }
            sheetItem = new VisualPropertySheetItem(model, this.vizMapPropertyBuilder, this.servicesUtil);
            items.add(sheetItem);
            if (model.isVisualMappingAllowed()) {
                sheetItem.getPropSheetPnl().addPropertySheetChangeListener(evt -> {
                    if (evt.getPropertyName().equals("value") && evt.getSource() instanceof VizMapperProperty) {
                        this.updateMappingStatus(sheetItem);
                    }
                });
            }
            model.addPropertyChangeListener("defaultValue", evt -> {
                VisualStyle vs = model.getVisualStyle();
                vs.setDefaultValue(vp, evt.getNewValue());
            });
            model.addPropertyChangeListener("visualMappingFunction", evt -> {
                VisualStyle vs = model.getVisualStyle();
                if (evt.getNewValue() == null && vs.getVisualMappingFunction(vp) != null) {
                    vs.removeVisualMappingFunction(vp);
                } else if (evt.getNewValue() != null && !evt.getNewValue().equals(vs.getVisualMappingFunction(vp))) {
                    vs.addVisualMappingFunction((VisualMappingFunction)evt.getNewValue());
                }
                this.updateMappingStatus(sheetItem);
            });
        }
        Set dependencies = style.getAllVisualPropertyDependencies();
        for (VisualPropertyDependency dep : dependencies) {
            if (dep.getParentVisualProperty().getTargetDataType() != lexiconType || !VizMapperProxy.isSupported(lexicon, dep)) continue;
            VisualPropertySheetItemModel model = new VisualPropertySheetItemModel(dep, style, tableType, (Class<CyIdentifiable>)lexiconType, (RenderingEngine<?>)engine, lexicon);
            sheetItem = new VisualPropertySheetItem(model, this.vizMapPropertyBuilder, this.servicesUtil);
            items.add(sheetItem);
        }
        return items;
    }

    private void updateItemsStatus() {
        HashSet<VisualProperty> disabled = new HashSet<VisualProperty>();
        HashMap<VisualProperty, String> messages = new HashMap<VisualProperty, String>();
        VisualStyle style = this.vmProxy.getCurrentNetworkVisualStyle();
        String infoMsgTemplate = "<html>To enable this visual property,<br><b>%s</b> the dependency <i><b>%s</b></i></html>";
        for (VisualPropertyDependency dep : style.getAllVisualPropertyDependencies()) {
            VisualProperty parent = dep.getParentVisualProperty();
            Set properties = dep.getVisualProperties();
            if (dep.isDependencyEnabled()) {
                disabled.addAll(properties);
                for (VisualProperty vp : properties) {
                    messages.put(vp, String.format(infoMsgTemplate, "uncheck", dep.getDisplayName()));
                }
                continue;
            }
            disabled.add(parent);
            messages.put(parent, String.format(infoMsgTemplate, "check", dep.getDisplayName()));
        }
        for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
            List<VisualPropertySheetItem<?>> vpSheetItems = vpSheet.getAllItems();
            for (VisualPropertySheetItem<?> item : vpSheetItems) {
                String msg = null;
                VisualPropertySheetItem.MessageType msgType = null;
                if (msgType == null && item.getModel().getVisualPropertyDependency() == null) {
                    item.setEnabled(!disabled.contains(item.getModel().getVisualProperty()));
                    msg = (String)messages.get(item.getModel().getVisualProperty());
                    msgType = item.isEnabled() ? null : VisualPropertySheetItem.MessageType.INFO;
                }
                item.setMessage(msg, msgType);
                this.updateMappingStatus(item);
            }
        }
    }

    private void updateVisibleItems(boolean reset) {
        if (reset) {
            this.userProps.clear();
        }
        for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
            ArrayList visibleList = new ArrayList();
            for (VisualPropertySheetItem<?> item : vpSheet.getAllItems()) {
                Set<String> set = this.defVisibleProps.get(item.getModel().getTargetDataType());
                String vpId = item.getModel().getId();
                boolean b = set != null && set.contains(vpId) && !Boolean.FALSE.equals(this.userProps.get(vpId));
                b = b || item.getModel().getVisualMappingFunction() != null;
                if (!(b = b || Boolean.TRUE.equals(this.userProps.get(vpId)))) continue;
                visibleList.add(item);
            }
            vpSheet.setVisibleItems(visibleList);
        }
    }

    private void setAllItemsVisible(VisualPropertySheet vpSheet, boolean visible) {
        this.userProps.clear();
        if (visible) {
            vpSheet.setVisibleItems(vpSheet.getAllItems());
        } else {
            vpSheet.setVisibleItems(Collections.emptyList());
        }
    }

    private void showDefaultItems(VisualPropertySheet vpSheet) {
        this.userProps.clear();
        ArrayList visibleList = new ArrayList();
        for (VisualPropertySheetItem<?> item : vpSheet.getAllItems()) {
            Set<String> set = this.defVisibleProps.get(item.getModel().getTargetDataType());
            String vpId = item.getModel().getId();
            boolean b = set != null && set.contains(vpId);
            if (!(b = b || item.getModel().getVisualMappingFunction() != null)) continue;
            visibleList.add(item);
        }
        vpSheet.setVisibleItems(visibleList);
    }

    private void saveDefaultVisibleItems(VisualPropertySheet vpSheet) {
        HashSet<String> idSet = new HashSet<String>();
        for (VisualPropertySheetItem<?> item : vpSheet.getAllItems(false)) {
            idSet.add(item.getModel().getId());
        }
        this.propsProxy.setDefaultVisualProperties(vpSheet.getModel().getLexiconType(), idSet);
        this.updateDefaultProps();
    }

    private void updateMappings(Class<? extends CyIdentifiable> targetDataType, CyTable table) {
        VisualPropertySheet vpSheet;
        if (table != null && (vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(targetDataType)) != null) {
            Collection columns = table.getColumns();
            HashMap<String, Class> colTypes = new HashMap<String, Class>();
            for (CyColumn cyColumn : columns) {
                colTypes.put(cyColumn.getName().toLowerCase(), cyColumn.getType());
            }
            for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getAllItems()) {
                Class colType;
                VisualMappingFunction mapping = visualPropertySheetItem.getModel().getVisualMappingFunction();
                if (!(mapping instanceof DiscreteMapping) && !(mapping instanceof ContinuousMapping) || (colType = (Class)colTypes.get(mapping.getMappingColumnName().toLowerCase())) == null || !mapping.getMappingColumnType().isAssignableFrom(colType)) continue;
                ViewUtil.invokeOnEDT(() -> item.updateMapping());
            }
        }
    }

    private void updateMappingStatus(VisualPropertySheetItem<?> item) {
        if (!item.isEnabled()) {
            return;
        }
        Class<CyIdentifiable> lexiconType = item.getModel().getLexiconType();
        GraphObjectType tableType = item.getModel().getTableType();
        if (lexiconType != CyNetwork.class) {
            String msg = null;
            VisualPropertySheetItem.MessageType msgType = null;
            CyTable table = this.getCurrentMappingTable(tableType);
            if (table != null) {
                String colName;
                VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> columnProp = this.vizMapPropertyBuilder.getColumnProperty(item.getPropSheetPnl());
                String string = colName = columnProp != null && columnProp.getValue() != null ? columnProp.getValue().toString() : null;
                if (colName != null) {
                    Class<String> colType;
                    VisualMappingFunction<?, ?> mapping = item.getModel().getVisualMappingFunction();
                    Class<String> mapColType = mapping != null ? mapping.getMappingColumnType() : null;
                    CyColumn column = table.getColumn(colName);
                    Class<String> clazz = colType = column != null ? column.getType() : null;
                    if (mapColType == List.class) {
                        mapColType = String.class;
                    }
                    if (colType == List.class) {
                        colType = String.class;
                    }
                    if (column == null || mapColType != null && !mapColType.isAssignableFrom(colType)) {
                        String tableName = table != null ? tableType.type().getSimpleName().replace("Cy", "") : null;
                        msg = "<html>Visual Mapping cannot be applied to current network:<br>" + tableName + " table does not have column <b>\"" + colName + "\"</b>" + (String)(mapColType != null ? " (" + mapColType.getSimpleName() + ")" : "") + "</html>";
                        msgType = VisualPropertySheetItem.MessageType.WARNING;
                    }
                }
            }
            String finalMsg = msg;
            VisualPropertySheetItem.MessageType finalMsgType = msgType;
            ViewUtil.invokeOnEDT(() -> item.setMessage(finalMsg, finalMsgType));
        }
    }

    private void updateLockedValues(CyNetworkView currentView) {
        if (currentView != null) {
            this.updateLockedValues(Collections.singleton(currentView), CyNetwork.class);
            this.updateLockedValues(this.vmProxy.getSelectedNodeViews(currentView), CyNode.class);
            this.updateLockedValues(this.vmProxy.getSelectedEdgeViews(currentView), CyEdge.class);
        } else {
            this.updateLockedValues(Collections.EMPTY_SET, CyNetwork.class);
        }
    }

    private <S extends CyIdentifiable> void updateLockedValues(Set<View<S>> selectedViews, Class<S> targetDataType) {
        ViewUtil.invokeOnEDT(() -> {
            Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
            for (VisualPropertySheet sheet : vpSheets) {
                List<VisualPropertySheetItem<?>> vpItems = sheet.getAllItems();
                for (VisualPropertySheetItem<?> item : vpItems) {
                    VisualPropertySheetItemModel<?> model = item.getModel();
                    if (model.getTargetDataType() != targetDataType) continue;
                    Set<?> values = this.getDistinctLockedValues(model.getVisualProperty(), selectedViews);
                    this.updateVpInfoLockedState(model, values, selectedViews);
                }
            }
        });
    }

    private <T, S extends CyIdentifiable> void updateVpInfoLockedState(VisualPropertySheetItemModel<T> model, Set<T> lockedValues, Set<View<S>> selectedViews) {
        Object value = null;
        LockedValueState state = LockedValueState.DISABLED;
        if (lockedValues.size() == 1) {
            value = lockedValues.iterator().next();
            state = value == null ? LockedValueState.ENABLED_NOT_SET : LockedValueState.ENABLED_UNIQUE_VALUE;
        } else if (lockedValues.size() > 1) {
            state = LockedValueState.ENABLED_MULTIPLE_VALUES;
        }
        model.setLockedValue(value);
        model.setLockedValueState(state);
    }

    private <T, S extends CyIdentifiable> Set<T> getDistinctLockedValues(VisualProperty<T> vp, Set<View<S>> views) {
        HashSet<Object> values = new HashSet<Object>();
        for (View<S> view : views) {
            if (view == null) continue;
            if (view.isValueLocked(vp)) {
                values.add(view.getVisualProperty(vp));
            } else {
                values.add(null);
            }
            if (values.size() <= 1) continue;
            break;
        }
        return values;
    }

    private JMenuItem createMenuItem(CyAction action, Map<?, ?> properties) {
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            title = action.getName();
        }
        if (title == null) {
            logger.error("Cannot create VizMapper menu item for: " + action + "; \"title\" metadata is missing from properties: " + properties);
            return null;
        }
        JMenuItem menuItem = new JMenuItem((Action)action);
        menuItem.setText(title);
        double gravity = ServicePropertiesUtil.getGravity(properties);
        boolean insertSeparatorBefore = ServicePropertiesUtil.getInsertSeparatorBefore(properties);
        boolean insertSeparatorAfter = ServicePropertiesUtil.getInsertSeparatorAfter(properties);
        String menuId = ServicePropertiesUtil.getString(properties, "menu", "");
        if (menuId.equals("context")) {
            this.vizMapperMainPanel.addContextMenuItem(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        } else if (menuId.equals("table")) {
            this.vizMapperMainPanel.addTableOption(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        } else {
            this.vizMapperMainPanel.addOption(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        }
        return menuItem;
    }

    private void openDefaultValueEditor(ActionEvent evt, VisualPropertySheetItem vpSheetItem) {
        VisualPropertySheetItemModel model = vpSheetItem.getModel();
        final VisualProperty vp = model.getVisualProperty();
        final VisualStyle style = vpSheetItem.getModel().getVisualStyle();
        final Object oldValue = style.getDefaultValue(vp);
        Object val = null;
        try {
            EditorManager editorMgr = this.servicesUtil.get(EditorManager.class);
            val = editorMgr.showVisualPropertyValueEditor(this.vizMapperMainPanel, vp, oldValue);
        }
        catch (Exception ex) {
            logger.error("Error opening Visual Property values editor for: " + vp, (Throwable)ex);
        }
        final Object newValue = val;
        if (newValue != null && !newValue.equals(oldValue)) {
            style.setDefaultValue(vp, newValue);
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit(new AbstractCyEdit("Set Default Value"){

                public void undo() {
                    style.setDefaultValue(vp, oldValue);
                }

                public void redo() {
                    style.setDefaultValue(vp, newValue);
                }
            });
        }
    }

    private void openLockedValueEditor(ActionEvent evt, VisualPropertySheetItem vpSheetItem) {
        VisualPropertySheetItemModel model = vpSheetItem.getModel();
        VisualProperty vp = model.getVisualProperty();
        Object curValue = model.getLockedValue();
        Object newValue = null;
        try {
            EditorManager editorMgr = this.servicesUtil.get(EditorManager.class);
            newValue = editorMgr.showVisualPropertyValueEditor(this.vizMapperMainPanel, vp, curValue);
        }
        catch (Exception editorMgr) {
            // empty catch block
        }
        if (newValue != null && !newValue.equals(curValue)) {
            LockedValuesVO vo = new LockedValuesVO(Collections.singletonMap(vp, newValue));
            this.sendNotification("SET_LOCKED_VALUES", vo);
        }
    }

    private void removeLockedValue(ActionEvent e, VisualPropertySheetItem<?> vpSheetItem) {
        VisualProperty<?> visualProperty = vpSheetItem.getModel().getVisualProperty();
        LockedValuesVO vo = new LockedValuesVO(Collections.singleton(visualProperty));
        this.sendNotification("REMOVE_LOCKED_VALUES", vo);
    }

    private void onSelectedVisualStyleChanged(PropertyChangeEvent e) {
        VisualStyle oldStyle;
        if (this.ignoreVisualStyleSelectedEvents) {
            return;
        }
        final VisualStyle newStyle = (VisualStyle)e.getNewValue();
        if (!Objects.equals(newStyle, oldStyle = this.vmProxy.getCurrentNetworkVisualStyle())) {
            new Thread(() -> {
                this.vmProxy.setCurrentNetworkVisualStyle(newStyle);
                UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
                undo.postEdit(new AbstractCyEdit("Set Current Style"){

                    public void undo() {
                        VizMapperMediator.this.vmProxy.setCurrentNetworkVisualStyle(oldStyle);
                    }

                    public void redo() {
                        VizMapperMediator.this.vmProxy.setCurrentNetworkVisualStyle(newStyle);
                    }
                });
            }).start();
        }
    }

    private void onDependencySelectionChanged(ItemEvent e, VisualPropertySheetItem<?> vpSheetItem) {
        boolean selected = e.getStateChange() == 1;
        VisualPropertyDependency<?> dep = vpSheetItem.getModel().getVisualPropertyDependency();
        dep.setDependency(selected);
        ViewUtil.invokeOnEDT(() -> this.updateItemsStatus());
    }

    private void onColumnChangedUpdateMappings(String colName, CyTable tbl) {
        CyNetwork curNet = this.vmProxy.getCurrentNetwork();
        if (curNet == null) {
            return;
        }
        ArrayList<VisualPropertySheet> vpSheets = new ArrayList<VisualPropertySheet>(2);
        if (tbl.equals(curNet.getDefaultEdgeTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyEdge.class));
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
        } else if (tbl.equals(curNet.getDefaultNodeTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNode.class));
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
        } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class));
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
        }
        if (vpSheets != null && !vpSheets.isEmpty()) {
            for (VisualPropertySheet vpSheet : vpSheets) {
                if (vpSheet == null) continue;
                for (VisualPropertySheetItem<?> item : vpSheet.getAllItems()) {
                    VisualMappingFunction<?, ?> mapping = item.getModel().getVisualMappingFunction();
                    if (mapping == null || !mapping.getMappingColumnName().equalsIgnoreCase(colName)) continue;
                    this.updateMappingStatus(item);
                }
            }
        }
    }

    private void showContextMenu(JPopupMenu contextMenu, MouseEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            Component parent = (Component)e.getSource();
            contextMenu.show(parent, e.getX(), e.getY());
        });
    }

    private /* synthetic */ void lambda$onTaskFactoryRegistered$9(1 action, Map properties, TaskFactory taskFactory) {
        JMenuItem menuItem = this.createMenuItem((CyAction)action, properties);
        if (menuItem != null) {
            this.taskFactories.put(taskFactory, menuItem);
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private VisualPropertySheet vpSheet;
        private VisualPropertySheetItem<?> vpSheetItem;

        ContextMenuMouseListener(VisualPropertySheet vpSheet, VisualPropertySheetItem<?> vpSheetItem) {
            this.vpSheet = vpSheet;
            this.vpSheetItem = vpSheetItem;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowContextMenu(e, this.vpSheet, this.vpSheetItem);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowContextMenu(e, this.vpSheet, this.vpSheetItem);
        }

        private void maybeShowContextMenu(MouseEvent e, VisualPropertySheet vpSheet, VisualPropertySheetItem<?> vpSheetItem) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (!vpSheetItem.isSelected()) {
                vpSheet.setSelectedItems(Collections.singleton(vpSheetItem));
            }
            JPopupMenu contextMenu = VizMapperMediator.this.vizMapperMainPanel.getContextMenu();
            ViewUtil.invokeOnEDT(() -> {
                JMenu mapValueGeneratorsMenu = VizMapperMediator.this.vizMapperMainPanel.getMapValueGeneratorsSubMenu();
                Class<? extends CyIdentifiable> targetDataType = vpSheet.getModel().getLexiconType();
                mapValueGeneratorsMenu.setVisible(targetDataType != CyNetwork.class);
                if (mapValueGeneratorsMenu.isVisible()) {
                    mapValueGeneratorsMenu.removeAll();
                    Class<?> dataType = null;
                    for (Map.Entry<String, GenerateDiscreteValuesAction> entry : VizMapperMediator.this.mappingGenerators.entrySet()) {
                        if (dataType != null && dataType != entry.getValue().getGenerator().getDataType()) {
                            mapValueGeneratorsMenu.add(new JSeparator());
                        }
                        mapValueGeneratorsMenu.add((Action)((Object)entry.getValue()));
                        dataType = entry.getValue().getGenerator().getDataType();
                    }
                }
                VizMapperMediator.this.showContextMenu(contextMenu, e);
            });
        }
    }
}

