/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.DefaultViewEditor;
import org.cytoscape.view.vizmap.gui.DefaultViewPanel;
import org.cytoscape.view.vizmap.gui.VizMapGUI;
import org.cytoscape.view.vizmap.gui.internal.ColumnSpec;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.BiModalJSplitPane;
import org.cytoscape.view.vizmap.gui.internal.view.ColumnStylePicker;
import org.cytoscape.view.vizmap.gui.internal.view.PropertySheetPanel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetContainer;
import org.cytoscape.view.vizmap.gui.internal.view.VisualStylePanelProvider;

public class VizMapperMainPanel
extends JPanel
implements VizMapGUI,
DefaultViewPanel,
DefaultViewEditor,
CytoPanelComponent2,
VisualPropertySheetContainer {
    private static final String TITLE = "Style";
    private static final String ID = "org.cytoscape.Style";
    private TextIcon icon;
    private final ServicesUtil servicesUtil;
    private VisualStylePanelProvider visualStylePanel;
    private ColumnStylePicker columnStylePanel;
    private PropertySheetPanel propertySheetPanel;
    private JPanel defViewPanel = new JPanel();

    public VizMapperMainPanel(ServicesUtil servicesUtil) {
        this.servicesUtil = Objects.requireNonNull(servicesUtil, "'servicesUtil' must not be null");
        this.init();
    }

    public String getTitle() {
        return TITLE;
    }

    public String getIdentifier() {
        return ID;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("\uf1fc", this.servicesUtil.get(IconManager.class).getIconFont(14.0f), 16, 16);
        }
        return this.icon;
    }

    @Override
    @Deprecated
    public JPanel getDefaultViewPanel() {
        return this.defViewPanel;
    }

    @Override
    @Deprecated
    public DefaultViewEditor getDefaultViewEditor() {
        return this;
    }

    @Override
    @Deprecated
    public RenderingEngine<CyNetwork> getRenderingEngine() {
        return this.getStylesBtn().getRenderingEngine(this.getSelectedVisualStyle());
    }

    VisualStylePanelProvider getStylesPanelProvider() {
        if (this.visualStylePanel == null) {
            this.visualStylePanel = new VisualStylePanelProvider(this.servicesUtil);
        }
        return this.visualStylePanel;
    }

    ColumnStylePicker getColumnStylePnl() {
        if (this.columnStylePanel == null) {
            this.columnStylePanel = new ColumnStylePicker(this.servicesUtil);
        }
        return this.columnStylePanel;
    }

    PropertySheetPanel getPropertiesPnl() {
        if (this.propertySheetPanel == null) {
            this.propertySheetPanel = new PropertySheetPanel(this.servicesUtil);
        }
        return this.propertySheetPanel;
    }

    @Override
    @Deprecated
    public Component getDefaultView(VisualStyle vs) {
        return this.getStylesPanelProvider().getDefaultView(vs);
    }

    @Override
    @Deprecated
    public void showEditor(Component parent) {
    }

    VisualStylePanelProvider.VisualStyleDropDownButton getStylesBtn() {
        return this.getStylesPanelProvider().getStylesBtn();
    }

    public VisualStyle getSelectedVisualStyle() {
        return this.getStylesPanelProvider().getSelectedVisualStyle();
    }

    public void setSelectedVisualStyle(VisualStyle style) {
        this.getStylesPanelProvider().setSelectedVisualStyle(style);
    }

    public void removeContextMenuItem(JMenuItem menuItem) {
        this.getPropertiesPnl().removeContextMenuItem(menuItem);
    }

    public void updateVisualStyles(SortedSet<VisualStyle> styles, VisualStyle selectedStyle) {
        this.getStylesPanelProvider().updateVisualStyles(styles, selectedStyle);
    }

    @Override
    public VisualPropertySheet getVisualPropertySheet(Class<? extends CyIdentifiable> targetDataType) {
        return this.getPropertiesPnl().getVisualPropertySheet(targetDataType);
    }

    @Override
    public VisualPropertySheet getSelectedVisualPropertySheet() {
        return this.getPropertiesPnl().getSelectedVisualPropertySheet();
    }

    @Override
    public JPopupMenu getContextMenu() {
        return this.getPropertiesPnl().getContextMenu();
    }

    @Override
    public Set<VisualPropertySheet> getVisualPropertySheets() {
        return this.getPropertiesPnl().getVisualPropertySheets();
    }

    @Override
    public void addVisualPropertySheet(VisualPropertySheet sheet) {
        this.getPropertiesPnl().addVisualPropertySheet(sheet);
    }

    @Override
    public void setSelectedVisualPropertySheet(VisualPropertySheet sheet) {
        this.getPropertiesPnl().setSelectedVisualPropertySheet(sheet);
    }

    @Override
    public JMenu getMapValueGeneratorsSubMenu() {
        return this.getPropertiesPnl().getMapValueGeneratorsSubMenu();
    }

    public void addOption(JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        this.getStylesPanelProvider().getOptionsBtn().addOption(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
    }

    public void removeOption(JMenuItem menuItem) {
        this.getStylesPanelProvider().getOptionsBtn().removeOption(menuItem);
    }

    public void addTableOption(JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
    }

    public void removeTableOption(JMenuItem menuItem) {
    }

    public void addContextMenuItem(JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        this.getPropertiesPnl().addContextMenuItem(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
    }

    public void updateColumns(List<ColumnSpec> columns, ColumnSpec selectedCol) {
        this.getColumnStylePnl().updateColumns(columns, selectedCol);
    }

    public void updateColumnPickerWarnings() {
        this.getColumnStylePnl().updateColumnPickerWarnings();
    }

    private void init() {
        this.setMinimumSize(new Dimension(260, 240));
        this.setPreferredSize(new Dimension(400, 385));
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.getStylesPanelProvider().getComponent(), "North");
        BiModalJSplitPane splitPane = new BiModalJSplitPane(0, null, null);
        splitPane.setBottomComponent(this.getPropertiesPnl().getComponent());
        splitPane.setOpaque(false);
        this.getPropertiesPnl().getPropertiesPn().addChangeListener(e -> {
            VisualPropertySheet sheet = this.getPropertiesPnl().getSelectedVisualPropertySheet();
            if (sheet == null) {
                return;
            }
            Class<? extends CyIdentifiable> type = sheet.getModel().getLexiconType();
            if (CyColumn.class.equals(type)) {
                splitPane.setTopComponent(this.getColumnStylePnl().getComponent());
            } else {
                splitPane.setTopComponent(null);
            }
            splitPane.update();
            topPanel.revalidate();
            topPanel.repaint();
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(topPanel, -1, -1, Short.MAX_VALUE).addComponent(splitPane, -1, 280, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(topPanel, -2, -1, -2).addComponent(splitPane, -1, -1, Short.MAX_VALUE)));
    }
}

