/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.gui.MappingFunctionFactoryManager;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingEditor;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor2;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;
import org.cytoscape.view.vizmap.gui.internal.util.NumberConverter;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VizMapPropertyBuilder {
    public static final String COLUMN = "Column";
    public static final String COLUMN_SOURCE = "Source Column";
    public static final String MAPPING_TYPE = "Mapping Type";
    public static final String GRAPHICAL_MAP_VIEW = "Graphical View";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final DefaultTableCellRenderer defaultTableCellRenderer;
    private final DefaultTableCellRenderer defaultTableCellRendererForColumn;
    private final EditorManager editorManager;
    private final MappingFunctionFactoryManager mappingFactoryManager;
    private final ServicesUtil servicesUtil;

    public VizMapPropertyBuilder(EditorManager editorManager, MappingFunctionFactoryManager mappingFactoryManager, ServicesUtil servicesUtil) {
        this.editorManager = editorManager;
        this.mappingFactoryManager = mappingFactoryManager;
        this.servicesUtil = servicesUtil;
        this.defaultTableCellRenderer = new DefaultVizMapTableCellRenderer(false);
        this.defaultTableCellRendererForColumn = new DefaultVizMapTableCellRenderer(true);
    }

    public <V> void buildProperty(VisualProperty<V> visualProperty, PropertySheetPanel propertySheetPanel, GraphObjectType tableType, boolean forColumn) {
        if (visualProperty == null) {
            throw new IllegalArgumentException("'visualProperty' must not be null.");
        }
        if (propertySheetPanel == null) {
            throw new IllegalArgumentException("'propertySheetPanel' must not be null.");
        }
        VizMapperProperty columnProp = new VizMapperProperty(CellType.VISUAL_PROPERTY_TYPE, visualProperty, String.class);
        columnProp.setDisplayName(forColumn ? COLUMN_SOURCE : COLUMN);
        ((PropertyRendererRegistry)propertySheetPanel.getTable().getRendererFactory()).registerRenderer(columnProp, (TableCellRenderer)this.defaultTableCellRendererForColumn);
        VizMapperProperty mapTypeProp = new VizMapperProperty(CellType.MAPPING_TYPE, MAPPING_TYPE, VisualMappingFunctionFactory.class);
        mapTypeProp.setDisplayName(MAPPING_TYPE);
        ((PropertyRendererRegistry)propertySheetPanel.getTable().getRendererFactory()).registerRenderer(mapTypeProp, (TableCellRenderer)this.defaultTableCellRenderer);
        propertySheetPanel.addProperty(0, columnProp);
        propertySheetPanel.addProperty(1, mapTypeProp);
        propertySheetPanel.repaint();
        PropertyEditorRegistry propEditorRegistry = (PropertyEditorRegistry)propertySheetPanel.getTable().getEditorFactory();
        propEditorRegistry.registerEditor(columnProp, this.editorManager.getDataTableComboBoxEditor(tableType.type()));
        propEditorRegistry.registerEditor(mapTypeProp, this.editorManager.getDefaultComboBoxEditor("mappingTypeEditor"));
    }

    public <K, V> void buildProperty(VisualMappingFunction<K, V> visualMapping, PropertySheetPanel propertySheetPanel, VisualMappingFunctionFactory factory, GraphObjectType tableType, boolean forColumn) {
        if (visualMapping == null) {
            throw new IllegalArgumentException("'visualMapping' must not be null.");
        }
        if (propertySheetPanel == null) {
            throw new IllegalArgumentException("'propertySheetPanel' must not be null.");
        }
        if (factory == null) {
            throw new IllegalArgumentException("'factory' must not be null.");
        }
        VisualProperty vp = visualMapping.getVisualProperty();
        VizMapperProperty columnProp = new VizMapperProperty(CellType.VISUAL_PROPERTY_TYPE, vp, String.class);
        columnProp.setDisplayName(forColumn ? COLUMN_SOURCE : COLUMN);
        columnProp.setValue(visualMapping.getMappingColumnName());
        columnProp.setInternalValue(factory);
        String attrName = visualMapping.getMappingColumnName();
        VizMapperProperty mapTypeProp = new VizMapperProperty(CellType.MAPPING_TYPE, MAPPING_TYPE, VisualMappingFunctionFactory.class);
        if (attrName == null) {
            columnProp.setValue(null);
        }
        ((PropertyRendererRegistry)propertySheetPanel.getTable().getRendererFactory()).registerRenderer(columnProp, (TableCellRenderer)this.defaultTableCellRendererForColumn);
        mapTypeProp.setDisplayName(MAPPING_TYPE);
        mapTypeProp.setValue(factory);
        mapTypeProp.setInternalValue(visualMapping);
        ((PropertyRendererRegistry)propertySheetPanel.getTable().getRendererFactory()).registerRenderer(mapTypeProp, (TableCellRenderer)this.defaultTableCellRenderer);
        propertySheetPanel.addProperty(0, columnProp);
        propertySheetPanel.addProperty(1, mapTypeProp);
        PropertyEditorRegistry propEditorRegistry = (PropertyEditorRegistry)propertySheetPanel.getTable().getEditorFactory();
        propEditorRegistry.registerEditor(columnProp, this.editorManager.getDataTableComboBoxEditor(tableType.type()));
        propEditorRegistry.registerEditor(mapTypeProp, this.editorManager.getDefaultComboBoxEditor("mappingTypeEditor"));
        this.createMappingProperties(visualMapping, propertySheetPanel, factory, tableType);
    }

    public <K, V> void createMappingProperties(VisualMappingFunction<K, V> visualMapping, PropertySheetPanel propertySheetPanel, VisualMappingFunctionFactory factory, GraphObjectType tableType) {
        String attrName = visualMapping.getMappingColumnName();
        if (attrName == null) {
            return;
        }
        this.removeMappingProperties(propertySheetPanel);
        VisualProperty vp = visualMapping.getVisualProperty();
        VisualPropertyEditor vpEditor = this.editorManager.getVisualPropertyEditor(vp);
        if (visualMapping instanceof DiscreteMapping) {
            Class<? extends CyIdentifiable> type = tableType.type();
            TreeSet<Object> attrSet = new TreeSet<Object>();
            CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
            CyNetwork network = appMgr.getCurrentNetwork();
            if (network != null) {
                CyIdentifiable cyIdentifiable;
                CyRow firstRow;
                CyColumn column;
                HashSet graphObjects = new HashSet();
                if (network != null) {
                    if (type == CyNode.class) {
                        graphObjects.addAll(network.getNodeList());
                    } else if (type == CyEdge.class) {
                        graphObjects.addAll(network.getEdgeList());
                    } else if (type == CyNetwork.class) {
                        graphObjects.add(network);
                    } else {
                        throw new IllegalArgumentException("Data type not supported: " + vp.getTargetDataType());
                    }
                }
                if (type == CyNetwork.class) {
                    CyRow cyRow = network.getRow((CyIdentifiable)network);
                    CyColumn column2 = cyRow.getTable().getColumn(attrName);
                    if (column2 != null) {
                        this.processDiscretValues(cyRow, column2, attrSet);
                    }
                } else if (!graphObjects.isEmpty() && (column = (firstRow = network.getRow(cyIdentifiable = (CyIdentifiable)graphObjects.iterator().next())).getTable().getColumn(attrName)) != null) {
                    Iterator iterator = graphObjects.iterator();
                    while (iterator.hasNext()) {
                        CyIdentifiable go = (CyIdentifiable)iterator.next();
                        CyRow row = network.getRow(go);
                        this.processDiscretValues(row, column, attrSet);
                    }
                }
            }
            for (Map.Entry entry : ((DiscreteMapping)visualMapping).getAll().entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    attrSet.add(entry.getKey());
                }
                catch (ClassCastException classCastException) {}
            }
            this.setDiscreteProps(vp, visualMapping, attrSet, vpEditor, propertySheetPanel);
        } else if (visualMapping instanceof ContinuousMapping) {
            VizMapperProperty graphicalView = new VizMapperProperty(CellType.CONTINUOUS, (CallSite)((Object)(visualMapping.getVisualProperty().getDisplayName() + "_Graphical View")), visualMapping.getClass());
            graphicalView.setShortDescription("Continuous Mapping from " + visualMapping.getMappingColumnName() + " to " + visualMapping.getVisualProperty().getDisplayName());
            graphicalView.setValue(visualMapping);
            graphicalView.setDisplayName("Current Mapping");
            propertySheetPanel.addProperty(2, graphicalView);
            PropertySheetTable table = propertySheetPanel.getTable();
            PropertyRendererRegistry rendReg = (PropertyRendererRegistry)table.getRendererFactory();
            PropertyEditorRegistry cellEditorFactory = (PropertyEditorRegistry)table.getEditorFactory();
            PropertyEditor continuousCellEditor = this.editorManager.getContinuousEditor(vp);
            if (continuousCellEditor == null) {
                throw new NullPointerException("Continuous Mapping cell editor is null.");
            }
            TableCellRenderer tableCellRenderer = vpEditor.getContinuousTableCellRenderer((ContinuousMappingEditor)((Object)continuousCellEditor));
            rendReg.registerRenderer(graphicalView, tableCellRenderer);
            continuousCellEditor.setValue(visualMapping);
            cellEditorFactory.registerEditor(graphicalView, continuousCellEditor);
        } else if (!(visualMapping instanceof PassthroughMapping) || attrName == null) {
            throw new IllegalArgumentException("Unsupported mapping type: " + visualMapping);
        }
        propertySheetPanel.getTable().repaint();
        propertySheetPanel.repaint();
    }

    public VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> getColumnProperty(PropertySheetPanel propSheetPnl) {
        Property[] properties;
        Property[] propertyArray = properties = propSheetPnl != null ? propSheetPnl.getProperties() : null;
        if (properties != null) {
            for (Property p : properties) {
                VizMapperProperty vmp;
                if (!(p instanceof VizMapperProperty) || (vmp = (VizMapperProperty)p).getCellType() != CellType.VISUAL_PROPERTY_TYPE) continue;
                return vmp;
            }
        }
        return null;
    }

    public VizMapperProperty<String, VisualMappingFunctionFactory, VisualMappingFunction<?, ?>> getMappingTypeProperty(PropertySheetPanel propSheetPnl) {
        Property[] properties;
        Property[] propertyArray = properties = propSheetPnl != null ? propSheetPnl.getProperties() : null;
        if (properties != null) {
            for (Property p : properties) {
                VizMapperProperty vmp;
                if (!(p instanceof VizMapperProperty) || (vmp = (VizMapperProperty)p).getCellType() != CellType.MAPPING_TYPE) continue;
                return vmp;
            }
        }
        return null;
    }

    public VisualMappingFunctionFactory getMappingFactory(VisualMappingFunction<?, ?> mapping) {
        if (mapping != null) {
            for (VisualMappingFunctionFactory f : this.mappingFactoryManager.getFactories()) {
                Class type = f.getMappingFunctionType();
                if (!type.isAssignableFrom(mapping.getClass())) continue;
                return f;
            }
        }
        return null;
    }

    protected void removeMappingProperties(PropertySheetPanel propertySheetPanel) {
        Property[] properties = propertySheetPanel.getProperties();
        if (properties != null) {
            LinkedHashSet<Property> propsToKeep = new LinkedHashSet<Property>();
            for (Property p : properties) {
                propsToKeep.add(p);
            }
            PropertySheetTable table = propertySheetPanel.getTable();
            PropertyRendererRegistry rendReg = (PropertyRendererRegistry)table.getRendererFactory();
            for (Property p : properties) {
                CellType cellType;
                if (!(p instanceof VizMapperProperty) || (cellType = ((VizMapperProperty)p).getCellType()) != CellType.CONTINUOUS && cellType != CellType.DISCRETE) continue;
                if (cellType == CellType.CONTINUOUS) {
                    rendReg.unregisterRenderer(p);
                }
                propsToKeep.remove(p);
            }
            propertySheetPanel.setProperties((Property[])propsToKeep.toArray(Property[]::new));
            table.repaint();
            propertySheetPanel.repaint();
        }
    }

    private void processDiscretValues(CyRow row, CyColumn column, SortedSet<Object> attrSet) {
        block6: {
            block5: {
                if (column.getListElementType() == null) break block5;
                List list = row.getList(column.getName(), column.getListElementType());
                if (list == null) break block6;
                for (Object item : list) {
                    if (item == null) continue;
                    attrSet.add(item != null ? item.toString() : null);
                }
                break block6;
            }
            Class attrClass = column.getType();
            Object id = row.get(column.getName(), attrClass);
            if (id == null) break block6;
            if (id.getClass() != attrClass && id instanceof Number) {
                attrSet.add(NumberConverter.convert(attrClass, (Number)id));
            } else {
                try {
                    attrSet.add(id);
                }
                catch (Exception e) {
                    logger.debug(column.getName() + ": Invalid entry ignored", (Throwable)e);
                }
            }
        }
    }

    private <K, V> void setDiscreteProps(VisualProperty<V> vp, VisualMappingFunction<K, V> mapping, SortedSet<Object> attrSet, VisualPropertyEditor<V> vpEditor, PropertySheetPanel propertySheetPanel) {
        if (attrSet == null) {
            return;
        }
        Map discMapping = ((DiscreteMapping)mapping).getAll();
        PropertySheetTable table = propertySheetPanel.getTable();
        PropertyRendererRegistry cellRendererFactory = (PropertyRendererRegistry)table.getRendererFactory();
        PropertyEditorRegistry cellEditorFactory = (PropertyEditorRegistry)table.getEditorFactory();
        Property[] properties = new Property[propertySheetPanel.getPropertyCount() + attrSet.size()];
        int i = 0;
        for (Property existingProp : propertySheetPanel.getProperties()) {
            properties[i++] = existingProp;
        }
        for (Object e : attrSet) {
            VizMapperProperty valProp = new VizMapperProperty(CellType.DISCRETE, e, mapping.getVisualProperty().getRange().getType());
            String strVal = e.toString();
            valProp.setDisplayName(strVal);
            Object val = null;
            val = mapping.getMappingColumnType() == String.class && !(e instanceof String) ? (Object)discMapping.get(e.toString()) : (Object)discMapping.get(e);
            if (val != null) {
                valProp.setType(val.getClass());
            }
            if (vpEditor != null) {
                TableCellRenderer renderer = vpEditor.getDiscreteTableCellRenderer();
                if (renderer != null) {
                    cellRendererFactory.registerRenderer(valProp, renderer);
                }
                PropertyEditor cellEditor = null;
                cellEditor = vpEditor instanceof VisualPropertyEditor2 ? ((VisualPropertyEditor2)((Object)vpEditor)).getPropertyEditor(vp) : vpEditor.getPropertyEditor();
                if (cellEditor != null) {
                    cellEditorFactory.registerEditor(valProp, cellEditor);
                }
            }
            valProp.setValue(val);
            valProp.setInternalValue(mapping);
            properties[i++] = valProp;
        }
        propertySheetPanel.setProperties(properties);
    }

    private class DefaultVizMapTableCellRenderer
    extends DefaultTableCellRenderer {
        final boolean forColumn;

        public DefaultVizMapTableCellRenderer(boolean forColumn) {
            this.forColumn = forColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setText("-- select value --");
                this.setIcon(null);
            } else if (this.forColumn) {
                CyColumnPresentationManager presentationManager = VizMapPropertyBuilder.this.servicesUtil.get(CyColumnPresentationManager.class);
                presentationManager.setLabel(value.toString(), (JLabel)this);
            }
            if (!isSelected) {
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            return c;
        }
    }
}

