/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.DropDownMenuButton;
import org.cytoscape.view.vizmap.gui.internal.view.OptionsButton;
import org.cytoscape.view.vizmap.gui.internal.view.VisualStyleSelector;

public class VisualStylePanelProvider {
    private OptionsButton optionsBtn;
    private JPanel stylesPnl;
    protected VisualStyleDropDownButton stylesBtn;
    protected VisualStyleSelector styleSelector;
    private boolean isAdjusting;
    private final ServicesUtil servicesUtil;

    public VisualStylePanelProvider(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
        this.styleSelector = new VisualStyleSelector(2, 0, servicesUtil);
    }

    public JComponent getComponent() {
        return this.getStylesPnl();
    }

    public VisualStyle getSelectedVisualStyle() {
        return this.styleSelector.getSelectedStyle();
    }

    public void setSelectedVisualStyle(VisualStyle style) {
        this.isAdjusting = true;
        this.getStylesBtn().setSelectedItem(style);
        this.isAdjusting = false;
    }

    private JPanel getStylesPnl() {
        if (this.stylesPnl == null) {
            this.stylesPnl = new JPanel();
            this.stylesPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.getStylesBtn().setPreferredSize(new Dimension(this.getStylesBtn().getPreferredSize().width, this.getOptionsBtn().getOptionsBtn().getPreferredSize().height));
            GroupLayout layout = new GroupLayout(this.stylesPnl);
            this.stylesPnl.setLayout(layout);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getStylesBtn(), 0, 146, Short.MAX_VALUE).addComponent(this.getOptionsBtn().getOptionsBtn(), -2, 64, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getStylesBtn(), -2, -1, -2).addComponent(this.getOptionsBtn().getOptionsBtn(), -2, -1, -2));
        }
        return this.stylesPnl;
    }

    public void updateVisualStyles(SortedSet<VisualStyle> styles, VisualStyle selectedStyle) {
        this.getStylesBtn().update(styles, selectedStyle);
    }

    public Component getDefaultView(VisualStyle vs) {
        return this.styleSelector.getDefaultView(vs);
    }

    void update(VisualStyle style) {
        this.styleSelector.setDirty(style);
    }

    VisualStyleDropDownButton getStylesBtn() {
        if (this.stylesBtn == null) {
            this.stylesBtn = new VisualStyleDropDownButton();
            this.stylesBtn.setToolTipText("Current Style");
        }
        return this.stylesBtn;
    }

    OptionsButton getOptionsBtn() {
        if (this.optionsBtn == null) {
            this.optionsBtn = new OptionsButton(this.servicesUtil);
        }
        return this.optionsBtn;
    }

    class VisualStyleDropDownButton
    extends DropDownMenuButton {
        private JPopupMenu popup;

        VisualStyleDropDownButton() {
            super(true);
            this.setHorizontalAlignment(2);
            this.addActionListener(evt -> {
                if (!VisualStylePanelProvider.this.styleSelector.isEmpty()) {
                    this.showDialog();
                }
            });
            Timer timer = new Timer(100, ae -> this.disposePopup());
            timer.setRepeats(false);
            VisualStylePanelProvider.this.styleSelector.addPropertyChangeListener("selectedStyle", evt -> {
                this.update();
                if (!VisualStylePanelProvider.this.isAdjusting && this.popup != null && this.popup.isVisible()) {
                    timer.restart();
                }
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            });
        }

        public void update(SortedSet<VisualStyle> styles, VisualStyle selectedStyle) {
            VisualStylePanelProvider.this.styleSelector.update(styles, selectedStyle);
            this.setEnabled(!VisualStylePanelProvider.this.styleSelector.isEmpty());
        }

        public void setSelectedItem(VisualStyle vs) {
            VisualStylePanelProvider.this.styleSelector.setSelectedStyle(vs);
            if (VisualStylePanelProvider.this.styleSelector.isEditMode()) {
                this.update(vs);
            }
        }

        public RenderingEngine<CyNetwork> getRenderingEngine(VisualStyle vs) {
            return VisualStylePanelProvider.this.styleSelector.getRenderingEngine(vs);
        }

        public void update() {
            this.update(VisualStylePanelProvider.this.styleSelector.getSelectedStyle());
        }

        private void update(VisualStyle selectedStyle) {
            this.setText(selectedStyle != null ? selectedStyle.getTitle() : "");
            this.repaint();
        }

        private void showDialog() {
            this.setEnabled(false);
            this.disposePopup();
            this.popup = new JPopupMenu();
            this.popup.setBackground(VisualStylePanelProvider.this.styleSelector.getBackground());
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.addPropertyChangeListener("visible", evt -> {
                if (Boolean.FALSE.equals(evt.getNewValue())) {
                    this.onPopupDisposed();
                }
            });
            GroupLayout layout = new GroupLayout(this.popup);
            this.popup.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(VisualStylePanelProvider.this.styleSelector, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(VisualStylePanelProvider.this.styleSelector, -1, -1, 660));
            VisualStylePanelProvider.this.styleSelector.update(true);
            if (this.getSize() != null && this.getSize().width > 0) {
                this.popup.setPreferredSize(new Dimension(this.getSize().width, this.popup.getPreferredSize().height));
            }
            this.popup.pack();
            this.popup.show(this, 0, 0);
            this.popup.requestFocus();
        }

        private void disposePopup() {
            if (this.popup != null) {
                this.popup.setVisible(false);
            }
            VisualStylePanelProvider.this.styleSelector.setEditMode(false);
        }

        private void onPopupDisposed() {
            if (this.popup != null) {
                this.popup.removeAll();
                this.popup = null;
            }
            this.setEnabled(!VisualStylePanelProvider.this.styleSelector.isEmpty());
            VisualStylePanelProvider.this.styleSelector.resetFilter();
        }
    }
}

