/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.view.AbstractVizMapperModel;

public class VisualPropertySheetModel
extends AbstractVizMapperModel {
    private final GraphObjectType tableType;
    private final Class<? extends CyIdentifiable> lexiconType;
    private final VisualStyle style;
    private final VisualLexicon lexicon;

    public VisualPropertySheetModel(Class<? extends CyIdentifiable> lexiconType, GraphObjectType tableType, VisualStyle style, VisualLexicon lexicon) {
        this.tableType = tableType;
        this.lexiconType = lexiconType;
        this.style = style;
        this.lexicon = lexicon;
    }

    public Class<? extends CyIdentifiable> getLexiconType() {
        return this.lexiconType;
    }

    public GraphObjectType getTableType() {
        return this.tableType;
    }

    public VisualStyle getVisualStyle() {
        return this.style;
    }

    public VisualLexicon getVisualLexicon() {
        return this.lexicon;
    }

    public VisualProperty<?> getRootVisualProperty() {
        if (this.lexiconType == CyNode.class) {
            return BasicVisualLexicon.NODE;
        }
        if (this.lexiconType == CyEdge.class) {
            return BasicVisualLexicon.EDGE;
        }
        if (this.lexiconType == CyColumn.class) {
            return BasicTableVisualLexicon.CELL;
        }
        return BasicVisualLexicon.NETWORK;
    }

    public String getTitle() {
        if (this.lexiconType == CyNode.class) {
            return "Node";
        }
        if (this.lexiconType == CyEdge.class) {
            return "Edge";
        }
        if (this.lexiconType == CyColumn.class) {
            return "Column";
        }
        return "Network";
    }
}

