/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.Collator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellEditor;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValueState;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.VisualPropertyUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.jdesktop.swingx.icon.EmptyIcon;

public class VisualPropertySheetItem<T>
extends JPanel
implements Comparable<VisualPropertySheetItem<?>> {
    private static final String DISCRETE_ICON = "\uf142 \uf142";
    private static final String CONTINUOUS_ICON = "\uf142 \uf07d";
    private static final String PASSTHROUGH_ICON = "\uf142 \uf105";
    private static final int HEIGHT = 32;
    private static final int PROP_SHEET_ROW_HEIGHT = 24;
    private static final int MAPPING_IMG_ROW_HEIGHT = 90;
    private static final int VALUE_ICON_WIDTH = 24;
    private static final int VALUE_ICON_HEIGHT = 24;
    private static final int BUTTON_V_PAD = 2;
    private static final int BUTTON_H_PAD = 4;
    private static final int MSG_ICON_WIDTH = 18;
    private static final int MSG_ICON_HEIGHT = 15;
    static final int BTN_H_MARGIN = 1;
    static final int BTN_BORDER_WIDTH = 1;
    private JPanel topPnl;
    private JPanel mappingPnl;
    private PropertySheetPanel propSheetPnl;
    private ExpandCollapseButton showMappingBtn;
    private JButton defaultBtn;
    private JToggleButton mappingBtn;
    private JButton bypassBtn;
    private JCheckBox dependencyCkb;
    private JLabel titleLbl;
    private JLabel msgIconLbl;
    private PropertySheetTable propSheetTbl;
    private JButton removeMappingBtn;
    private JButton copyNodeColorMappingBtn;
    private final Icon disabledBtnIcon;
    private boolean selected;
    private final VisualPropertySheetItemModel<T> model;
    private final VizMapPropertyBuilder vizMapPropertyBuilder;
    private final ServicesUtil servicesUtil;

    public VisualPropertySheetItem(VisualPropertySheetItemModel<T> model, VizMapPropertyBuilder vizMapPropertyBuilder, ServicesUtil servicesUtil) {
        if (model == null) {
            throw new IllegalArgumentException("'model' must not be null");
        }
        if (vizMapPropertyBuilder == null) {
            throw new IllegalArgumentException("'vizMapPropertyBuilder' must not be null");
        }
        if (servicesUtil == null) {
            throw new IllegalArgumentException("'servicesUtil' must not be null");
        }
        this.model = model;
        this.vizMapPropertyBuilder = vizMapPropertyBuilder;
        this.servicesUtil = servicesUtil;
        this.disabledBtnIcon = this.getIcon(null, 24, 24);
        this.init();
    }

    public VisualPropertySheetItemModel<T> getModel() {
        return this.model;
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.setSelected(false);
        }
        super.setVisible(b);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            if (!selected && this.getModel().isVisualMappingAllowed()) {
                this.getPropSheetTbl().clearSelection();
            }
            this.updateSelection();
            this.firePropertyChange("selected", !selected, selected);
        }
    }

    public void expand() {
        if (!this.isExpanded() && this.model.isVisualMappingAllowed()) {
            this.getMappingPnl().setVisible(true);
            this.firePropertyChange("expanded", false, true);
        }
    }

    public void collapse() {
        if (this.isExpanded() && this.model.isVisualMappingAllowed()) {
            this.getMappingPnl().setVisible(false);
            this.firePropertyChange("expanded", true, false);
        }
    }

    public boolean isExpanded() {
        return this.model.isVisualMappingAllowed() && this.getMappingPnl().isVisible();
    }

    public void fitToWidth(int width) {
        if (this.getModel().isVisualMappingAllowed()) {
            this.updateMappingPanelSize();
            Dimension prefSize = this.getPropSheetPnl().getPreferredSize();
            this.getPropSheetPnl().setPreferredSize(new Dimension(width, prefSize.height));
            if (this.getMappingPnl().isVisible()) {
                this.getPropSheetPnl().repaint();
                this.getPropSheetPnl().revalidate();
                this.revalidate();
            }
        }
    }

    public void update() {
        this.updateSelection();
        if (this.model.getVisualPropertyDependency() == null) {
            this.updateDefaultButton();
            this.updateBypassButton();
            this.updateMapping();
        } else {
            this.updateDependencyCkb();
        }
    }

    public void updateDefaultButton() {
        if (this.defaultBtn != null) {
            this.defaultBtn.setIcon(this.getIcon(this.model.getDefaultValue(), 24, 24));
            this.defaultBtn.setToolTipText(this.model.getDefaultValue() == null ? null : "Default Value: " + VisualPropertyUtil.getDisplayString(this.model.getDefaultValue()));
        }
    }

    public void updateBypassButton() {
        if (this.bypassBtn != null) {
            LockedValueState state = this.model.getLockedValueState();
            this.bypassBtn.setEnabled(this.isEnabled() && state != LockedValueState.DISABLED);
            if (state == LockedValueState.ENABLED_MULTIPLE_VALUES) {
                IconManager iconManager = this.servicesUtil.get(IconManager.class);
                this.bypassBtn.setForeground(LookAndFeelUtil.getInfoColor());
                this.bypassBtn.setFont(iconManager.getIconFont(19.0f));
                this.bypassBtn.setText("\uf059");
            } else {
                this.bypassBtn.setForeground(VisualPropertySheetItem.getForegroundColor());
                this.bypassBtn.setFont(UIManager.getFont("Button.font"));
                this.bypassBtn.setText("");
            }
            this.bypassBtn.setIcon(this.getIcon(this.model.getLockedValue(), 24, 24));
            String elementsStr = this.model.getTargetDataType() == CyNode.class ? "nodes" : "edges";
            Object toolTipText = "No bypass";
            if (state == LockedValueState.DISABLED) {
                toolTipText = "To bypass the visual property, first select one or more " + elementsStr;
            } else if (state == LockedValueState.ENABLED_UNIQUE_VALUE) {
                toolTipText = "Bypass: " + VisualPropertyUtil.getDisplayString(this.model.getLockedValue());
            } else if (state == LockedValueState.ENABLED_MULTIPLE_VALUES) {
                toolTipText = "The selected " + elementsStr + " have different bypass values";
            }
            this.bypassBtn.setToolTipText((String)toolTipText);
        }
    }

    public void updateMapping() {
        if (!this.model.isVisualMappingAllowed()) {
            return;
        }
        VisualMappingFunction<?, T> mapping = this.getModel().getVisualMappingFunction();
        VisualMappingFunctionFactory mappingFactory = this.vizMapPropertyBuilder.getMappingFactory(mapping);
        VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> columnProp = this.vizMapPropertyBuilder.getColumnProperty(this.getPropSheetPnl());
        columnProp.setValue(mapping == null ? null : mapping.getMappingColumnName());
        columnProp.setInternalValue(mappingFactory);
        VizMapperProperty<String, VisualMappingFunctionFactory, VisualMappingFunction<?, ?>> mappingProp = this.vizMapPropertyBuilder.getMappingTypeProperty(this.getPropSheetPnl());
        mappingProp.setValue(mappingFactory);
        mappingProp.setInternalValue(mapping);
        if (mapping == null) {
            this.vizMapPropertyBuilder.removeMappingProperties(this.getPropSheetPnl());
        } else {
            int rowCount = this.getPropSheetTbl().getRowCount();
            int[] selectedRows = this.getPropSheetTbl().getSelectedRows();
            this.vizMapPropertyBuilder.createMappingProperties(mapping, this.getPropSheetPnl(), mappingFactory, this.model.getTableType());
            if (selectedRows != null && selectedRows.length > 0 && this.getPropSheetTbl().getRowCount() == rowCount) {
                ListSelectionModel selModel = this.getPropSheetTbl().getSelectionModel();
                for (int r : selectedRows) {
                    selModel.addSelectionInterval(r, r);
                }
            }
        }
        this.updateMappingIcon();
        this.updateRemoveMappingBtn();
        this.updateMappingRowHeight();
        if (this.mappingPnl != null && this.mappingPnl.isVisible()) {
            this.updateMappingPanelSize();
        }
    }

    public void setMessage(String text, MessageType type) {
        if (type == null) {
            this.setToolTipText(text);
            this.getMsgIconLbl().setToolTipText(null);
        } else {
            this.setToolTipText(null);
            this.getMsgIconLbl().setToolTipText(text);
        }
        this.updateMessageIcon(type);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.getTitleLbl().setEnabled(enabled);
        if (this.model.getVisualPropertyDependency() != null) {
            this.getDependencyCkb().setEnabled(enabled);
        } else {
            this.getDefaultBtn().setEnabled(enabled);
            this.getBypassBtn().setEnabled(enabled && this.model.getLockedValueState() != LockedValueState.DISABLED);
            if (this.model.isVisualMappingAllowed()) {
                if (!enabled && this.getMappingPnl().isVisible()) {
                    this.getMappingBtn().doClick();
                }
                this.getMappingBtn().setEnabled(enabled);
                this.getShowMappingBtn().setEnabled(enabled);
                this.getRemoveMappingBtn().setEnabled(enabled);
                this.getPropSheetPnl().setEnabled(enabled);
                this.getPropSheetTbl().setEnabled(enabled);
            }
        }
        super.setEnabled(enabled);
    }

    @Override
    public int compareTo(VisualPropertySheetItem<?> other) {
        VisualPropertySheetItemModel<T> m1 = this.getModel();
        VisualPropertySheetItemModel<?> m2 = other.getModel();
        String title1 = m1.getTitle();
        String title2 = m2.getTitle();
        VisualPropertyDependency<T> dep1 = m1.getVisualPropertyDependency();
        VisualPropertyDependency<?> dep2 = m2.getVisualPropertyDependency();
        if (dep1 == null && dep2 != null) {
            return -1;
        }
        if (dep1 != null && dep2 == null) {
            return 1;
        }
        if (dep1 != null && dep2 != null) {
            title1 = dep1.getDisplayName();
            title2 = dep2.getDisplayName();
        }
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(0);
        return collator.compare(title1, title2);
    }

    @Override
    public String toString() {
        return this.model != null ? this.model.getTitle() : "?";
    }

    private void init() {
        this.setFocusable(true);
        this.setBackground(VisualPropertySheetItem.getBackgroundColor());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, VisualPropertySheetItem.getButtonBorderColor()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTopPnl(), "North");
        this.add((Component)this.getMappingPnl(), "Center");
        this.model.addPropertyChangeListener("defaultValue", evt -> this.updateDefaultButton());
        this.model.addPropertyChangeListener("lockedValue", evt -> this.updateBypassButton());
        this.model.addPropertyChangeListener("lockedValueState", evt -> this.updateBypassButton());
        this.model.addPropertyChangeListener("renderingEngine", evt -> {
            this.updateDefaultButton();
            this.updateBypassButton();
        });
        this.model.addPropertyChangeListener("visualMappingFunction", evt -> {
            if (!this.model.isVisualMappingAllowed()) {
                return;
            }
            ContinuousMappingEditorPanel.resetTracer(this.model.getVisualProperty());
            this.updateMapping();
        });
    }

    private JPanel getTopPnl() {
        if (this.topPnl == null) {
            this.topPnl = new JPanel();
            this.topPnl.setBorder(BorderFactory.createEmptyBorder(1, 2, 0, 2));
            this.topPnl.setLayout(new BoxLayout(this.topPnl, 0));
            GroupLayout layout = new GroupLayout(this.topPnl);
            this.topPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            hGroup.addGap(1);
            if (this.model.getVisualPropertyDependency() == null) {
                hGroup.addComponent(this.getDefaultBtn(), -2, -1, -2);
                vGroup.addComponent(this.getDefaultBtn(), -2, -1, -2);
            } else {
                hGroup.addComponent(this.getDependencyCkb(), -2, -1, -2);
                vGroup.addComponent(this.getDependencyCkb(), -2, -1, -2);
            }
            hGroup.addGap(1);
            if (this.model.isVisualMappingAllowed()) {
                hGroup.addGap(1).addComponent(this.getMappingBtn(), -2, -1, -2).addGap(1);
                vGroup.addComponent(this.getMappingBtn(), -2, -1, -2);
            }
            if (this.model.isLockedValueAllowed()) {
                hGroup.addGap(1).addComponent(this.getBypassBtn(), -2, -1, -2).addGap(1);
                vGroup.addComponent(this.getBypassBtn(), -2, -1, -2);
            }
            hGroup.addGap(4).addComponent(this.getTitleLbl(), 30, 40, Short.MAX_VALUE).addGap(2).addComponent(this.getMsgIconLbl(), -2, -1, -2);
            vGroup.addComponent(this.getTitleLbl(), 32, -1, -2).addComponent(this.getMsgIconLbl(), -2, -1, -2);
            if (this.model.isVisualMappingAllowed()) {
                hGroup.addComponent(this.getShowMappingBtn(), -2, -1, -2);
                vGroup.addComponent(this.getShowMappingBtn(), -2, -1, -2);
            }
            this.updateSelection();
        }
        return this.topPnl;
    }

    public boolean isNodeColumnColor() {
        return this.model.getVisualProperty() == BasicTableVisualLexicon.CELL_BACKGROUND_PAINT && this.model.getTableType().isNode();
    }

    protected JPanel getMappingPnl() {
        if (this.mappingPnl == null) {
            this.mappingPnl = new JPanel();
            this.mappingPnl.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            this.mappingPnl.setLayout(new BorderLayout());
            this.mappingPnl.setVisible(false);
            this.mappingPnl.add((Component)this.getPropSheetPnl(), "Center");
            JPanel bottomPnl = new JPanel();
            bottomPnl.setLayout(new BoxLayout(bottomPnl, 0));
            bottomPnl.add(Box.createHorizontalGlue());
            if (this.isNodeColumnColor()) {
                bottomPnl.add(this.getCopyNodeColorMappingBtn());
                bottomPnl.add(Box.createHorizontalStrut(5));
            }
            bottomPnl.add(this.getRemoveMappingBtn());
            bottomPnl.add(Box.createRigidArea(new Dimension(0, 24)));
            bottomPnl.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.mappingPnl.add((Component)bottomPnl, "South");
            this.mappingPnl.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    VisualPropertySheetItem.this.updateMappingPanelSize();
                }
            });
        }
        return this.mappingPnl;
    }

    public PropertySheetPanel getPropSheetPnl() {
        if (this.propSheetPnl == null) {
            boolean forColumn;
            this.propSheetPnl = new PropertySheetPanel();
            this.propSheetPnl.setToolBarVisible(false);
            this.propSheetPnl.setMode(0);
            this.propSheetPnl.setTable(this.getPropSheetTbl());
            this.propSheetPnl.getTable().setEditorFactory((PropertyEditorFactory)new PropertyEditorRegistry());
            this.propSheetPnl.getTable().setRendererFactory((PropertyRendererFactory)new PropertyRendererRegistry());
            VisualMappingFunction<?, T> mapping = this.model.getVisualMappingFunction();
            boolean bl = forColumn = this.model.getLexiconType() == CyColumn.class;
            if (mapping == null) {
                VisualProperty<T> vp = this.model.getVisualProperty();
                this.vizMapPropertyBuilder.buildProperty(vp, this.propSheetPnl, this.model.getTableType(), forColumn);
            } else {
                VisualMappingFunctionFactory mappingFactory = this.vizMapPropertyBuilder.getMappingFactory(mapping);
                this.vizMapPropertyBuilder.buildProperty(mapping, this.propSheetPnl, mappingFactory, this.model.getTableType(), forColumn);
                this.updateMappingRowHeight();
            }
            Container c = this.propSheetPnl.getTable().getParent().getParent();
            if (c instanceof JScrollPane) {
                c.addMouseWheelListener(new CustomMouseWheelListener((JScrollPane)c));
            }
        }
        return this.propSheetPnl;
    }

    protected PropertySheetTable getPropSheetTbl() {
        if (this.propSheetTbl == null) {
            this.propSheetTbl = new VizMapPropertySheetTable();
            this.propSheetTbl.setRowHeight(24);
            this.propSheetTbl.setSelectionMode(2);
            this.propSheetTbl.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    VisualPropertySheetItem.this.updateMappingPanelSize();
                }
            });
        }
        return this.propSheetTbl;
    }

    protected ExpandCollapseButton getShowMappingBtn() {
        if (this.showMappingBtn == null) {
            this.showMappingBtn = new ExpandCollapseButton(false, evt -> {
                if (this.getMappingPnl().isShowing()) {
                    this.collapse();
                } else {
                    this.expand();
                }
            });
            this.getMappingPnl().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    if (VisualPropertySheetItem.this.showMappingBtn != null && !VisualPropertySheetItem.this.showMappingBtn.isSelected()) {
                        VisualPropertySheetItem.this.showMappingBtn.setSelected(true);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                    if (VisualPropertySheetItem.this.showMappingBtn != null && VisualPropertySheetItem.this.showMappingBtn.isSelected()) {
                        VisualPropertySheetItem.this.showMappingBtn.setSelected(false);
                    }
                }
            });
        }
        return this.showMappingBtn;
    }

    protected JButton getDefaultBtn() {
        if (this.defaultBtn == null) {
            this.defaultBtn = new VizMapperButton();
            this.defaultBtn.setUI(new VPButtonUI(3));
            this.defaultBtn.setDisabledIcon(this.disabledBtnIcon);
            this.updateDefaultButton();
        }
        return this.defaultBtn;
    }

    protected JCheckBox getDependencyCkb() {
        if (this.dependencyCkb == null) {
            this.dependencyCkb = new JCheckBox();
            this.dependencyCkb.setOpaque(false);
            this.dependencyCkb.setSelected(this.model.isDependencyEnabled());
        }
        return this.dependencyCkb;
    }

    protected JToggleButton getMappingBtn() {
        if (this.mappingBtn == null) {
            this.mappingBtn = new VizMapperToggleButton();
            this.mappingBtn.setIcon(this.getIcon(null, 24, 24));
            this.mappingBtn.setUI(new VPButtonUI(3));
            this.mappingBtn.setHorizontalAlignment(0);
            this.mappingBtn.setDisabledIcon(this.disabledBtnIcon);
            this.updateMappingIcon();
            this.mappingBtn.addActionListener(evt -> {
                if (this.getMappingPnl().isShowing()) {
                    this.collapse();
                } else {
                    this.expand();
                }
                this.updateMappingIcon();
            });
            this.getMappingPnl().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    if (VisualPropertySheetItem.this.mappingBtn != null) {
                        VisualPropertySheetItem.this.mappingBtn.setSelected(true);
                    }
                    VisualPropertySheetItem.this.updateMappingIcon();
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                    if (VisualPropertySheetItem.this.mappingBtn != null) {
                        VisualPropertySheetItem.this.mappingBtn.setSelected(false);
                    }
                    VisualPropertySheetItem.this.updateMappingIcon();
                }
            });
        }
        return this.mappingBtn;
    }

    protected JButton getBypassBtn() {
        if (this.bypassBtn == null) {
            this.bypassBtn = new VizMapperButton();
            this.bypassBtn.setIcon(this.getIcon(this.model.getLockedValue(), 24, 24));
            this.bypassBtn.setUI(new VPButtonUI(3));
            this.bypassBtn.setDisabledIcon(this.disabledBtnIcon);
            this.updateBypassButton();
        }
        return this.bypassBtn;
    }

    protected JButton getRemoveMappingBtn() {
        if (this.removeMappingBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.removeMappingBtn = new JButton("\uf014");
            this.removeMappingBtn.setToolTipText("Remove Mapping");
            this.removeMappingBtn.setBorderPainted(false);
            this.removeMappingBtn.setContentAreaFilled(false);
            this.removeMappingBtn.setOpaque(false);
            this.removeMappingBtn.setFocusable(false);
            this.removeMappingBtn.setFont(iconManager.getIconFont(18.0f));
            this.removeMappingBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.updateRemoveMappingBtn();
        }
        return this.removeMappingBtn;
    }

    protected JButton getCopyNodeColorMappingBtn() {
        if (this.copyNodeColorMappingBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.copyNodeColorMappingBtn = new JButton("\uf0c5");
            this.copyNodeColorMappingBtn.setToolTipText("Copy Node Color Mapping");
            this.copyNodeColorMappingBtn.setBorderPainted(false);
            this.copyNodeColorMappingBtn.setContentAreaFilled(false);
            this.copyNodeColorMappingBtn.setOpaque(false);
            this.copyNodeColorMappingBtn.setFocusable(false);
            this.copyNodeColorMappingBtn.setFont(iconManager.getIconFont(16.0f));
            this.copyNodeColorMappingBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return this.copyNodeColorMappingBtn;
    }

    private JLabel getTitleLbl() {
        if (this.titleLbl == null) {
            this.titleLbl = new JLabel(this.model.getTitle());
            this.titleLbl.setHorizontalAlignment(2);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleLbl});
        }
        return this.titleLbl;
    }

    public JLabel getMsgIconLbl() {
        if (this.msgIconLbl == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.msgIconLbl = new JLabel(" ");
            this.msgIconLbl.setHorizontalTextPosition(0);
            this.msgIconLbl.setPreferredSize(new Dimension(18, 15));
            this.msgIconLbl.setFont(iconManager.getIconFont(16.0f));
            this.msgIconLbl.addMouseListener(new MouseAdapter(){
                int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
                int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(1L);

                @Override
                public void mouseEntered(MouseEvent e) {
                    ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
                }
            });
        }
        return this.msgIconLbl;
    }

    static Color getBackgroundColor() {
        return UIManager.getColor("Table.background");
    }

    static Color getSelectedBackgroundColor() {
        return UIManager.getColor("Table.selectionBackground");
    }

    static Color getForegroundColor() {
        return UIManager.getColor("Table.foreground");
    }

    static Color getButtonBorderColor() {
        return UIManager.getColor("Separator.foreground");
    }

    static Color getDisabledButtonBorderColor() {
        return UIManager.getColor("Table.background");
    }

    private Icon getIcon(T value, int width, int height) {
        Object icon = null;
        RenderingEngine<?> engine = this.model.getRenderingEngine();
        if (engine != null && value != null) {
            icon = engine.createIcon(this.model.getVisualProperty(), value, width, height);
        }
        if (icon == null) {
            icon = new EmptyIcon(width, height);
        }
        return icon;
    }

    private void updateMappingPanelSize() {
        PropertySheetTable tbl = this.getPropSheetPnl().getTable();
        tbl.repaint();
        int h = 0;
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            h += tbl.getRowHeight(i);
        }
        int TOTAL_PAD = 6;
        this.getPropSheetPnl().setPreferredSize(new Dimension(tbl.getWidth() + TOTAL_PAD, h + TOTAL_PAD));
        tbl.repaint();
        this.getPropSheetPnl().repaint();
        this.getPropSheetPnl().revalidate();
        this.revalidate();
    }

    private void updateSelection() {
        this.getTopPnl().setBackground(this.selected ? VisualPropertySheetItem.getSelectedBackgroundColor() : VisualPropertySheetItem.getBackgroundColor());
        this.repaint();
    }

    private void updateMessageIcon(MessageType type) {
        String text = null;
        Color fg = null;
        if (type == MessageType.INFO) {
            text = "\uf05a";
            fg = LookAndFeelUtil.getInfoColor();
        } else if (type == MessageType.WARNING) {
            text = "\uf071";
            fg = LookAndFeelUtil.getWarnColor();
        } else if (type == MessageType.ERROR) {
            text = "\uf056";
            fg = LookAndFeelUtil.getErrorColor();
        }
        this.getMsgIconLbl().setText(text);
        this.getMsgIconLbl().setForeground(fg);
        this.getMsgIconLbl().setVisible(text != null);
    }

    private void updateMappingIcon() {
        if (!this.model.isVisualMappingAllowed()) {
            return;
        }
        JToggleButton btn = this.getMappingBtn();
        VisualMappingFunction<?, T> mapping = this.model.getVisualMappingFunction();
        String colName = mapping != null ? mapping.getMappingColumnName() : null;
        IconManager iconManager = this.servicesUtil.get(IconManager.class);
        btn.setFont(iconManager.getIconFont(16.0f));
        if (btn.isSelected()) {
            btn.setForeground(UIManager.getColor("Table.focusCellForeground"));
        } else {
            btn.setForeground(VisualPropertySheetItem.getForegroundColor());
        }
        if (mapping == null) {
            btn.setText("");
            btn.setToolTipText("No Mapping");
        } else if (mapping instanceof DiscreteMapping) {
            btn.setText(DISCRETE_ICON);
            btn.setToolTipText("Discrete Mapping for column \"" + colName + "\"");
        } else if (mapping instanceof ContinuousMapping) {
            btn.setText(CONTINUOUS_ICON);
            btn.setToolTipText("Continuous Mapping for column \"" + colName + "\"");
        } else if (mapping instanceof PassthroughMapping) {
            btn.setText(PASSTHROUGH_ICON);
            btn.setToolTipText("Passthrough Mapping for column \"" + colName + "\"");
        }
    }

    private void updateRemoveMappingBtn() {
        if (this.removeMappingBtn != null) {
            this.removeMappingBtn.setEnabled(this.model.getVisualMappingFunction() != null);
        }
    }

    private void updateMappingRowHeight() {
        if (this.model.isVisualMappingAllowed()) {
            if (this.model.getVisualMappingFunction() instanceof ContinuousMapping && this.getPropSheetTbl().getRowCount() > 2) {
                this.getPropSheetTbl().setRowHeight(2, 90);
            } else {
                this.getPropSheetTbl().setRowHeight(24);
            }
        }
    }

    private void updateDependencyCkb() {
        if (this.model.getVisualPropertyDependency() != null) {
            this.getDependencyCkb().setSelected(this.model.isDependencyEnabled());
        }
    }

    public static enum MessageType {
        INFO,
        WARNING,
        ERROR;

    }

    private class ExpandCollapseButton
    extends JButton {
        private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        private Icon collapsedIcon = UIManager.getIcon("Tree.rightToLeftCollapsedIcon");

        public ExpandCollapseButton(boolean selected, ActionListener al) {
            if (this.collapsedIcon == null) {
                this.collapsedIcon = new MirrorIcon(UIManager.getIcon("Tree.collapsedIcon"));
                this.expandedIcon = new MirrorIcon(this.expandedIcon);
            }
            this.setRequestFocusEnabled(true);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setHorizontalAlignment(4);
            Dimension d = new Dimension(this.expandedIcon.getIconWidth() + 8, this.expandedIcon.getIconHeight() + 4);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.addActionListener(al);
            this.setSelected(selected);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            this.updateIcon();
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.updateIcon();
        }

        private void updateIcon() {
            if (this.isEnabled()) {
                this.setIcon(this.isSelected() ? this.expandedIcon : this.collapsedIcon);
            } else {
                this.setIcon(null);
            }
        }
    }

    private class CustomMouseWheelListener
    implements MouseWheelListener {
        private JScrollBar bar;
        private int previousValue;
        private JScrollPane parentScrollPane;
        private JScrollPane customScrollPane;

        CustomMouseWheelListener(JScrollPane scrollPane) {
            this.customScrollPane = scrollPane;
            this.bar = this.customScrollPane.getVerticalScrollBar();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollPane parent = this.getParentScrollPane();
            if (parent != null) {
                if (e.getWheelRotation() < 0) {
                    if (this.bar.getValue() == 0 && this.previousValue == 0) {
                        parent.dispatchEvent(this.cloneEvent(e));
                    }
                } else if (this.bar.getValue() == this.getMax() && this.previousValue == this.getMax()) {
                    parent.dispatchEvent(this.cloneEvent(e));
                }
                this.previousValue = this.bar.getValue();
            } else {
                this.customScrollPane.removeMouseWheelListener(this);
            }
        }

        private int getMax() {
            return this.bar.getMaximum() - this.bar.getVisibleAmount();
        }

        private JScrollPane getParentScrollPane() {
            if (this.parentScrollPane == null) {
                Container parent;
                for (parent = this.customScrollPane.getParent(); !(parent instanceof JScrollPane) && parent != null; parent = parent.getParent()) {
                }
                this.parentScrollPane = (JScrollPane)parent;
            }
            return this.parentScrollPane;
        }

        private MouseWheelEvent cloneEvent(MouseWheelEvent e) {
            return new MouseWheelEvent((Component)this.getParentScrollPane(), e.getID(), e.getWhen(), e.getModifiersEx(), 1, 1, e.getClickCount(), false, e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        }
    }

    private class VizMapPropertySheetTable
    extends PropertySheetTable {
        private VizMapperProperty<?, ?, ?> editingVizMapperProperty;

        VizMapPropertySheetTable() {
            this.setKeyBindings();
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!VizMapPropertySheetTable.this.isEditing() && VizMapPropertySheetTable.this.editingVizMapperProperty != null) {
                        VizMapPropertySheetTable.this.editingVizMapperProperty = null;
                        VizMapPropertySheetTable.this.firePropertyChange("editingVizMapperProperty", VizMapPropertySheetTable.this.editingVizMapperProperty, null);
                    }
                }
            });
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            PropertySheetTableModel.Item selectedItem = (PropertySheetTableModel.Item)this.getValueAt(row, 0);
            VizMapperProperty prop = (VizMapperProperty)selectedItem.getProperty();
            if (prop != this.editingVizMapperProperty) {
                this.editingVizMapperProperty = prop;
                this.firePropertyChange("editingVizMapperProperty", this.editingVizMapperProperty, (Object)this.editingVizMapperProperty);
            }
            return super.prepareEditor(editor, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.isRowSelected(row) && super.isCellEditable(row, column);
        }

        public String getToolTipText(MouseEvent me) {
            Point pt = me.getPoint();
            int row = this.rowAtPoint(pt);
            if (row < 0) {
                return null;
            }
            Property prop = ((PropertySheetTableModel.Item)this.getValueAt(row, 0)).getProperty();
            if (prop == null) {
                return null;
            }
            String displayName = prop.getDisplayName();
            if (displayName.equals("Graphical View")) {
                return "Click to edit this mapping...";
            }
            if (displayName.equals("Column") || displayName.equals("Mapping Type")) {
                return prop.getDisplayName() + ": " + prop.getValue();
            }
            return "<html>" + prop.getDisplayName() + ": " + (prop.getValue() != null ? VisualPropertyUtil.getDisplayString(prop.getValue()) : "<i>default value</i>") + "</html>";
        }

        private void setKeyBindings() {
            ActionMap actionMap = this.getActionMap();
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "VK_SPACE");
            actionMap.put("VK_SPACE", new KeyAction("VK_SPACE"));
        }

        private class KeyAction
        extends AbstractAction {
            static final String VK_SPACE = "VK_SPACE";

            KeyAction(String actionCommand) {
                this.putValue("ActionCommandKey", actionCommand);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = VizMapPropertySheetTable.this.getSelectedRows();
                if (selectedRows == null || selectedRows.length == 0 || VizMapPropertySheetTable.this.isEditing()) {
                    return;
                }
                String cmd = e.getActionCommand();
                if (cmd.equals(VK_SPACE) && selectedRows.length == 1) {
                    VizMapPropertySheetTable.this.editCellAt(selectedRows[0], 1);
                }
            }
        }
    }

    static class VizMapperButton
    extends JButton {
        VizMapperButton() {
            this.setContentAreaFilled(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            VizMapperButton.paintBackground(g, this);
            super.paintComponent(g);
        }

        static void paintBackground(Graphics g, AbstractButton btn) {
            Graphics2D g2 = (Graphics2D)g.create();
            Paint p = btn.isEnabled() ? new GradientPaint(new Point(0, 0), UIManager.getColor("Button.background"), new Point(0, btn.getHeight()), UIManager.getColor("Table.background")) : UIManager.getColor("Button.background");
            g2.setPaint(p);
            g2.fillRect(0, 0, btn.getWidth(), btn.getHeight());
            g2.dispose();
        }
    }

    static class VPButtonUI
    extends BasicButtonUI {
        public static final int NORTH = 1;
        public static final int CENTER = 2;
        public static final int SOUTH = 3;
        final Color BG_OVER_COLOR = UIManager.getColor("Table.selectionBackground");
        final Color BG_SELECTED_COLOR = UIManager.getColor("Table.focusCellBackground");
        private final int anchor;
        private Border borderEnabled;
        private Border borderDisabled;

        public VPButtonUI() {
            this(2);
        }

        public VPButtonUI(int anchor) {
            this.anchor = anchor;
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            AbstractButton btn = (AbstractButton)c;
            btn.setRolloverEnabled(true);
            btn.setVerticalTextPosition(0);
            btn.setHorizontalTextPosition(0);
            btn.setVerticalAlignment(0);
            btn.setHorizontalAlignment(0);
            btn.setFocusPainted(false);
            btn.setBackground(VisualPropertySheetItem.getBackgroundColor());
            btn.setForeground(VisualPropertySheetItem.getForegroundColor());
            btn.setFocusable(false);
            btn.setCursor(new Cursor(12));
            Border padBorder = BorderFactory.createEmptyBorder(2 + (this.anchor == 1 ? 1 : 0), 4, 2 + (this.anchor == 3 ? 1 : 0), 4);
            MatteBorder border = BorderFactory.createMatteBorder(this.anchor == 1 ? 0 : 1, 1, this.anchor == 3 ? 0 : 1, 1, VisualPropertySheetItem.getButtonBorderColor());
            this.borderEnabled = BorderFactory.createCompoundBorder(border, padBorder);
            border = BorderFactory.createMatteBorder(this.anchor == 1 ? 0 : 1, 1, this.anchor == 3 ? 0 : 1, 1, VisualPropertySheetItem.getDisabledButtonBorderColor());
            this.borderDisabled = BorderFactory.createCompoundBorder(border, padBorder);
            btn.setBorder(btn.isEnabled() ? this.borderEnabled : this.borderDisabled);
            btn.addPropertyChangeListener("enabled", evt -> btn.setBorder(Boolean.TRUE.equals(evt.getNewValue()) ? this.borderEnabled : this.borderDisabled));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton btn = (AbstractButton)c;
            ButtonModel btnModel = btn.getModel();
            if (btnModel.isRollover() || btnModel.isArmed() || btnModel.isSelected()) {
                Color oldColor = g.getColor();
                if (btnModel.isSelected()) {
                    g.setColor(this.BG_SELECTED_COLOR);
                } else {
                    g.setColor(this.BG_OVER_COLOR);
                }
                g.fillRect(0, 0, c.getWidth() - 1, c.getHeight());
                g.setColor(oldColor);
            }
            super.paint(g, c);
        }

        static int getPreferredWidth() {
            return 36;
        }
    }

    static class VizMapperToggleButton
    extends JToggleButton {
        VizMapperToggleButton() {
            this.setContentAreaFilled(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            VizMapperButton.paintBackground(g, this);
            super.paintComponent(g);
        }
    }

    private class MirrorIcon
    implements Icon {
        private final Icon originalIcon;

        public MirrorIcon(Icon originalIcon) {
            this.originalIcon = originalIcon;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(this.getIconWidth(), 0);
            g2.scale(-1.0, 1.0);
            this.originalIcon.paintIcon(c, g2, x, y);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.originalIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.originalIcon.getIconHeight();
        }
    }
}

